/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.bound;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.state.EValidity;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.namespace.MapBasedNamespaceContext;
import com.phloc.schematron.pure.binding.IPSQueryBinding;
import com.phloc.schematron.pure.bound.IPSBoundSchema;
import com.phloc.schematron.pure.errorhandler.IPSErrorHandler;
import com.phloc.schematron.pure.errorhandler.LoggingPSErrorHandler;
import com.phloc.schematron.pure.model.IPSElement;
import com.phloc.schematron.pure.model.PSActive;
import com.phloc.schematron.pure.model.PSPattern;
import com.phloc.schematron.pure.model.PSPhase;
import com.phloc.schematron.pure.model.PSSchema;
import com.phloc.schematron.pure.validation.AbstractPSPartialValidationHandler;
import com.phloc.schematron.pure.validation.PSValidationHandlerBreakOnFirstError;
import com.phloc.schematron.pure.validation.SchematronValidationException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.w3c.dom.Node;

public abstract class AbstractPSBoundSchema
implements IPSBoundSchema {
    private final IPSQueryBinding m_aQueryBinding;
    private final PSSchema m_aOrigSchema;
    private final IPSErrorHandler m_aErrorHandler;
    private final MapBasedNamespaceContext m_aNamespaceContext;
    private final String m_sPhase;
    private final PSPhase m_aPhase;
    private final List<PSPattern> m_aPatterns = new ArrayList<PSPattern>();

    public AbstractPSBoundSchema(@Nonnull IPSQueryBinding iPSQueryBinding, @Nonnull PSSchema pSSchema, @Nullable String string, @Nullable IPSErrorHandler iPSErrorHandler) {
        String string2;
        ValueEnforcer.notNull((Object)iPSQueryBinding, (String)"QueryBinding");
        ValueEnforcer.notNull((Object)pSSchema, (String)"OrigSchema");
        this.m_aQueryBinding = iPSQueryBinding;
        this.m_aOrigSchema = pSSchema;
        this.m_aErrorHandler = iPSErrorHandler != null ? iPSErrorHandler : new LoggingPSErrorHandler();
        this.m_aNamespaceContext = pSSchema.getAsNamespaceContext();
        String string3 = string2 = string != null ? string : "#DEFAULT";
        if (string2.equals("#DEFAULT") && (string2 = pSSchema.getDefaultPhase()) == null) {
            string2 = "#ALL";
        }
        if (!string2.equals("#ALL")) {
            this.m_aPhase = pSSchema.getPhaseOfID(string2);
            if (this.m_aPhase == null) {
                this.warn(pSSchema, "Failed to resolve phase with ID '" + string2 + "' - default to all patterns");
            }
        } else {
            this.m_aPhase = null;
        }
        this.m_sPhase = string2;
        if (this.m_aPhase == null) {
            this.m_aPatterns.addAll(pSSchema.getAllPatterns());
        } else {
            for (PSActive pSActive : this.m_aPhase.getAllActives()) {
                String string4 = pSActive.getPattern();
                PSPattern pSPattern = pSSchema.getPatternOfID(string4);
                if (pSPattern == null) {
                    this.warn(pSSchema, "Failed to resolve pattern with ID '" + string4 + "' - ignoring this pattern in phase '" + string2 + "'");
                    continue;
                }
                this.m_aPatterns.add(pSPattern);
            }
        }
        if (this.m_aPatterns.isEmpty()) {
            if (this.m_aPhase == null) {
                this.error(pSSchema, "No patterns found in schema!");
            } else {
                this.error(pSSchema, "No patterns found in schema for phase '" + this.m_aPhase.getID() + "!");
            }
        }
    }

    @Nonnull
    protected IPSErrorHandler getErrorHandler() {
        return this.m_aErrorHandler;
    }

    @OverridingMethodsMustInvokeSuper
    protected void warn(@Nonnull IPSElement iPSElement, @Nonnull String string) {
        this.getErrorHandler().warn(this.m_aOrigSchema.getResource(), iPSElement, string);
    }

    @OverridingMethodsMustInvokeSuper
    protected void error(@Nonnull IPSElement iPSElement, @Nonnull String string) {
        this.error(iPSElement, string, null);
    }

    @OverridingMethodsMustInvokeSuper
    protected void error(@Nonnull IPSElement iPSElement, @Nonnull String string, @Nullable Throwable throwable) {
        this.getErrorHandler().error(this.m_aOrigSchema.getResource(), iPSElement, string, throwable);
    }

    @Override
    @Nonnull
    public final IPSQueryBinding getQueryBinding() {
        return this.m_aQueryBinding;
    }

    @Override
    @Nonnull
    public final PSSchema getOriginalSchema() {
        return this.m_aOrigSchema;
    }

    @Override
    @Nonnull
    public final MapBasedNamespaceContext getNamespaceContext() {
        return this.m_aNamespaceContext;
    }

    @Override
    @Nonnull
    public final String getPhaseID() {
        return this.m_sPhase;
    }

    @Override
    @Nullable
    public final PSPhase getPhase() {
        return this.m_aPhase;
    }

    @Override
    public final boolean isPhaseSpecified() {
        return this.m_aPhase != null;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final List<PSPattern> getAllRelevantPatterns() {
        return ContainerHelper.newList(this.m_aPatterns);
    }

    @Nonnull
    @OverrideOnDemand
    protected AbstractPSPartialValidationHandler createPartialValidationHandler() {
        return new PSValidationHandlerBreakOnFirstError();
    }

    @Override
    @Nonnull
    public EValidity validatePartially(@Nonnull Node node) throws SchematronValidationException {
        AbstractPSPartialValidationHandler abstractPSPartialValidationHandler = this.createPartialValidationHandler();
        this.validate(node, abstractPSPartialValidationHandler);
        return abstractPSPartialValidationHandler.getValidity();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("queryBinding", (Object)this.m_aQueryBinding).append("origSchema", (Object)this.m_aOrigSchema).appendIfNotNull("errorHandler", (Object)this.m_aErrorHandler).append("namespaceContext", (Object)this.m_aNamespaceContext).appendIfNotNull("phase", (Object)this.m_sPhase).appendIfNotNull("phase", (Object)this.m_aPhase).append("patterns", this.m_aPatterns).toString();
    }
}

