/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.error.IResourceError;
import com.phloc.commons.error.IResourceErrorGroup;
import com.phloc.commons.error.ResourceErrorGroup;
import com.phloc.commons.hierarchy.DefaultHierarchyWalkerCallback;
import com.phloc.commons.hierarchy.IHierarchyWalkerCallback;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.microdom.IMicroDocument;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.serialize.MicroReader;
import com.phloc.commons.microdom.utils.MicroWalker;
import com.phloc.commons.mutable.Wrapper;
import com.phloc.schematron.ISchematronResource;
import com.phloc.schematron.resolve.DefaultSchematronIncludeResolver;
import com.phloc.schematron.svrl.SVRLFailedAssert;
import com.phloc.schematron.svrl.SVRLUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.oclc.purl.dsdl.svrl.SchematronOutputType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@Immutable
public final class SchematronHelper {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SchematronHelper.class);
    private static final SchematronHelper s_aInstance = new SchematronHelper();

    private SchematronHelper() {
    }

    @Nullable
    public static SchematronOutputType applySchematron(@Nonnull ISchematronResource iSchematronResource, @Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iSchematronResource, (String)"SchematronResource");
        ValueEnforcer.notNull((Object)iReadableResource, (String)"XMLSource");
        try {
            return iSchematronResource.applySchematronValidationToSVRL(iReadableResource);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to apply Schematron " + (String)iSchematronResource.getID() + " onto XML resource " + iReadableResource.getResourceID(), exception);
        }
    }

    @Nullable
    public static SchematronOutputType applySchematron(@Nonnull ISchematronResource iSchematronResource, @Nonnull Source source) {
        ValueEnforcer.notNull((Object)iSchematronResource, (String)"SchematronResource");
        ValueEnforcer.notNull((Object)source, (String)"XMLSource");
        try {
            return iSchematronResource.applySchematronValidationToSVRL(source);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to apply Schematron " + (String)iSchematronResource.getID() + " onto XML source " + source, exception);
        }
    }

    @Nullable
    public static SchematronOutputType applySchematron(@Nonnull ISchematronResource iSchematronResource, @Nonnull Node node) {
        ValueEnforcer.notNull((Object)iSchematronResource, (String)"SchematronResource");
        ValueEnforcer.notNull((Object)node, (String)"Node");
        return SchematronHelper.applySchematron(iSchematronResource, new DOMSource(node));
    }

    @Nonnull
    public static IResourceErrorGroup convertToResourceErrorGroup(@Nonnull SchematronOutputType schematronOutputType, @Nullable String string) {
        ValueEnforcer.notNull((Object)schematronOutputType, (String)"SchematronOutput");
        ResourceErrorGroup resourceErrorGroup = new ResourceErrorGroup();
        for (SVRLFailedAssert sVRLFailedAssert : SVRLUtils.getAllFailedAssertions(schematronOutputType)) {
            resourceErrorGroup.addResourceError((IResourceError)sVRLFailedAssert.getAsResourceError(string));
        }
        return resourceErrorGroup;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private static void _recursiveResolveAllSchematronIncludes(@Nonnull IMicroElement iMicroElement, @Nonnull IReadableResource iReadableResource) {
        if (iMicroElement != null) {
            DefaultSchematronIncludeResolver defaultSchematronIncludeResolver = new DefaultSchematronIncludeResolver(iReadableResource);
            for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElementsRecursive()) {
                if (!"http://purl.oclc.org/dsdl/schematron".equals(iMicroElement2.getNamespaceURI()) || !iMicroElement2.getLocalName().equals("include")) continue;
                String string = iMicroElement2.getAttribute("href");
                try {
                    IMicroElement iMicroElement3;
                    IMicroDocument iMicroDocument;
                    IReadableResource iReadableResource2;
                    int n = string.indexOf(35);
                    String string2 = null;
                    if (n >= 0) {
                        string2 = string.substring(n + 1);
                        string = string.substring(0, n);
                    }
                    if ((iReadableResource2 = defaultSchematronIncludeResolver.getResolvedSchematronResource(string)) == null) {
                        throw new IllegalStateException("Failed to resolve include '" + string + "'");
                    }
                    if (s_aLogger.isDebugEnabled()) {
                        s_aLogger.debug("Resolved '" + string + "' relative to '" + defaultSchematronIncludeResolver.getBaseHref() + "' as '" + iReadableResource2.getPath() + "'");
                    }
                    if ((iMicroDocument = MicroReader.readMicroXML((IReadableResource)iReadableResource2)) == null) {
                        throw new IllegalStateException("Failed to parse include " + iReadableResource2);
                    }
                    if (string2 == null) {
                        iMicroElement3 = iMicroDocument.getDocumentElement();
                    } else {
                        final String string3 = string2;
                        final Wrapper wrapper = new Wrapper();
                        MicroWalker.walkNode((IMicroNode)iMicroDocument.getDocumentElement(), (IHierarchyWalkerCallback)new DefaultHierarchyWalkerCallback<IMicroNode>(){

                            public void onItemBeforeChildren(IMicroNode iMicroNode) {
                                IMicroElement iMicroElement;
                                String string;
                                if (iMicroNode.isElement() && string3.equals(string = (iMicroElement = (IMicroElement)iMicroNode).getAttribute("id"))) {
                                    wrapper.set((Object)iMicroElement);
                                }
                            }
                        });
                        iMicroElement3 = (IMicroElement)wrapper.get();
                        if (iMicroElement3 == null) {
                            s_aLogger.error("Failed to resolve an element with the ID '" + string2 + "' in " + iReadableResource2 + "! Including the whole document!");
                            iMicroElement3 = iMicroDocument.getDocumentElement();
                        }
                    }
                    iMicroElement3.detachFromParent();
                    SchematronHelper._recursiveResolveAllSchematronIncludes(iMicroElement3, iReadableResource2);
                    iMicroElement2.getParent().replaceChild((IMicroNode)iMicroElement2, (IMicroNode)iMicroElement3);
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Failed to read include '" + string + "'", iOException);
                }
            }
        }
    }

    @Nullable
    public static IMicroDocument getWithResolvedSchematronIncludes(@Nonnull IReadableResource iReadableResource) {
        IMicroDocument iMicroDocument = MicroReader.readMicroXML((IReadableResource)iReadableResource);
        if (iMicroDocument != null) {
            SchematronHelper._recursiveResolveAllSchematronIncludes(iMicroDocument.getDocumentElement(), iReadableResource);
        }
        return iMicroDocument;
    }
}

