/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLOutput
extends StyleElement {
    private StructuredQName outputFormatName;
    private String method = null;
    private String outputVersion = null;
    private String htmlVersion = null;
    private String indent = null;
    private String encoding = null;
    private String mediaType = null;
    private String doctypeSystem = null;
    private String doctypePublic = null;
    private String omitDeclaration = null;
    private String standalone = null;
    private String cdataElements = null;
    private String includeContentType = null;
    private String nextInChain = null;
    private String suppressIndentation = null;
    private String doubleSpace = null;
    private String representation = null;
    private String indentSpaces = null;
    private String lineLength = null;
    private String byteOrderMark = null;
    private String escapeURIAttributes = null;
    private String normalizationForm = null;
    private String recognizeBinary = null;
    private String requireWellFormed = null;
    private String undeclareNamespaces = null;
    private String useCharacterMaps = null;
    private String attributeOrder = null;
    private HashMap<String, String> userAttributes = null;

    @Override
    public boolean isDeclaration() {
        return true;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String nameAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getNodeName(a).getStructuredQName().getClarkName();
            if (f.equals("name")) {
                nameAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("method")) {
                this.method = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("version")) {
                this.outputVersion = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("html-version")) {
                this.htmlVersion = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("byte-order-mark")) {
                this.byteOrderMark = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("encoding")) {
                this.encoding = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("omit-xml-declaration")) {
                this.omitDeclaration = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("standalone")) {
                this.standalone = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("doctype-public")) {
                this.doctypePublic = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("doctype-system")) {
                this.doctypeSystem = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("cdata-section-elements")) {
                this.cdataElements = atts.getValue(a);
                continue;
            }
            if (f.equals("indent")) {
                this.indent = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("media-type")) {
                this.mediaType = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("include-content-type")) {
                this.includeContentType = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("normalization-form")) {
                this.normalizationForm = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("escape-uri-attributes")) {
                this.escapeURIAttributes = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("use-character-maps")) {
                this.useCharacterMaps = atts.getValue(a);
                continue;
            }
            if (f.equals("undeclare-prefixes")) {
                this.undeclareNamespaces = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("{http://saxon.sf.net/}character-representation")) {
                this.representation = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("{http://saxon.sf.net/}indent-spaces")) {
                this.indentSpaces = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("{http://saxon.sf.net/}line-length")) {
                this.lineLength = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("{http://saxon.sf.net/}suppress-indentation")) {
                this.suppressIndentation = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("{http://saxon.sf.net/}double-space")) {
                this.doubleSpace = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("{http://saxon.sf.net/}next-in-chain")) {
                this.nextInChain = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("{http://saxon.sf.net/}recognize-binary")) {
                this.recognizeBinary = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("{http://saxon.sf.net/}require-well-formed")) {
                this.requireWellFormed = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("{http://saxon.sf.net/}attribute-order")) {
                this.attributeOrder = Whitespace.trim(atts.getValue(a));
                continue;
            }
            String attributeURI = atts.getURI(a);
            if ("".equals(attributeURI) || "http://www.w3.org/1999/XSL/Transform".equals(attributeURI) || "http://saxon.sf.net/".equals(attributeURI)) {
                this.checkUnknownAttribute(atts.getNodeName(a));
                continue;
            }
            String name = '{' + attributeURI + '}' + atts.getLocalName(a);
            if (this.userAttributes == null) {
                this.userAttributes = new HashMap(5);
            }
            this.userAttributes.put(name, atts.getValue(a));
        }
        if (nameAtt != null) {
            try {
                this.outputFormatName = this.makeQName(nameAtt);
            }
            catch (NamespaceException err) {
                this.compileError(err.getMessage(), "XTSE1570");
            }
            catch (XPathException err) {
                this.compileError(err.getMessage(), "XTSE1570");
            }
        }
    }

    public StructuredQName getFormatQName() {
        return this.outputFormatName;
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.checkTopLevel("XTSE0010", false);
        this.checkEmpty();
    }

    @Override
    public void compileDeclaration(Compilation compilation, ComponentDeclaration decl) {
    }

    @Override
    protected void processVersionAttribute(String ns) throws XPathException {
        this.version = ((StyleElement)this.getParent()).getEffectiveVersion();
    }

    protected void gatherOutputProperties(Properties details, HashMap<String, Integer> precedences, int thisPrecedence) throws XPathException {
        String s;
        String existing;
        if (this.method != null) {
            if ("xml".equals(this.method) || "html".equals(this.method) || "text".equals(this.method) || "xhtml".equals(this.method)) {
                this.checkAndPut("method", this.method, details, precedences, thisPrecedence);
            } else {
                try {
                    String[] parts = NameChecker.getQNameParts(this.method);
                    String prefix = parts[0];
                    if (prefix.length() == 0) {
                        this.compileError("method must be xml, html, xhtml, or text, or a prefixed name", "XTSE1570");
                    } else {
                        String uri = this.getURIForPrefix(prefix, false);
                        if (uri == null) {
                            this.undeclaredNamespaceError(prefix, "XTSE0280");
                        }
                        this.checkAndPut("method", '{' + uri + '}' + parts[1], details, precedences, thisPrecedence);
                    }
                }
                catch (QNameException e) {
                    this.compileError("Invalid method name. " + e.getMessage(), "XTSE1570");
                }
            }
        }
        if (this.byteOrderMark != null) {
            this.checkAndPut("byte-order-mark", this.byteOrderMark, details, precedences, thisPrecedence);
        }
        if (this.outputVersion != null) {
            this.checkAndPut("version", this.outputVersion, details, precedences, thisPrecedence);
        }
        if (this.htmlVersion != null) {
            this.checkAndPut("html-version", this.htmlVersion, details, precedences, thisPrecedence);
        }
        if (this.indent != null) {
            this.checkAndPut("indent", this.indent, details, precedences, thisPrecedence);
        }
        if (this.indentSpaces != null) {
            this.checkAndPut("{http://saxon.sf.net/}indent-spaces", this.indentSpaces, details, precedences, thisPrecedence);
        }
        if (this.lineLength != null) {
            this.checkAndPut("{http://saxon.sf.net/}line-length", this.lineLength, details, precedences, thisPrecedence);
        }
        if (this.suppressIndentation != null) {
            existing = details.getProperty("suppress-indentation");
            if (existing == null) {
                existing = details.getProperty("{http://saxon.sf.net/}suppress-indentation");
            }
            if (existing == null) {
                existing = "";
            }
            s = SaxonOutputKeys.parseListOfNodeNames(this.suppressIndentation, this, true, false, "XTSE0280");
            details.setProperty("suppress-indentation", existing + s);
        }
        if (this.doubleSpace != null) {
            existing = details.getProperty("{http://saxon.sf.net/}double-space");
            if (existing == null) {
                existing = "";
            }
            s = SaxonOutputKeys.parseListOfNodeNames(this.doubleSpace, this, true, false, "XTSE0280");
            details.setProperty("{http://saxon.sf.net/}double-space", existing + s);
        }
        if (this.encoding != null) {
            this.checkAndPut("encoding", this.encoding, details, precedences, thisPrecedence);
        }
        if (this.mediaType != null) {
            this.checkAndPut("media-type", this.mediaType, details, precedences, thisPrecedence);
        }
        if (this.doctypeSystem != null) {
            this.checkAndPut("doctype-system", this.doctypeSystem, details, precedences, thisPrecedence);
        }
        if (this.doctypePublic != null) {
            this.checkAndPut("doctype-public", this.doctypePublic, details, precedences, thisPrecedence);
        }
        if (this.omitDeclaration != null) {
            this.checkAndPut("omit-xml-declaration", this.omitDeclaration, details, precedences, thisPrecedence);
        }
        if (this.standalone != null) {
            this.checkAndPut("standalone", this.standalone, details, precedences, thisPrecedence);
        }
        if (this.cdataElements != null) {
            existing = details.getProperty("cdata-section-elements");
            if (existing == null) {
                existing = "";
            }
            s = SaxonOutputKeys.parseListOfNodeNames(this.cdataElements, this, true, false, "XTSE0280");
            details.setProperty("cdata-section-elements", existing + s);
        }
        if (this.normalizationForm != null && !this.normalizationForm.equals("none")) {
            this.checkAndPut("normalization-form", this.normalizationForm, details, precedences, thisPrecedence);
        }
        if (this.undeclareNamespaces != null) {
            this.checkAndPut("undeclare-prefixes", this.undeclareNamespaces, details, precedences, thisPrecedence);
        }
        if (this.useCharacterMaps != null) {
            String s2 = XSLOutput.prepareCharacterMaps(this, this.useCharacterMaps, details);
            details.setProperty("use-character-maps", s2);
        }
        if (this.representation != null) {
            this.checkAndPut("{http://saxon.sf.net/}character-representation", this.representation, details, precedences, thisPrecedence);
        }
        if (this.includeContentType != null) {
            this.checkAndPut("include-content-type", this.includeContentType, details, precedences, thisPrecedence);
        }
        if (this.escapeURIAttributes != null) {
            this.checkAndPut("escape-uri-attributes", this.escapeURIAttributes, details, precedences, thisPrecedence);
        }
        if (this.nextInChain != null) {
            this.checkAndPut("{http://saxon.sf.net/}next-in-chain", this.nextInChain, details, precedences, thisPrecedence);
            this.checkAndPut("{http://saxon.sf.net/}next-in-chain-base-uri", this.getSystemId(), details, precedences, thisPrecedence);
        }
        if (this.recognizeBinary != null) {
            this.checkAndPut("{http://saxon.sf.net/}recognize-binary", this.recognizeBinary, details, precedences, thisPrecedence);
        }
        if (this.requireWellFormed != null) {
            this.checkAndPut("{http://saxon.sf.net/}require-well-formed", this.requireWellFormed, details, precedences, thisPrecedence);
        }
        if (this.attributeOrder != null) {
            existing = details.getProperty("{http://saxon.sf.net/}attribute-order");
            if (existing == null) {
                existing = "";
            }
            s = SaxonOutputKeys.parseListOfNodeNames(this.attributeOrder, this, false, false, "XTSE0280");
            details.setProperty("{http://saxon.sf.net/}attribute-order", existing + " " + s);
        }
        if (this.userAttributes != null) {
            for (Map.Entry<String, String> e : this.userAttributes.entrySet()) {
                details.setProperty(e.getKey(), e.getValue());
            }
        }
    }

    private void checkAndPut(String property, String value, Properties props, HashMap<String, Integer> precedences, int thisPrecedence) throws XPathException {
        try {
            value = SaxonOutputKeys.checkOutputProperty(property, value, this.getConfiguration(), this.isXslt30Processor());
        }
        catch (XPathException err) {
            this.compileError(err.getMessage(), "XTSE0020");
            return;
        }
        String old = props.getProperty(property);
        if (old == null) {
            props.setProperty(property, value);
            precedences.put(property, thisPrecedence);
        } else if (!old.equals(value)) {
            Integer oldPrec = precedences.get(property);
            if (oldPrec == null) {
                return;
            }
            if (oldPrec <= thisPrecedence) {
                if (oldPrec == thisPrecedence) {
                    this.compileError("Conflicting values for output property " + property, "XTSE1560");
                } else {
                    throw new IllegalStateException("Output properties must be processed in decreasing precedence order");
                }
            }
        }
    }

    public static String prepareCharacterMaps(StyleElement element, String useCharacterMaps, Properties details) throws XPathException {
        StylesheetPackage psm = element.getContainingPackage();
        String existing = details.getProperty("use-character-maps");
        if (existing == null) {
            existing = "";
        }
        String s = "";
        StringTokenizer st = new StringTokenizer(useCharacterMaps, " \t\n\r", false);
        while (st.hasMoreTokens()) {
            String displayname = st.nextToken();
            try {
                StructuredQName qName = element.makeQName(displayname);
                ComponentDeclaration decl = psm.getCharacterMap(qName);
                if (decl == null) {
                    element.compileError("No character-map named '" + displayname + "' has been defined", "XTSE1590");
                }
                s = s + " " + qName.getClarkName();
            }
            catch (NamespaceException err) {
                element.undeclaredNamespaceError(err.getPrefix(), "XTSE0280");
            }
        }
        existing = s + existing;
        return existing;
    }
}

