/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.documents.views;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IDocumentReference;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.util.FindingsServiceHolder;
import ch.elexis.core.findings.util.ValueSetServiceHolder;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.KontaktErfassenDialog;
import ch.elexis.core.ui.documents.Messages;
import ch.elexis.core.ui.documents.composites.CategorySelectionEditComposite;
import ch.elexis.core.ui.documents.provider.AuthorContentProposalProvider;
import ch.elexis.core.ui.documents.provider.ValueSetProposalProvider;
import ch.elexis.core.ui.documents.service.DocumentStoreServiceHolder;
import ch.elexis.core.ui.documents.util.AutoCompleteTextUtil;
import ch.elexis.core.ui.documents.util.ContactLabelUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentsMetaDataDialog
extends TitleAreaDialog {
    private static Logger logger = LoggerFactory.getLogger(DocumentsMetaDataDialog.class);
    String file;
    final IDocument document;
    final IDocumentReference documentReference;
    Text tTitle;
    Text tKeywords;
    Text tAuthor;
    Text tPracticeSetting;
    Text tDocumentClass;
    private CategorySelectionEditComposite csec;
    public String title;
    public String keywords;
    public String category;
    private final boolean categoryCrudAllowed;

    public DocumentsMetaDataDialog(IDocument document, Shell parent) {
        super(parent);
        Objects.requireNonNull(FindingsServiceHolder.getiFindingsService(), "Findings-Service not installed.");
        Objects.requireNonNull(ValueSetServiceHolder.getIValueSetService(), "ValueSet-Service not installed.");
        this.document = document;
        this.documentReference = this.findDocumentReference();
        this.categoryCrudAllowed = DocumentStoreServiceHolder.getService().isAllowed(document, IDocumentStore.Capability.CATEGORY);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        new Label(ret, 0).setText(Messages.DocumentView_categoryColumn);
        this.csec = new CategorySelectionEditComposite(ret, 0, this.document, this.categoryCrudAllowed);
        this.csec.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(ret, 0).setText(Messages.DocumentsView_Title);
        this.tTitle = SWTHelper.createText((Composite)ret, (int)1, (int)0);
        this.tTitle.setText(this.document.getTitle());
        this.createUIDocumentReferences(ret);
        return ret;
    }

    private void createUIDocumentReferences(Composite ret) {
        new Label(ret, 0).setText(Messages.DocumentView_keywordsColumn);
        this.tKeywords = SWTHelper.createText((Composite)ret, (int)4, (int)0);
        this.tKeywords.setText(Optional.ofNullable(Objects.toString(this.documentReference.getKeywords(), this.document.getKeywords())).orElse(""));
        new Label(ret, 0).setText(Messages.DocumentsView_Author);
        this.tAuthor = SWTHelper.createText((Composite)ret, (int)1, (int)0);
        AutoCompleteTextUtil.addAutoCompleteSupport(this.tAuthor, new AuthorContentProposalProvider(), Optional.ofNullable(this.documentReference.getAuthorId()).map(o -> CoreModelServiceHolder.get().load(o, IContact.class).orElse(null)).orElse(this.document.getAuthor()));
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new Action(ch.elexis.core.l10n.Messages.KontaktDetailDialog_newContact){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
            }

            public void run() {
                KontaktErfassenDialog dlg = new KontaktErfassenDialog(UiDesk.getTopShell(), ContactLabelUtil.getContactHints(DocumentsMetaDataDialog.this.tAuthor.getText()));
                if (dlg.open() == 0) {
                    if (dlg.getContact().isPresent()) {
                        AutoCompleteTextUtil.setValue(DocumentsMetaDataDialog.this.tAuthor, (IContact)dlg.getContact().get());
                    } else {
                        MessageDialog.openWarning((Shell)DocumentsMetaDataDialog.this.getParentShell(), (String)"", (String)"Der Kontakt konnte nicht angelegt werden.");
                    }
                }
            }

            public boolean isEnabled() {
                return !(AutoCompleteTextUtil.getData(DocumentsMetaDataDialog.this.tAuthor) instanceof IContact);
            }
        });
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IContributionItem[] items;
                IContributionItem[] iContributionItemArray = items = manager.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem iContributionItem = iContributionItemArray[n2];
                    iContributionItem.update();
                    ++n2;
                }
            }
        });
        this.tAuthor.setMenu(menuManager.createContextMenu((Control)this.tAuthor));
        new Label(ret, 0).setText(Messages.DocumentsView_DocumentClass);
        this.tDocumentClass = SWTHelper.createText((Composite)ret, (int)1, (int)0);
        AutoCompleteTextUtil.addAutoCompleteSupport(this.tDocumentClass, new ValueSetProposalProvider("EprDocumentClassCode"), this.documentReference.getDocumentClass());
        new Label(ret, 0).setText(Messages.DocumentsView_PracticeSetting);
        this.tPracticeSetting = SWTHelper.createText((Composite)ret, (int)1, (int)0);
        AutoCompleteTextUtil.addAutoCompleteSupport(this.tPracticeSetting, new ValueSetProposalProvider("EprDocumentPracticeSettingCode"), this.documentReference.getPracticeSetting());
    }

    private IDocumentReference findDocumentReference() {
        List documentReferences = FindingsServiceHolder.getiFindingsService().getDocumentFindings(this.document.getId(), IDocumentReference.class);
        if (documentReferences.size() > 1) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Got more than one DocumentReferences for document id [" + this.document.getId() + "] using first");
        }
        if (documentReferences.isEmpty()) {
            return (IDocumentReference)FindingsServiceHolder.getiFindingsService().create(IDocumentReference.class);
        }
        return (IDocumentReference)documentReferences.get(0);
    }

    public void create() {
        super.create();
        this.setTitle(this.document.getTitle());
        this.getShell().setText(Messages.DocumentMetaDataDialog_title);
        this.setMessage(Messages.DocumentMetaDataDialog_titleMessage);
    }

    protected void okPressed() {
        this.title = this.tTitle.getText();
        ICategory category = this.csec.getSelection();
        if (category != null) {
            this.document.setCategory(category);
        }
        this.document.setTitle(this.title);
        this.keywords = this.tKeywords.getText();
        this.document.setKeywords(this.keywords);
        this.document.setAuthor((IContact)AutoCompleteTextUtil.getData(this.tAuthor));
        this.saveDocumentReference();
        super.okPressed();
    }

    private void saveDocumentReference() {
        this.documentReference.setPatientId(this.document.getPatient().getId());
        this.documentReference.setDocument(this.document);
        this.documentReference.setKeywords(this.tKeywords.getText());
        this.documentReference.setAuthorId((String)Optional.ofNullable((IContact)AutoCompleteTextUtil.getData(this.tAuthor)).map(Identifiable::getId).orElse(null));
        Optional.ofNullable(AutoCompleteTextUtil.getData(this.tPracticeSetting)).ifPresent(o -> this.documentReference.setPracticeSetting((ICoding)o));
        Optional.ofNullable(AutoCompleteTextUtil.getData(this.tDocumentClass)).ifPresent(o -> this.documentReference.setDocumentClass((ICoding)o));
        FindingsServiceHolder.getiFindingsService().saveFinding((IFinding)this.documentReference);
    }
}

