/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.consumer.internal;

import com.eclipsesource.jaxrs.consumer.RequestException;
import com.eclipsesource.jaxrs.consumer.internal.ClientHelper;
import com.eclipsesource.jaxrs.consumer.internal.RequestConfigurer;
import com.eclipsesource.jaxrs.consumer.internal.RequestError;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.ContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.message.internal.MediaTypes;

public class ResourceInvocationHandler
implements InvocationHandler {
    private final Client client;
    private final String baseUrl;

    public ResourceInvocationHandler(String baseUrl, Configuration configuration) {
        this(baseUrl, ClientBuilder.newBuilder().withConfig(configuration).sslContext(ClientHelper.createSSLContext()).hostnameVerifier(ClientHelper.createHostNameVerifier()).build());
    }

    public ResourceInvocationHandler(String baseUrl, Client client) {
        this.client = client;
        this.baseUrl = baseUrl;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] parameter) throws Throwable {
        RequestConfigurer configurer = new RequestConfigurer(this.client, this.baseUrl, method, parameter);
        return this.sendRequest(method, parameter, configurer);
    }

    private Object sendRequest(Method method, Object[] parameter, RequestConfigurer configurer) {
        Object result = null;
        Invocation.Builder request = configurer.configure();
        if (method.isAnnotationPresent(GET.class)) {
            result = this.sendGetRequest(configurer, method, request);
        }
        if (method.isAnnotationPresent(POST.class)) {
            result = this.sendPostRequest(configurer, method, parameter, request);
        }
        if (method.isAnnotationPresent(PUT.class)) {
            result = this.sendPutRequest(configurer, method, parameter, request);
        }
        if (method.isAnnotationPresent(DELETE.class)) {
            result = this.sendDeleteRequest(configurer, method, request);
        }
        if (method.isAnnotationPresent(HEAD.class)) {
            result = this.sendHeadRequest(configurer, method, request);
        }
        if (method.isAnnotationPresent(OPTIONS.class)) {
            result = this.sendOptionsRequest(configurer, method, request);
        }
        return result;
    }

    private Object sendGetRequest(RequestConfigurer configurer, Method method, Invocation.Builder request) {
        this.checkHasNoFormParameter(method);
        Response response = request.get();
        this.validateResponse(configurer, response, "GET");
        return response.readEntity(method.getReturnType());
    }

    private Object sendPostRequest(RequestConfigurer configurer, Method method, Object[] parameter, Invocation.Builder request) {
        Response response = request.post(this.getPostEntity(method, parameter));
        this.validateResponse(configurer, response, "POST");
        return response.readEntity(method.getReturnType());
    }

    private Object sendPutRequest(RequestConfigurer configurer, Method method, Object[] parameter, Invocation.Builder request) {
        Response response = request.put(this.getEntity(method, parameter));
        this.validateResponse(configurer, response, "PUT");
        return response.readEntity(method.getReturnType());
    }

    private Object sendDeleteRequest(RequestConfigurer configurer, Method method, Invocation.Builder request) {
        Response response = request.delete();
        this.validateResponse(configurer, response, "DELETE");
        return response.readEntity(method.getReturnType());
    }

    private Object sendHeadRequest(RequestConfigurer configurer, Method method, Invocation.Builder request) {
        Response response = request.head();
        this.validateResponse(configurer, response, "HEAD");
        return response.readEntity(method.getReturnType());
    }

    private Object sendOptionsRequest(RequestConfigurer configurer, Method method, Invocation.Builder request) {
        Response response = request.options();
        this.validateResponse(configurer, response, "OPTIONS");
        return response.readEntity(method.getReturnType());
    }

    private void validateResponse(RequestConfigurer configurer, Response response, String method) {
        Response.Status.Family family = response.getStatusInfo().getFamily();
        if (family == Response.Status.Family.SERVER_ERROR || family == Response.Status.Family.CLIENT_ERROR) {
            RequestError requestError = new RequestError(configurer, response, method);
            throw new RequestException(requestError);
        }
    }

    private void checkHasNoFormParameter(Method method) {
        if (this.hasFormParameter(method) || this.hasMultiPartFormParameter(method)) {
            throw new IllegalStateException("@GET methods can not have @FormParam or @FormDataParam parameters.");
        }
    }

    private Entity<?> getPostEntity(Method method, Object[] parameter) {
        Entity<?> result;
        try {
            result = this.getEntity(method, parameter);
        }
        catch (IllegalStateException noEntityException) {
            result = null;
        }
        return result;
    }

    private Entity<?> getEntity(Method method, Object[] parameter) {
        Entity result = null;
        if (this.hasFormParameter(method)) {
            Form form = this.computeForm(method, parameter);
            result = Entity.form((Form)form);
        } else if (this.hasMultiPartFormParameter(method)) {
            MultiPart mp = this.computeMultiPart(method, parameter);
            result = Entity.entity((Object)mp, (MediaType)mp.getMediaType());
        } else {
            result = this.determineBodyParameter(method, parameter);
        }
        return result;
    }

    private boolean hasFormParameter(Method method) {
        return ClientHelper.hasFormAnnotation(method, FormParam.class);
    }

    private Form computeForm(Method method, Object[] parameter) {
        Form result = new Form();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        int i = 0;
        while (i < parameterAnnotations.length) {
            Annotation[] annotations = parameterAnnotations[i];
            FormParam formParam = this.extractAnnotation(annotations, FormParam.class);
            if (formParam != null) {
                result.param(formParam.value(), parameter[i].toString());
            }
            ++i;
        }
        return result.asMap().isEmpty() ? null : result;
    }

    private boolean hasMultiPartFormParameter(Method method) {
        return ClientHelper.hasFormAnnotation(method, FormDataParam.class);
    }

    private MultiPart computeMultiPart(Method method, Object[] parameter) {
        FormDataMultiPart result = new FormDataMultiPart();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        int i = 0;
        while (i < parameterAnnotations.length) {
            Annotation[] annotations = parameterAnnotations[i];
            FormDataParam param = this.extractAnnotation(annotations, FormDataParam.class);
            if (param != null) {
                result.field(param.value(), parameter[i], this.determinePartContentType(parameter[i]));
            }
            ++i;
        }
        return result.getFields().isEmpty() ? null : result;
    }

    private MediaType determinePartContentType(Object parameter) {
        if (parameter instanceof BodyPart) {
            return ((BodyPart)parameter).getMediaType();
        }
        if (parameter instanceof ContentDisposition) {
            return MediaType.valueOf((String)((ContentDisposition)parameter).getType());
        }
        return MediaType.TEXT_PLAIN_TYPE;
    }

    private <T extends Annotation> T extractAnnotation(Annotation[] annotations, Class<T> type) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType() == type) {
                return (T)((Annotation)type.cast(annotation));
            }
            ++n2;
        }
        return null;
    }

    private Entity<?> determineBodyParameter(Method method, Object[] parameter) {
        Entity result = null;
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        this.checkParametersForAnnotation(method, parameterAnnotations);
        int firstNonAnnotatedParameter = this.getFirstNonAnnotatedParameter(parameterAnnotations);
        if (firstNonAnnotatedParameter == -1) {
            throw new IllegalStateException("Can not find entity for method " + method.getName() + ". It has no non-annotated parameter");
        }
        result = Entity.entity((Object)parameter[firstNonAnnotatedParameter], (MediaType)this.determineContentType(method));
        return result;
    }

    private int getFirstNonAnnotatedParameter(Annotation[][] parameterAnnotations) {
        int firstNonAnnotatedParameter = -1;
        int i = 0;
        while (i < parameterAnnotations.length) {
            Annotation[] annotations = parameterAnnotations[i];
            if (annotations.length == 0) {
                firstNonAnnotatedParameter = i;
                break;
            }
            ++i;
        }
        return firstNonAnnotatedParameter;
    }

    private void checkParametersForAnnotation(Method method, Annotation[][] parameterAnnotations) {
        if (parameterAnnotations.length == 0) {
            throw new IllegalStateException("Can not find entity for method " + method.getName() + ". It has no paramters.");
        }
    }

    private MediaType determineContentType(Method method) {
        MediaType result = MediaType.TEXT_PLAIN_TYPE;
        if (method.isAnnotationPresent(Consumes.class)) {
            result = (MediaType)MediaTypes.createFrom((Consumes)method.getAnnotation(Consumes.class)).get(0);
        }
        return result;
    }
}

