/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail;

import ch.elexis.core.mail.AttachmentsUtil;
import ch.elexis.core.model.IImage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import com.google.gson.Gson;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.LoggerFactory;

public class MailMessage
implements Serializable {
    private static final long serialVersionUID = 5874662524515670629L;
    private static Gson gson = new Gson();
    private String to;
    private String cc;
    private String subject;
    private String text;
    private String attachmentsString;
    private String documentsString;
    private String imageString;

    public static MailMessage fromJson(Serializable serializable) {
        try {
            String valueToString = JSONObject.valueToString((Object)serializable);
            return (MailMessage)gson.fromJson(valueToString, MailMessage.class);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public MailMessage to(String to) {
        this.setTo(to);
        return this;
    }

    public MailMessage cc(String cc) {
        this.setCc(cc);
        return this;
    }

    public MailMessage subject(String subject) {
        this.setSubject(subject);
        return this;
    }

    public MailMessage text(String text) {
        this.setText(text);
        return this;
    }

    public String getTo() {
        return this.to;
    }

    public String getCc() {
        return this.cc;
    }

    public InternetAddress[] getToAddress() throws AddressException {
        if (StringUtils.isNotEmpty((String)this.getTo())) {
            return InternetAddress.parse((String)this.getTo());
        }
        return new InternetAddress[0];
    }

    public InternetAddress[] getCcAddress() throws AddressException {
        if (StringUtils.isNotEmpty((String)this.getCc())) {
            return InternetAddress.parse((String)this.getCc());
        }
        return new InternetAddress[0];
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getText() {
        return this.text;
    }

    public String getHtmlText() {
        return this.text.replace("\n", "<br />\n");
    }

    public void setText(String text) {
        this.text = text;
        this.parseImage();
    }

    private void parseImage() {
        if (StringUtils.isNotEmpty((String)this.text) && this.text.indexOf("<img src=\"") != -1) {
            char[] characters;
            StringBuilder sb = new StringBuilder();
            char[] cArray = characters = this.text.substring(this.text.indexOf("<img src=\"")).toCharArray();
            int n = characters.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                sb.append(c);
                if (c == '>') break;
                ++n2;
            }
            if (sb.toString().endsWith(">")) {
                this.imageString = sb.toString();
                if (!this.loadImage().isPresent()) {
                    LoggerFactory.getLogger(this.getClass()).warn("Image for [" + this.imageString + "] not found");
                }
            }
        }
    }

    public boolean hasAttachments() {
        return StringUtils.isNotBlank((String)this.documentsString) || StringUtils.isNotBlank((String)this.attachmentsString);
    }

    public List<File> getAttachments() {
        String attachmentFilesString = this.attachmentsString;
        if (StringUtils.isNotBlank((String)attachmentFilesString) && !StringUtils.isBlank((String)this.documentsString)) {
            attachmentFilesString = String.valueOf(attachmentFilesString) + ":::" + AttachmentsUtil.toAttachments(this.documentsString);
        } else if (!StringUtils.isBlank((String)this.documentsString)) {
            attachmentFilesString = AttachmentsUtil.toAttachments(this.documentsString);
        }
        return AttachmentsUtil.getAttachmentsFiles(attachmentFilesString);
    }

    public void setAttachments(String attachments) {
        this.attachmentsString = attachments;
    }

    public String getAttachmentsString() {
        return this.attachmentsString;
    }

    public void setDocuments(String documents) {
        this.documentsString = documents;
    }

    public String getDocumentsString() {
        return this.documentsString;
    }

    public boolean hasImage() {
        return StringUtils.isNotBlank((String)this.imageString) && this.loadImage().isPresent();
    }

    private Optional<IImage> loadImage() {
        IQuery query = CoreModelServiceHolder.get().getQuery(IImage.class);
        query.and("prefix", IQuery.COMPARATOR.EQUALS, (Object)"ch.elexis.core.mail");
        query.and("title", IQuery.COMPARATOR.LIKE, (Object)(String.valueOf(this.getImageContentId()) + "%"));
        return query.executeSingleResult();
    }

    public File getImage() {
        Optional<IImage> image = this.loadImage();
        if (image.isPresent()) {
            return AttachmentsUtil.getAttachmentsFile(image.get());
        }
        return null;
    }

    public String getImageContentId() {
        return this.imageString.substring(this.imageString.indexOf("cid:") + "cid:".length(), this.imageString.length() - 2);
    }
}

