/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.controls;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.data.LabGroup;
import ch.elexis.data.LabItem;
import ch.elexis.data.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class LabItemTreeSelectionComposite
extends Composite {
    private static final int LINES_TO_SHOW = 20;
    private ListenerList listenerList = new ListenerList();
    private LabItemsViewerFilter filter = new LabItemsViewerFilter();
    private LabItemsContentProvider contentProvider = new LabItemsContentProvider();
    private ILabelProvider labelProvider;
    ArrayList<GroupItem> checkState = new ArrayList();
    private ContainerCheckedTreeViewer laborViewer = null;
    private Text filterText;
    private boolean addCustomGroups;

    public LabItemTreeSelectionComposite(Composite parent, ILabelProvider labelProvider, int style) {
        this(parent, labelProvider, false, style);
    }

    public LabItemTreeSelectionComposite(Composite parent, ILabelProvider labelProvider, boolean addCustomGroups, int style) {
        super(parent, style);
        this.labelProvider = labelProvider;
        this.addCustomGroups = addCustomGroups;
        this.setLayout((Layout)new GridLayout(1, false));
        this.filterText = new Text((Composite)this, 128);
        this.filterText.setMessage("Filter");
        GridData data = new GridData(768);
        this.filterText.setLayoutData((Object)data);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LabItemTreeSelectionComposite.this.filterText.getText().length() > 1) {
                    LabItemTreeSelectionComposite.this.filter.setSearchText(LabItemTreeSelectionComposite.this.filterText.getText());
                    LabItemTreeSelectionComposite.this.laborViewer.refresh();
                } else {
                    LabItemTreeSelectionComposite.this.filter.setSearchText("");
                    LabItemTreeSelectionComposite.this.laborViewer.refresh();
                }
                LabItemTreeSelectionComposite.this.restoreLeafCheckState();
                LabItemTreeSelectionComposite.this.fireSelectionChanged();
            }
        });
        this.laborViewer = new ContainerCheckedTreeViewer((Composite)this, 2818);
        this.laborViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!event.getChecked() && LabItemTreeSelectionComposite.this.checkState != null) {
                    Iterator<GroupItem> iter = LabItemTreeSelectionComposite.this.checkState.iterator();
                    ArrayList<GroupItem> toRemove = new ArrayList<GroupItem>(1);
                    if (event.getElement() instanceof GroupItem) {
                        while (iter.hasNext()) {
                            GroupItem element = iter.next();
                            if (!element.equals(event.getElement())) continue;
                            toRemove.add(element);
                        }
                    } else if (event.getElement() instanceof Group) {
                        toRemove.addAll(((Group)event.getElement()).getItems());
                    }
                    LabItemTreeSelectionComposite.this.checkState.removeAll(toRemove);
                } else if (event.getChecked()) {
                    LabItemTreeSelectionComposite.this.rememberLeafCheckState(event);
                }
                LabItemTreeSelectionComposite.this.fireSelectionChanged();
            }
        });
        GridData gd = new GridData(768);
        gd.heightHint = this.laborViewer.getTree().getItemHeight() * 20;
        this.laborViewer.getControl().setLayoutData((Object)gd);
        ViewerFilter[] filters = new ViewerFilter[]{this.filter};
        this.laborViewer.setFilters(filters);
        this.laborViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.laborViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.laborViewer.setInput(this.loadItems());
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listenerList.add((Object)listener);
    }

    private void fireSelectionChanged() {
        Object[] listeners;
        Object[] objectArray = listeners = this.listenerList.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof ISelectionChangedListener) {
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this.laborViewer, (ISelection)new StructuredSelection(this.getSelectedItems()));
                ((ISelectionChangedListener)object).selectionChanged(event);
            }
            ++n2;
        }
    }

    private void rememberLeafCheckState(CheckStateChangedEvent event) {
        Object[] checked = this.laborViewer.getCheckedElements();
        if (this.checkState == null) {
            this.checkState = new ArrayList(checked.length);
        }
        int i = 0;
        while (i < checked.length) {
            if (!this.laborViewer.getGrayed(checked[i]) && !this.checkState.contains(checked[i])) {
                if (checked[i] instanceof GroupItem) {
                    this.checkState.add((GroupItem)checked[i]);
                } else if (checked[i] instanceof Group && event.getElement() == checked[i]) {
                    this.checkState.addAll(((Group)checked[i]).getItems());
                }
            }
            ++i;
        }
    }

    private void restoreLeafCheckState() {
        if (this.laborViewer == null || this.laborViewer.getTree().isDisposed()) {
            return;
        }
        if (this.checkState == null) {
            return;
        }
        this.laborViewer.setCheckedElements(new Object[0]);
        this.laborViewer.setGrayedElements(new Object[0]);
        Iterator<GroupItem> iter = this.checkState.iterator();
        GroupItem element = null;
        Object[] expanded = null;
        if (iter.hasNext()) {
            expanded = this.laborViewer.getExpandedElements();
            this.laborViewer.expandAll();
        }
        while (iter.hasNext()) {
            element = iter.next();
            this.laborViewer.setChecked((Object)element, true);
        }
        this.laborViewer.collapseAll();
        if (expanded != null) {
            this.laborViewer.setExpandedElements(expanded);
        }
    }

    public List<GroupItem> getSelectedItems() {
        return new ArrayList<GroupItem>(this.checkState);
    }

    private Hashtable<String, Group> loadItems() {
        Hashtable<String, Group> allGroups = new Hashtable<String, Group>();
        Query query = new Query(LabItem.class, "LABORITEMS", false, new String[]{"Gruppe", "kuerzel", "titel"});
        List lItems = query.execute();
        if (lItems == null) {
            return allGroups;
        }
        if (!ConfigServiceHolder.getUser((String)"lab/showGroupsOnly", (boolean)false)) {
            for (LabItem it : lItems) {
                String groupName = it.getGroup();
                Group group = allGroups.get(groupName);
                if (group == null) {
                    group = new Group(groupName, new ArrayList<LabItem>());
                    allGroups.put(groupName, group);
                }
                group.addItem(it);
            }
        }
        if (this.addCustomGroups) {
            allGroups.putAll(this.loadCustomGroups());
        }
        return allGroups;
    }

    private Hashtable<String, Group> loadCustomGroups() {
        Hashtable<String, Group> customGroups = new Hashtable<String, Group>();
        Query query = new Query(LabGroup.class);
        query.orderBy(false, new String[]{"Name"});
        List labGroups = query.execute();
        if (labGroups != null) {
            for (LabGroup labGroup : labGroups) {
                Group group = new Group(labGroup);
                customGroups.put(labGroup.getName(), group);
            }
        }
        return customGroups;
    }

    public static class Group {
        String name;
        String shortName;
        private List<GroupItem> items;
        private boolean sorted;

        Group(String name, List<LabItem> labItems) {
            this.name = name;
            this.items = this.createGroupItems(labItems);
            String[] gn = name.split(" +");
            this.shortName = gn.length > 1 ? gn[1] : "? " + name + " ?";
            this.sorted = false;
        }

        public void addItem(LabItem labItem) {
            if (this.items == null) {
                this.items = new ArrayList<GroupItem>();
            }
            this.items.add(new GroupItem(this.name, labItem));
        }

        Group(LabGroup labGroup) {
            this.shortName = this.name = labGroup.getName();
            List labItems = labGroup.getItems();
            this.items = this.createGroupItems(labItems);
        }

        public List<GroupItem> getItems() {
            if (!this.sorted) {
                Collections.sort(this.items, new Comparator<GroupItem>(){

                    @Override
                    public int compare(GroupItem left, GroupItem right) {
                        String prio1 = left.getLabItemPrio().orElse("");
                        String prio2 = right.getLabItemPrio().orElse("");
                        if (StringUtils.isNumeric((String)prio1) && StringUtils.isNumeric((String)prio2)) {
                            try {
                                return Integer.valueOf(prio1).compareTo(Integer.valueOf(prio2));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        return prio1.compareTo(prio2);
                    }
                });
                this.sorted = true;
            }
            return this.items;
        }

        private List<GroupItem> createGroupItems(List<LabItem> labItems) {
            ArrayList<GroupItem> groupItems = new ArrayList<GroupItem>();
            for (LabItem labItem : labItems) {
                groupItems.add(new GroupItem(this.name, labItem));
            }
            return groupItems;
        }

        public String toString() {
            return this.shortName;
        }
    }

    public static class GroupItem {
        private String groupname;
        private LabItem labItem;

        public GroupItem(String groupname, LabItem labItem) {
            this.setGroupname(groupname);
            this.setLabItem(labItem);
        }

        public LabItem getLabItem() {
            return this.labItem;
        }

        public void setLabItem(LabItem labItem) {
            this.labItem = labItem;
        }

        public String getGroupname() {
            return this.groupname;
        }

        public void setGroupname(String groupname) {
            this.groupname = groupname;
        }

        public Optional<String> getLabItemPrio() {
            if (this.labItem != null) {
                return Optional.ofNullable(this.labItem.getPrio());
            }
            return Optional.empty();
        }
    }

    private static class LabItemsContentProvider
    implements ITreeContentProvider {
        private Hashtable<String, Group> items;

        private LabItemsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Group> ret = new ArrayList<Group>();
            ret.addAll(this.items.values());
            Collections.sort(ret, new Comparator<Group>(){

                @Override
                public int compare(Group o1, Group o2) {
                    return o1.shortName.compareTo(o2.shortName);
                }
            });
            return ret.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Group) {
                Group group = (Group)parentElement;
                return group.getItems().toArray();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Group;
        }

        public Object[] getParent(Object element) {
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof Hashtable) {
                this.items = (Hashtable)newInput;
            }
        }
    }

    private class LabItemsViewerFilter
    extends ViewerFilter {
        protected String searchString;

        private LabItemsViewerFilter() {
        }

        public void setSearchText(String s) {
            this.searchString = ".*" + s + ".*";
        }

        private boolean isSelect(Object leaf) {
            String label = LabItemTreeSelectionComposite.this.labelProvider.getText(leaf);
            return label != null && label.toLowerCase().matches(this.searchString.toLowerCase());
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.searchString == null || this.searchString.length() == 0) {
                return true;
            }
            StructuredViewer sviewer = (StructuredViewer)viewer;
            ITreeContentProvider provider = (ITreeContentProvider)sviewer.getContentProvider();
            Object[] children = provider.getChildren(element);
            if (children != null && children.length > 0) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (this.select(viewer, element, child)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return this.isSelect(element);
        }
    }
}

