/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.datasource.internal;

import ch.elexis.core.common.DBConnection;
import ch.elexis.core.constants.ElexisEnvironmentPropertyConstants;
import ch.elexis.core.jpa.datasource.internal.ElexisPoolingDataSource;
import ch.elexis.core.jpa.datasource.test.TestDatabaseConnection;
import ch.elexis.core.services.IElexisDataSource;
import ch.elexis.core.status.ObjectStatus;
import ch.elexis.core.utils.CoreUtil;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"id=default"})
public class ElexisDataSourceService
implements IElexisDataSource {
    private static Logger log = LoggerFactory.getLogger(ElexisDataSourceService.class);
    private static ServiceRegistration<DataSource> servReg;
    private static ElexisPoolingDataSource currentDataSource;
    private IStatus connectionStatus;

    @Activate
    public void activate() {
        System.out.println("Activating ElexisDataSourceService ...");
        log.debug("Activating ...");
        if (CoreUtil.isTestMode()) {
            log.warn("- test-mode -");
            this.connectionStatus = this.setDBConnection(new TestDatabaseConnection());
            if (!this.connectionStatus.isOK()) {
                log.error("Error setting db connection", (Object)this.connectionStatus.getMessage());
                System.out.println("ERROR " + this.connectionStatus.getMessage());
            }
            return;
        }
        DBConnection connection = this.getEnvironmentProvidedDbConnection();
        if (connection != null) {
            log.info("Initializing Database connection via environment variables.");
            this.connectionStatus = this.setDBConnection(connection);
            if (!this.connectionStatus.isOK()) {
                log.error("Error setting db connection", (Object)this.connectionStatus.getMessage());
                System.out.println("ERROR " + this.connectionStatus.getMessage());
            }
        }
    }

    public IStatus setDBConnection(DBConnection dbConnection) {
        int code = 3;
        if (dbConnection instanceof TestDatabaseConnection) {
            code = 1;
        } else if (dbConnection instanceof ElexisEnvironmentDBConnection) {
            code = 2;
        }
        log.info("setDBConnection [{}] " + dbConnection, (Object)code);
        try {
            if (servReg != null) {
                log.info("Unregistering service registration");
                currentDataSource.deactivate();
                servReg.unregister();
                servReg = null;
                currentDataSource = null;
            }
            currentDataSource = new ElexisPoolingDataSource(dbConnection);
            currentDataSource.activate();
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("id", "default");
            servReg = FrameworkUtil.getBundle(this.getClass()).getBundleContext().registerService(DataSource.class, (Object)currentDataSource, properties);
            this.connectionStatus = new ObjectStatus(0, "ch.elexis.core.jpa.datasource", code, "ok", null, (Object)dbConnection);
            return this.connectionStatus;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            this.connectionStatus = new ObjectStatus(4, "ch.elexis.core.jpa.datasource", code, e.getMessage(), (Throwable)e, (Object)dbConnection);
            return this.connectionStatus;
        }
    }

    private DBConnection getEnvironmentProvidedDbConnection() {
        Map<String, String> env = System.getenv();
        String dbType = env.get(ElexisEnvironmentPropertyConstants.DB_TYPE);
        String dbHost = env.get(ElexisEnvironmentPropertyConstants.DB_HOST);
        String dbDatabase = env.get(ElexisEnvironmentPropertyConstants.DB_DATABASE);
        String dbUsername = env.get(ElexisEnvironmentPropertyConstants.DB_USERNAME);
        String dbPassword = env.get(ElexisEnvironmentPropertyConstants.DB_PASSWORD);
        if (StringUtils.isNotBlank((CharSequence)dbType) && StringUtils.isNotBlank((CharSequence)dbHost) && StringUtils.isNotBlank((CharSequence)dbDatabase) && StringUtils.isNotBlank((CharSequence)dbUsername) && StringUtils.isNotBlank((CharSequence)dbPassword)) {
            Optional dbTypeType = DBConnection.DBType.valueOfIgnoreCase((String)dbType);
            if (dbTypeType.isPresent()) {
                return new ElexisEnvironmentDBConnection((DBConnection.DBType)dbTypeType.get(), dbHost, dbDatabase, dbUsername, dbPassword, env.get(ElexisEnvironmentPropertyConstants.DB_JDBC_PARAMETER_STRING));
            }
            log.warn("Can not resolve dbType [{}], ignoring environment variable set connection", (Object)dbType);
        }
        return null;
    }

    public ObjectStatus getCurrentConnectionStatus() {
        if (this.connectionStatus instanceof ObjectStatus) {
            return (ObjectStatus)this.connectionStatus;
        }
        if (this.connectionStatus != null) {
            return new ObjectStatus(this.connectionStatus, null);
        }
        return null;
    }

    private class ElexisEnvironmentDBConnection
    extends DBConnection {
        private static final long serialVersionUID = -3727881455745909885L;

        public ElexisEnvironmentDBConnection(DBConnection.DBType dbType, String dbHost, String dbDatabase, String dbUsername, String dbPassword, String jdbcParameterString) {
            this.rdbmsType = dbType;
            this.databaseName = dbDatabase;
            this.username = dbUsername;
            this.password = dbPassword;
            this.connectionString = "jdbc:" + dbType.dbType.toLowerCase() + "://" + dbHost + "/" + dbDatabase;
            if (StringUtils.isNotBlank((CharSequence)jdbcParameterString)) {
                this.connectionString = String.valueOf(this.connectionString) + "?" + jdbcParameterString;
            }
        }
    }
}

