/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.eigendiagnosen;

import ch.elexis.core.model.IDiagnosisTree;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.eigendiagnosen.Messages;
import ch.elexis.core.ui.eigendiagnosen.ModelServiceHolder;
import ch.elexis.core.ui.util.LabeledInputField;
import ch.elexis.core.ui.views.IDetailDisplay;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class EigendiagnoseDetailDisplay
implements IDetailDisplay {
    Form form;
    LabeledInputField.AutoForm tblPls;
    LabeledInputField.InputData[] data = new LabeledInputField.InputData[]{new LabeledInputField.InputData(Messages.EigendiagnoseSelector_Shortcut_Label, "code", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.EigendiagnoseSelector_Text_Label, "text", LabeledInputField.InputData.Typ.STRING, null)};
    Text tComment;

    public Composite createDisplay(Composite parent, IViewSite site) {
        this.form = UiDesk.getToolkit().createForm(parent);
        TableWrapLayout twl = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)twl);
        this.tblPls = new LabeledInputField.AutoForm(this.form.getBody(), this.data);
        this.tblPls.setModelService(ModelServiceHolder.get());
        TableWrapData twd = new TableWrapData(256);
        twd.grabHorizontal = true;
        this.tblPls.setLayoutData((Object)twd);
        TableWrapData twd2 = new TableWrapData(256);
        this.tComment = UiDesk.getToolkit().createText(this.form.getBody(), "", 2048);
        this.tComment.setLayoutData((Object)twd2);
        return this.form.getBody();
    }

    public void display(Object obj) {
        if (obj instanceof IDiagnosisTree) {
            IDiagnosisTree diag = (IDiagnosisTree)obj;
            this.form.setText(diag.getLabel());
            this.tblPls.reload((Identifiable)diag);
            this.tComment.setText(diag.getDescription());
        } else {
            this.form.setText("");
            this.tblPls.reload(null);
            this.tComment.setText("");
        }
    }

    public Class<?> getElementClass() {
        return IDiagnosisTree.class;
    }

    @Inject
    public void selection(@Optional @Named(value="ch.elexis.core.ui.eigendiagnosen.selection") IDiagnosisTree diagnose) {
        this.display(diagnose);
    }

    public String getTitle() {
        return Messages.Eigendiagnosen_CodeSystemName;
    }
}

