/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.internal;

import ch.elexis.core.findings.util.internal.JsonStructuralFeature;
import ch.elexis.core.findings.util.internal.JsonStructuralFeatureTransformation;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class FindingsFormat {
    protected HashMap<String, Map<String, JsonStructuralFeature>> resourceFieldsMap = new HashMap();
    protected GsonBuilder gsonBuilder = new GsonBuilder();

    protected Gson getGson() {
        return this.gsonBuilder.create();
    }

    protected JsonObject getJsonObject(String content) {
        return (JsonObject)this.getGson().fromJson(content, JsonObject.class);
    }

    public HashMap<String, Map<String, JsonStructuralFeature>> getResourceFieldsMap() {
        return this.resourceFieldsMap;
    }

    public abstract int isFindingsFormat(String var1);

    public abstract Optional<String> convertToCurrentFormat(String var1);

    protected int checkFields(Map<String, JsonStructuralFeature> structuralFeatureMap, JsonObject jsonObject) {
        int matches = 0;
        for (Map.Entry entry : jsonObject.entrySet()) {
            JsonStructuralFeature structuralFeature = structuralFeatureMap.get(entry.getKey());
            if (structuralFeature == null || !structuralFeature.isSameType((JsonElement)entry.getValue())) continue;
            ++matches;
        }
        return matches;
    }

    protected Optional<String> convert(Map<String, JsonStructuralFeatureTransformation> transformMap, JsonObject jsonObject) {
        JsonObject newObject = new JsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            JsonStructuralFeatureTransformation transformation = transformMap.get(entry.getKey());
            if (transformation != null) {
                newObject.add(transformation.transformKey((String)entry.getKey()), transformation.transformValue((JsonElement)entry.getValue()));
                continue;
            }
            newObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return Optional.of(this.getGson().toJson((JsonElement)newObject));
    }
}

