/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.handlers;

import ch.elexis.core.mail.TaskUtil;
import ch.elexis.core.mail.ui.client.MailClientComponent;
import ch.elexis.core.mail.ui.handlers.EncounterUtil;
import ch.elexis.core.mail.ui.handlers.OutboxUtil;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.tasks.model.ITask;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class SendMailTaskWithProgress {
    private ITask task;

    public ITask execute(final Shell activeShell, final ITaskDescriptor taskDescriptor) {
        try {
            new ProgressMonitorDialog(activeShell).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask("Send Mail ...", -1);
                        SendMailTaskWithProgress.this.task = TaskUtil.executeTaskSync((ITaskDescriptor)taskDescriptor, (IProgressMonitor)monitor);
                        if (SendMailTaskWithProgress.this.task.isSucceeded()) {
                            OutboxUtil.getOrCreateElement(taskDescriptor, true);
                            EncounterUtil.addMailToEncounter(taskDescriptor);
                        }
                        monitor.done();
                    }
                    catch (TaskException e) {
                        MessageDialog.openError((Shell)activeShell, (String)"Fehler", (String)"Versenden konnte nicht gestartet werden.");
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            MessageDialog.openError((Shell)activeShell, (String)"Fehler", (String)"Versenden konnte nicht gestartet werden.");
        }
        if (!this.task.isSucceeded()) {
            String errorMessage = MailClientComponent.getLastErrorMessage();
            if (errorMessage.isEmpty()) {
                MessageDialog.openError((Shell)activeShell, (String)"Fehler", (String)"Versenden konnte nicht gestartet werden.");
            } else {
                MessageDialog.openError((Shell)activeShell, (String)"Fehler", (String)errorMessage);
            }
        } else {
            MessageDialog.openInformation((Shell)activeShell, (String)"E-Mail versand", (String)"E-Mail erfolgreich versendet.");
        }
        return this.task;
    }
}

