/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.timing;

import com.phloc.commons.state.EChange;
import com.phloc.commons.state.IStoppable;
import com.phloc.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class StopWatch
implements IStoppable,
Serializable {
    public static final boolean DEFAULT_START = false;
    private long m_nStartDT;
    private long m_nDurationNanos;

    public StopWatch() {
        this(false);
    }

    public StopWatch(boolean bl) {
        if (bl) {
            this.start();
        }
    }

    @Nonnull
    public EChange reset() {
        if (this.m_nDurationNanos == 0L) {
            return EChange.UNCHANGED;
        }
        this.m_nDurationNanos = 0L;
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange start() {
        if (this.m_nStartDT > 0L) {
            return EChange.UNCHANGED;
        }
        this.m_nStartDT = System.nanoTime();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange stop() {
        if (this.m_nStartDT == 0L) {
            return EChange.UNCHANGED;
        }
        this.m_nDurationNanos += System.nanoTime() - this.m_nStartDT;
        this.m_nStartDT = 0L;
        return EChange.CHANGED;
    }

    public void restart() {
        this.stop();
        this.reset();
        this.start();
    }

    public boolean isStarted() {
        return this.m_nStartDT > 0L;
    }

    public boolean isStopped() {
        return this.m_nStartDT == 0L;
    }

    public long getNanos() {
        return this.m_nDurationNanos;
    }

    public long getMillis() {
        return this.m_nDurationNanos / 1000000L;
    }

    public long getSeconds() {
        return this.m_nDurationNanos / 1000000000L;
    }

    public long stopAndGetNanos() {
        this.stop();
        return this.getNanos();
    }

    public long stopAndGetMillis() {
        this.stop();
        return this.getMillis();
    }

    public long stopAndGetSeconds() {
        this.stop();
        return this.getSeconds();
    }

    public String toString() {
        return new ToStringGenerator(this).append("startDT", this.m_nStartDT).append("duration", this.m_nDurationNanos).toString();
    }
}

