/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.cache.IPersistentObjectCache;
import ch.elexis.core.data.cache.MultiGuavaCache;
import ch.rgw.tools.JdbcLink;
import java.io.IOException;
import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBConnection {
    private static Logger logger = LoggerFactory.getLogger(DBConnection.class);
    public static final int CACHE_DEFAULT_LIFETIME = 15;
    public static final int CACHE_MIN_LIFETIME = 5;
    public static final int CACHE_TIME_MAX = 300;
    protected int default_lifetime = CoreHub.localCfg.get("ablauf/cachelifetime", 15);
    private IPersistentObjectCache<String> cache;
    private JdbcLink jdbcLink;
    private String username;
    private String pcname;
    private String tracetable;
    private boolean runningFromScratch = false;
    private String dbUser;
    private String dbPw;
    private String dbFlavor;
    private String dbConnectString;
    private String dbDriver;

    public DBConnection() {
        if (this.default_lifetime < 5) {
            this.default_lifetime = 5;
            CoreHub.localCfg.set("ablauf/cachelifetime", 5);
        }
        this.cache = new MultiGuavaCache<String>(this.default_lifetime, TimeUnit.SECONDS);
        logger.info("Cache setup: default_lifetime " + this.default_lifetime);
    }

    public void setDBPassword(String password) {
        this.dbPw = password;
    }

    public void setDBUser(String username) {
        this.dbUser = username;
    }

    public void setDBFlavor(String dbFlavor) {
        this.dbFlavor = dbFlavor;
    }

    public String getDBFlavor() {
        return this.jdbcLink.DBFlavor;
    }

    public String getDBConnectString() {
        if (this.jdbcLink != null) {
            return this.jdbcLink.getConnectString();
        }
        return this.dbConnectString;
    }

    public void setDBConnectString(String connectString) {
        this.dbConnectString = connectString;
    }

    public void setDBDriver(String driver) {
        this.dbDriver = driver;
    }

    public String getDBDriver() {
        return this.dbDriver;
    }

    public boolean isDirectConnectConfigured() {
        return this.dbFlavor != null && this.dbFlavor.length() >= 2 && this.dbConnectString != null && this.dbConnectString.length() > 5 && this.dbUser != null && this.dbPw != null;
    }

    public boolean directConnect() {
        String msg2 = "Connecting to DB using " + this.dbFlavor + " " + this.dbConnectString + " " + this.dbUser;
        logger.info(msg2);
        this.dbDriver = this.dbFlavor.equalsIgnoreCase("mysql") ? "com.mysql.cj.jdbc.Driver" : (this.dbFlavor.equalsIgnoreCase("postgresql") ? "org.postgresql.Driver" : (this.dbFlavor.equalsIgnoreCase("h2") ? "org.h2.Driver" : "invalid"));
        if (!this.dbDriver.equalsIgnoreCase("invalid")) {
            this.jdbcLink = new JdbcLink(this.dbDriver, this.dbConnectString, this.dbFlavor);
            boolean ret = this.jdbcLink.connect(this.dbUser, this.dbPw);
            if (ret) {
                logger.debug("Verbunden mit " + this.dbDriver + ", " + this.dbConnectString);
            } else {
                logger.debug("Verbindung fehlgeschlagen mit " + this.dbDriver + ", " + this.dbConnectString);
            }
            return ret;
        }
        msg2 = "can't connect to test database invalid. dbFlavor" + this.dbFlavor;
        logger.error(msg2);
        return false;
    }

    public void setJdbcLink(JdbcLink jdbcLink) {
        this.jdbcLink = jdbcLink;
    }

    public void createH2Link(String string) {
        this.jdbcLink = JdbcLink.createH2Link((String)string);
    }

    public boolean connect() {
        if (this.jdbcLink == null && this.dbDriver != null && this.dbConnectString != null && this.dbFlavor != null) {
            this.applyMySqlTimeZoneWorkaround();
            this.jdbcLink = new JdbcLink(this.dbDriver, this.dbConnectString, this.dbFlavor);
        } else if (this.jdbcLink == null && this.dbConnectString != null && this.dbFlavor == null && this.dbDriver == null && this.parseConnectString()) {
            return this.directConnect();
        }
        if (this.jdbcLink != null && this.dbUser != null && this.dbPw != null) {
            boolean ret = this.jdbcLink.connect(this.dbUser, this.dbPw);
            if (ret) {
                logger.debug("Verbunden mit " + this.dbDriver + ", " + this.dbConnectString);
            } else {
                logger.debug("Verbindung fehlgeschlagen mit " + this.dbDriver + ", " + this.dbConnectString);
            }
            return ret;
        }
        return false;
    }

    private boolean parseConnectString() {
        if (this.dbConnectString != null && this.dbConnectString.length() > 5) {
            String url = this.dbConnectString;
            String cleanURI = url.substring(5);
            URI uri = URI.create(cleanURI);
            this.setDBFlavor(uri.getScheme());
            return true;
        }
        return false;
    }

    public void setRunningFromScratch(boolean runningFromScratch) {
        this.runningFromScratch = runningFromScratch;
    }

    public boolean isRunningFromScratch() {
        return this.runningFromScratch;
    }

    public void runFromScatch() throws IOException {
        logger.info("RunFromScratch test database created in mem");
        this.dbUser = "sa";
        this.dbPw = "";
        this.jdbcLink = JdbcLink.createH2Link((String)"jdbc:h2:mem:elexisFromScratch;DB_CLOSE_DELAY=-1");
    }

    public void disconnect() {
        if (this.jdbcLink.DBFlavor.startsWith("hsqldb")) {
            this.jdbcLink.exec("SHUTDOWN COMPACT");
        }
        this.jdbcLink.disconnect();
        logger.info("Verbindung zur Datenbank " + this.jdbcLink.getConnectString() + " getrennt.");
        this.jdbcLink = null;
        this.cache.stat();
    }

    public String queryString(String sql) {
        return this.jdbcLink.queryString(sql);
    }

    public IPersistentObjectCache<String> getCache() {
        return this.cache;
    }

    public PreparedStatement getPreparedStatement(String sql) {
        return this.jdbcLink.getPreparedStatement(sql);
    }

    public void releasePreparedStatement(PreparedStatement statement) {
        this.jdbcLink.releasePreparedStatement(statement);
    }

    public JdbcLink.Stm getStatement() {
        return this.jdbcLink.getStatement();
    }

    public void releaseStatement(JdbcLink.Stm stm) {
        this.jdbcLink.releaseStatement(stm);
    }

    public int exec(String sql) {
        return this.jdbcLink.exec(sql);
    }

    public String wrapFlavored(String wert) {
        return this.jdbcLink.wrapFlavored(wert);
    }

    public boolean isTrace() {
        return this.tracetable != null;
    }

    public int getDefaultLifeTime() {
        return this.default_lifetime;
    }

    public void doTrace(String sql) {
        StringBuffer tracer = new StringBuffer();
        tracer.append("INSERT INTO ").append(this.tracetable);
        tracer.append(" (logtime,Workstation,Username,action) VALUES (");
        tracer.append(System.currentTimeMillis()).append(",");
        tracer.append(this.pcname).append(",");
        tracer.append(this.username).append(",");
        tracer.append(JdbcLink.wrap((String)sql.replace('\'', '/'))).append(")");
        this.exec(tracer.toString());
    }

    public JdbcLink getJdbcLink() {
        return this.jdbcLink;
    }

    public Connection getConnection() {
        return this.jdbcLink.getConnection();
    }

    public void applyMySqlTimeZoneWorkaround() {
        if (this.dbFlavor.equalsIgnoreCase("mysql") && !this.dbConnectString.contains("serverTimezone")) {
            this.dbConnectString = this.dbConnectString.contains("?") ? String.valueOf(this.dbConnectString) + "&serverTimezone=Europe/Zurich" : String.valueOf(this.dbConnectString) + "?serverTimezone=Europe/Zurich";
            logger.info("MySQL dbConnection string correction [{}]", (Object)this.dbConnectString);
        }
    }
}

