/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data.dto;

import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IBillingSystemFactor;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.data.Verrechnet;
import ch.elexis.data.dto.FallDTO;
import ch.elexis.data.dto.KonsultationDTO;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;

public class LeistungDTO {
    private final String id;
    private String code;
    private final String text;
    private int count;
    private IBillable iVerrechenbar;
    private long lastUpdate;
    private IBilled verrechnet;
    private int tp = 0;
    private double tpw = 1.0;
    private double scale1 = 1.0;
    private double scale2 = 1.0;

    public LeistungDTO(Verrechnet verrechnet) throws ElexisException {
        if (!verrechnet.exists()) {
            throw new ElexisException("Verrechnete Leistung wird ignoriert - Keine Leistung vorhanden [ID: " + verrechnet.getId() + "].", (Throwable)new Exception());
        }
        try {
            if (verrechnet.getLastUpdate() < 0L) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new ElexisException("Die verrechnete Leistung wird ignoriert - Datum der letzten Aktualisierung ist fehlerhaft [ID: " + verrechnet.getId() + "].", (Throwable)e);
        }
        this.verrechnet = NoPoUtil.loadAsIdentifiable(verrechnet, IBilled.class).get();
        this.lastUpdate = verrechnet.getLastUpdate();
        this.id = verrechnet.getId();
        this.code = this.verrechnet.getCode();
        this.text = verrechnet.getText();
        this.tp = this.verrechnet.getPoints();
        this.tpw = this.verrechnet.getFactor();
        this.count = verrechnet.getZahl();
        this.iVerrechenbar = this.verrechnet.getBillable();
    }

    public LeistungDTO(IBillable iVerrechenbar, IFall fall) {
        this.lastUpdate = System.currentTimeMillis();
        this.id = iVerrechenbar.getId();
        this.code = iVerrechenbar.getCode();
        this.text = iVerrechenbar.getText();
        this.tp = -1;
        this.tpw = 1.0;
        this.scale1 = 1.0;
        this.scale2 = 1.0;
        this.count = 1;
        this.iVerrechenbar = iVerrechenbar;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean calcPrice(KonsultationDTO konsultationDTO, FallDTO fallDTO, Consumer<Result<IBilled>> showResult) {
        if (this.verrechnet != null) {
            this.tpw = this.getFactor();
            this.scale1 = this.verrechnet.getPrimaryScaleFactor();
            this.scale2 = this.verrechnet.getSecondaryScaleFactor();
            return true;
        }
        Result result = this.iVerrechenbar.getOptifier().add(this.iVerrechenbar, konsultationDTO.getTransientCopyWithoutBillable(this.iVerrechenbar), 1.0, false);
        if (result.isOK()) {
            this.tp = ((IBilled)result.get()).getPoints();
            this.tpw = ((IBilled)result.get()).getFactor();
            this.scale1 = ((IBilled)result.get()).getPrimaryScaleFactor();
            this.scale2 = ((IBilled)result.get()).getSecondaryScaleFactor();
            return true;
        }
        LoggerFactory.getLogger(this.getClass()).warn("Adding billable failed [" + result.getMessages() + "]");
        showResult.accept((Result<IBilled>)result);
        return false;
    }

    private double getFactor() {
        Optional billingFactor;
        if (this.iVerrechenbar != null && (billingFactor = BillingServiceHolder.get().getBillingSystemFactor(this.iVerrechenbar.getCodeSystemName(), this.verrechnet.getEncounter().getDate())).isPresent()) {
            return ((IBillingSystemFactor)billingFactor.get()).getFactor();
        }
        return 1.0;
    }

    public void setTp(int tp) {
        this.tp = tp;
    }

    public void setScale2(double scale2) {
        this.scale2 = scale2;
    }

    public double getScale2() {
        return this.scale2;
    }

    public IBilled getVerrechnet() {
        return this.verrechnet;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public String getText() {
        return this.text;
    }

    public void setVerrechnet(IBilled verrechnet) {
        this.verrechnet = verrechnet;
    }

    public String getId() {
        return this.id;
    }

    public Money getPrice() {
        return new Money((int)((double)Math.round((double)this.tp * this.tpw) * this.scale1 * this.scale2 * (double)this.count));
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public void setiVerrechenbar(IBillable iVerrechenbar) {
        this.iVerrechenbar = iVerrechenbar;
    }

    public IBillable getIVerrechenbar() {
        return this.iVerrechenbar;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public int getTp() {
        return this.tp;
    }

    public double getTpw() {
        return this.tpw;
    }
}

