/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.List;

public class VerrechnetCopy
extends Verrechnet {
    public static final String RECHNUNGID = "RechnungId";
    public static final String BEHANDLUNGID = "BehandlungId";
    private static final String TABLENAME = "VERRECHNETCOPY";

    static {
        VerrechnetCopy.addMapping(TABLENAME, RECHNUNGID, BEHANDLUNGID, "Leistg_txt", "Leistg_code", "Klasse", "Zahl", "EK_Kosten", "VK_TP", "VK_Scale", "VK_Preis", "Scale", "Scale2", "ExtInfo=Detail", "userID");
    }

    public VerrechnetCopy() {
    }

    public VerrechnetCopy(String id) {
        super(id);
    }

    public static VerrechnetCopy load(String id) {
        return new VerrechnetCopy(id);
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    public VerrechnetCopy(Verrechnet verrechnet, Rechnung bill) {
        this.create(null);
        this.set(new String[]{RECHNUNGID, BEHANDLUNGID, "Leistg_txt", "Leistg_code", "Klasse", "Zahl", "EK_Kosten", "VK_TP", "VK_Scale", "VK_Preis", "Scale", "Scale2", "userID"}, bill.getId(), verrechnet.getKons().getId(), verrechnet.get("Leistg_txt"), verrechnet.get("Leistg_code"), verrechnet.get("Klasse"), verrechnet.get("Zahl"), verrechnet.get("EK_Kosten"), verrechnet.get("VK_TP"), verrechnet.get("VK_Scale"), verrechnet.get("VK_Preis"), verrechnet.get("Scale"), verrechnet.get("Scale2"), verrechnet.get("userID"));
        this.setDetail("vat_scale", verrechnet.getDetail("vat_scale"));
    }

    public static List<Verrechnet> getVerrechnetByBill(Rechnung bill) {
        ArrayList<Verrechnet> ret = new ArrayList<Verrechnet>();
        Query vcQuery = new Query(VerrechnetCopy.class);
        vcQuery.add(RECHNUNGID, "=", bill.getId());
        List res = vcQuery.execute();
        ret.addAll(res);
        return ret;
    }

    public static List<VerrechnetCopy> getVerrechnetCopyByConsultation(Konsultation consultation) {
        Query vcQuery = new Query(VerrechnetCopy.class);
        vcQuery.add(BEHANDLUNGID, "=", consultation.getId());
        return vcQuery.execute();
    }

    @Override
    public Money getBruttoPreis() {
        int tp = VerrechnetCopy.checkZero(this.get("VK_TP"));
        TimeTool date = new TimeTool(this.getLastUpdate());
        Konsultation k = Konsultation.load(this.get(BEHANDLUNGID));
        Fall fall = k.getFall();
        IVerrechenbar v = this.getVerrechenbar();
        double tpw = 1.0;
        if (v != null) {
            tpw = v.getFactor(date, fall);
        }
        return new Money((int)Math.round(tpw * (double)tp));
    }

    @Override
    public Konsultation getKons() {
        return Konsultation.load(this.get(BEHANDLUNGID));
    }
}

