/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.extension.CoreOperationAdvisorHolder;
import ch.elexis.core.data.interfaces.IDiagnose;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.events.MessageEvent;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.data.AccountTransaction;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Messages;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Verrechnet;
import ch.elexis.data.VerrechnetCopy;
import ch.elexis.data.Zahlung;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Rechnung
extends PersistentObject {
    public static final String FLD_EXT_REMARK = "Bemerkung";
    public static final String FLD_EXT_ATTACHMENTS = "Attachments";
    public static final String FLD_EXT_INTERNAL_REMARKS = "InternalRemarks";
    public static final String BILL_STATE_DATE = "StatusDatum";
    public static final String BILL_DATE = "RnDatum";
    public static final String BILL_AMOUNT_CENTS = "Betragx100";
    public static final String BILL_DATE_UNTIL = "RnDatumBis";
    public static final String BILL_DATE_FROM = "RnDatumVon";
    public static final String BILL_STATE = "RnStatus";
    public static final String MANDATOR_ID = "MandantID";
    public static final String CASE_ID = "FallID";
    public static final String BILL_NUMBER = "RnNummer";
    static final String TABLENAME = "RECHNUNGEN";
    public static final String STATUS_CHANGED = "Status\u00e4nderung";
    public static final String PAYMENT = "Zahlung";
    public static final String CORRECTION = "Korrektur";
    public static final String REJECTED = "Zur\u00fcckgewiesen";
    public static final String OUTPUT = "Ausgegeben";
    public static final String REMARKS = "Bemerkungen";
    public static final String INVOICE_CORRECTION = "Rechnungskorrektur";

    static {
        Rechnung.addMapping(TABLENAME, BILL_NUMBER, CASE_ID, MANDATOR_ID, "RnDatum=S:D:RnDatum", BILL_STATE, "StatusDatum=S:D:StatusDatum", "RnDatumVon=S:D:RnDatumVon", "RnDatumBis=S:D:RnDatumBis", "Betragx100=Betrag", "ExtInfo", "Zahlungen=LIST:RechnungsID:ZAHLUNGEN:Datum");
    }

    public Rechnung(String nr, Mandant m, Fall f, String von, String bis, Money Betrag, int status) {
        this.create(null);
        String Datum = new TimeTool().toString(4);
        this.set(new String[]{BILL_NUMBER, MANDATOR_ID, CASE_ID, BILL_DATE_FROM, BILL_DATE_UNTIL, BILL_AMOUNT_CENTS, BILL_STATE, BILL_DATE}, nr, m.getId(), f.getId(), von, bis, Betrag.getCentsAsString(), Integer.toString(status), Datum);
        new AccountTransaction(f.getPatient(), this, Betrag.multiply(-1.0), Datum, "Rechnung erstellt");
    }

    @Deprecated
    public static Result<Rechnung> build(List<Konsultation> behandlungen) {
        System.out.println("js Rechnung: build() begin");
        System.out.println("js Rechnung: build(): TO DO: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        System.out.println("js Rechnung: build(): TO DO: Apparently, Rechnung.build() uses local checking algorithms,");
        System.out.println("js Rechnung: build(): TO DO: Event though Validator.checkBill() offers more structured ones.");
        System.out.println("js Rechnung: build(): TO DO: Why are both of them in the code?");
        System.out.println("js Rechnung: build(): TO DO: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        Result result = new Result();
        if (behandlungen == null || behandlungen.isEmpty()) {
            return result.add(Result.SEVERITY.WARNING, 1, "Die Rechnung enth\u00e4lt keine Behandlungen (Konsultationen)", null, true);
        }
        for (Konsultation b : behandlungen) {
            Patient pat = b.getFall().getPatient();
            if (pat.istPerson()) continue;
            MessageEvent.fireInformation((String)"Hinweis", (String)("Bei Patient Nr. " + pat.getPatCode() + ", " + pat.getName() + ", " + pat.getVorname() + ", " + pat.getGeburtsdatum() + "\n" + "fehlte das H\u00e4kchen f\u00fcr 'Person' in der Kontaktdatenbank.\n\nIch korrigiere das selbst."));
            pat.set("istPerson", "1");
        }
        System.out.println("js Rechnung: build(): number of consultations: " + behandlungen.size());
        for (Konsultation b : behandlungen) {
            if (b.getLeistungen().isEmpty() || b.getUmsatz() == 0.0) {
                System.out.println("Ignoriere Behandlung mit Umsatz 0");
                continue;
            }
            List<Verrechnet> lstg = b.getLeistungen();
            for (Verrechnet l : lstg) {
                if (!l.getNettoPreis().isZero() || !ConfigServiceHolder.getUser((String)"billing/zero_check", (boolean)false)) continue;
                Patient pat = b.getFall().getPatient();
                String msg2 = "Eine Konsultation vom " + b.getDatum().toString() + " f\u00fcr\nPatient Nr. " + pat.getPatCode() + ", " + pat.getName() + ", " + pat.getVorname() + ", " + pat.getGeburtsdatum() + "\n" + "enth\u00e4lt mindestens eine Leistung zum Preis 0.00.\n" + "\nDie \u00c4rztekasse w\u00fcrde so eine Rechnung zur\u00fcckgeben.\n\n";
                if (CoreOperationAdvisorHolder.get().openQuestion("WARNUNG: Leistung zu Fr. 0.00 !", String.valueOf(msg2) + "Soll die Rechnung trotzdem erstellt werden?")) continue;
                return result.add(Result.SEVERITY.WARNING, 1, String.valueOf(msg2) + "Diese Rechnung wird jetzt nicht erstellt." + "\n\nBitte pr\u00fcfen Sie die verrechneten Leistungen," + "oder verschieben Sie die Konsultation zu einem sp\u00e4ter zu verrechnenden Fall!", null, true);
            }
        }
        Rechnung ret = new Rechnung();
        ret.create(null);
        LocalLockServiceHolder.get().acquireLock((Object)ret);
        TimeTool startDate = new TimeTool("31.12.2999");
        TimeTool endDate = new TimeTool("01.01.2000");
        TimeTool actDate = new TimeTool();
        Mandant m = null;
        ArrayList<IDiagnose> diagnosen = null;
        Fall f = null;
        Money summe = new Money();
        for (Konsultation b : behandlungen) {
            Rechnung shouldntExist = b.getRechnung();
            if (shouldntExist != null && shouldntExist.getStatus() != 18) {
                log.warn("Tried to create bill for already billed kons " + b.getLabel());
                continue;
            }
            Mandant bm = b.getMandant();
            if (bm == null || !bm.isValid()) {
                result = result.add(Result.SEVERITY.ERROR, 1, "Ung\u00fcltiger Mandant bei Konsultation " + b.getLabel(), (Object)ret, true);
                continue;
            }
            if (m == null) {
                m = bm;
                ret.set(MANDATOR_ID, m.getId());
            } else if (!bm.getRechnungssteller().getId().equals(m.getRechnungssteller().getId())) {
                result = result.add(Result.SEVERITY.ERROR, 2, "Die Liste enth\u00e4lt unterschiedliche Rechnungssteller " + b.getLabel(), (Object)ret, true);
                continue;
            }
            Fall bf = b.getFall();
            if (bf == null) {
                result = result.add(Result.SEVERITY.ERROR, 3, "Fehlender Fall bei Konsultation " + b.getLabel(), (Object)ret, true);
                continue;
            }
            if (f == null) {
                f = bf;
                ret.set(CASE_ID, f.getId());
                f.setBillingDate(null);
            } else if (!f.getId().equals(bf.getId())) {
                result = result.add(Result.SEVERITY.ERROR, 4, "Die Liste enth\u00e4lt unterschiedliche Faelle " + b.getLabel(), (Object)ret, true);
                continue;
            }
            if (diagnosen == null || diagnosen.isEmpty()) {
                diagnosen = b.getDiagnosen();
            }
            if (!actDate.set(b.getDatum())) {
                result = result.add(Result.SEVERITY.ERROR, 5, "Ung\u00fcltiges Datum bei Konsultation " + b.getLabel(), (Object)ret, true);
                continue;
            }
            if (actDate.isBefore(startDate)) {
                startDate.set(actDate);
            }
            if (actDate.isAfter(endDate)) {
                endDate.set(actDate);
            }
            List<Verrechnet> lstg = b.getLeistungen();
            for (Verrechnet l : lstg) {
                Money sz = l.getNettoPreis().multiply((double)l.getZahl());
                summe.addMoney(sz);
            }
        }
        if (f == null) {
            result = result.add(Result.SEVERITY.ERROR, 8, "Die Rechnung hat keinen zugeh\u00f6rigen Fall (" + Rechnung.getRnDesc(ret) + ")", (Object)ret, true);
        } else if (ConfigServiceHolder.getUser((String)"billing/strict", (boolean)true) && !f.isValid()) {
            result = result.add(Result.SEVERITY.ERROR, 8, "Die Rechnung hat keinen g\u00fcltigen Fall (" + Rechnung.getRnDesc(ret) + ")", (Object)ret, true);
        }
        if (ConfigServiceHolder.getUser((String)"billing/strict", (boolean)true) && (diagnosen == null || diagnosen.isEmpty())) {
            result = result.add(Result.SEVERITY.ERROR, 6, "Die Rechnung enth\u00e4lt keine Diagnose (" + Rechnung.getRnDesc(ret) + ")", (Object)ret, true);
        }
        String Datum = new TimeTool().toString(4);
        ret.set(BILL_DATE_FROM, startDate.toString(4));
        ret.set(BILL_DATE_UNTIL, endDate.toString(4));
        ret.set(BILL_DATE, Datum);
        ret.setStatus(InvoiceState.OPEN);
        ret.set(BILL_AMOUNT_CENTS, summe.getCentsAsString());
        String nr = Rechnung.getNextRnNummer();
        ret.set(BILL_NUMBER, nr);
        if (!result.isOK()) {
            ret.delete();
            LocalLockServiceHolder.get().releaseLock((Object)ret);
            return result;
        }
        for (Konsultation b : behandlungen) {
            b.setRechnung(ret);
            List<Verrechnet> lstg = b.getLeistungen();
            for (Verrechnet l : lstg) {
                l.createCopy(ret);
            }
        }
        if (ret.getOffenerBetrag().isZero()) {
            ret.setStatus(InvoiceState.PAID);
        } else if (f != null) {
            new AccountTransaction(f.getPatient(), ret, summe.negate(), Datum, "Rn " + nr + " erstellt.");
        }
        LocalLockServiceHolder.get().releaseLock((Object)ret);
        return result.add(Result.SEVERITY.OK, 0, "OK", (Object)ret, false);
    }

    private static String getRnDesc(Rechnung rn) {
        StringBuilder sb = new StringBuilder();
        if (rn == null) {
            sb.append("Keine Rechnungsnummer");
        } else {
            Fall fall = rn.getFall();
            sb.append("Rechnung: " + rn.getNr()).append(" / ");
            if (fall == null) {
                sb.append("Kein Fall");
            } else {
                sb.append("Fall: " + fall.getLabel()).append(" / ");
                Patient pat = fall.getPatient();
                if (pat == null) {
                    sb.append("Kein Patient");
                } else {
                    sb.append(pat.getLabel());
                }
            }
        }
        return sb.toString();
    }

    public List<Verrechnet> getLeistungen() {
        return VerrechnetCopy.getVerrechnetByBill(this);
    }

    public String getNr() {
        return this.get(BILL_NUMBER);
    }

    public Fall getFall() {
        return Fall.load(this.get(CASE_ID));
    }

    public Mandant getMandant() {
        return Mandant.load(this.get(MANDATOR_ID));
    }

    public List<Konsultation> getKonsultationen() {
        Query qbe = new Query(Konsultation.class);
        qbe.add("RechnungsID", "=", this.getId());
        qbe.orderBy(false, "Datum");
        return qbe.execute();
    }

    @Deprecated
    public void storno(boolean reopen) {
        this.stornoBill(reopen);
    }

    @Deprecated
    public List<Konsultation> stornoBill(boolean reopen) {
        InvoiceState invoiceState = InvoiceState.fromState((int)this.getStatus());
        List<Konsultation> kons = null;
        if (!InvoiceState.CANCELLED.equals((Object)invoiceState) && !InvoiceState.DEPRECIATED.equals((Object)invoiceState)) {
            Money betrag = this.getBetrag();
            Money remindersBetrag = this.getRemindersBetrag();
            if (!remindersBetrag.isZero()) {
                betrag.addMoney(remindersBetrag);
            }
            new Zahlung(this, betrag, "Storno", null);
            if (reopen) {
                kons = this.removeBillFromKons();
                this.setStatus(InvoiceState.CANCELLED);
            } else {
                this.setStatus(InvoiceState.DEPRECIATED);
            }
        } else if (reopen && InvoiceState.CANCELLED.equals((Object)invoiceState)) {
            kons = this.removeBillFromKons();
        }
        return kons;
    }

    private List<Konsultation> removeBillFromKons() {
        ArrayList<Konsultation> kons = new ArrayList<Konsultation>();
        Query qbe = new Query(Konsultation.class);
        qbe.add("RechnungsID", "=", this.getId());
        for (Konsultation k : qbe.execute()) {
            k.set("RechnungsID", null);
            kons.add(k);
        }
        return kons;
    }

    public String getDatumRn() {
        return this.get(BILL_DATE);
    }

    public String getDatumVon() {
        return this.get(BILL_DATE_FROM);
    }

    public String getDatumBis() {
        String raw = this.get(BILL_DATE_UNTIL);
        return raw == null ? "" : raw.trim();
    }

    public Money getBetrag() {
        int raw = Rechnung.checkZero(this.get(BILL_AMOUNT_CENTS));
        return new Money(raw);
    }

    public boolean setBetrag(Money betrag) {
        int oldVal = Math.abs(Rechnung.checkZero(this.get(BILL_AMOUNT_CENTS)));
        if (oldVal != 0) {
            AccountTransaction at;
            int newVal = betrag.getCents();
            int diff = Math.abs(oldVal - newVal);
            if (diff > 500 || diff * 50 > oldVal) {
                Money old = new Money(oldVal);
                String nr = Rechnung.checkNull(this.get(BILL_NUMBER));
                String message = "Der errechnete Rechnungsbetrag (" + betrag.getAmountAsString() + ") weicht vom Rechnungsbetrag (" + old.getAmountAsString() + ") ab. Trotzdem weiterfahren?";
                if (!CoreOperationAdvisorHolder.get().openQuestion("Differenz bei der Rechnung " + nr, message)) {
                    return false;
                }
            }
            Query qa = new Query(AccountTransaction.class);
            qa.add("RechnungsID", "=", this.getId());
            qa.add("ZahlungsID", "", null);
            List as = qa.execute();
            if (as != null && as.size() == 1 && (at = (AccountTransaction)as.get(0)).exists()) {
                Money negBetrag = new Money(betrag);
                negBetrag.negate();
                at.set("Betrag", negBetrag.getCentsAsString());
            }
        }
        this.set(BILL_AMOUNT_CENTS, betrag.getCentsAsString());
        return true;
    }

    public Money getOffenerBetrag() {
        List<Zahlung> lz = this.getZahlungen();
        Money total = this.getBetrag();
        for (Zahlung z : lz) {
            Money abzahlung = z.getBetrag();
            total.subtractMoney(abzahlung);
        }
        return new Money(total);
    }

    public Money getAnzahlung() {
        List<Zahlung> lz = this.getZahlungen();
        Money total = new Money();
        for (Zahlung z : lz) {
            Money abzahlung = z.getBetrag();
            if (abzahlung.isNegative()) continue;
            total.addMoney(abzahlung);
        }
        return total;
    }

    @Deprecated(forRemoval=true)
    public int getStatus() {
        return this.getInvoiceState().numericValue();
    }

    public InvoiceState getInvoiceState() {
        String[] values = new String[2];
        this.get(new String[]{BILL_STATE, BILL_STATE_DATE}, values);
        int stateNumeric = 0;
        TimeTool stateDate = new TimeTool(values[1]);
        if (stateDate.isAfterOrEqual(new TimeTool())) {
            List stateChanges = (List)this.getExtInfoStoredObjectByKey(STATUS_CHANGED);
            String lastElement = (String)stateChanges.get(stateChanges.size() - 1);
            String[] split = lastElement.split(": ");
            try {
                stateNumeric = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException nfe) {
                log.error("Error resolving invoice state [{}] in element [{}], returning UNKNOWN.", (Object)split[1], (Object)lastElement);
            }
        } else {
            try {
                stateNumeric = Integer.parseInt(Rechnung.checkNull(this.get(BILL_STATE)));
            }
            catch (NumberFormatException nfe) {
                log.error("Error resolving invoice state [{}], returning UNKNOWN.", (Object)stateNumeric);
            }
        }
        return InvoiceState.fromState((int)stateNumeric);
    }

    public void setTemporaryState(int temporaryState, TimeTool expiryDate) {
        this.addTrace(STATUS_CHANGED, Integer.toString(temporaryState));
        this.setExtInfoStoredObjectByKey("TEMPORARY_STATE", Integer.toString(temporaryState));
        this.set(BILL_STATE_DATE, expiryDate.toString(4));
    }

    public void setStatus(InvoiceState state) {
        this.set(BILL_STATE, Integer.toString(state.getState()));
        this.set(BILL_STATE_DATE, new TimeTool().toString(4));
        this.addTrace(STATUS_CHANGED, Integer.toString(state.getState()));
    }

    public Zahlung addZahlung(Money betrag, String text, TimeTool date) {
        if (betrag.isZero()) {
            return null;
        }
        if (ConfigServiceHolder.getGlobal((String)"rechnung/reminder/removeopen", (boolean)false) && this.shouldRemoveOpenReminders(betrag)) {
            this.removeOpenReminders();
        }
        Money oldOffen = this.getOffenerBetrag();
        int oldOffenCents = oldOffen.getCents();
        Money newOffen = new Money(oldOffen);
        newOffen.subtractMoney(betrag);
        if (newOffen.isNeglectable()) {
            this.setStatus(InvoiceState.PAID);
        } else if (newOffen.isNegative()) {
            this.setStatus(InvoiceState.EXCESSIVE_PAYMENT);
        } else if (newOffen.equals((Object)this.getBetrag())) {
            List<String> zahlungen = this.getTrace(STATUS_CHANGED);
            if (zahlungen.size() < 2) {
                this.setStatus(InvoiceState.OPEN_AND_PRINTED);
            } else {
                String statusDescription = zahlungen.get(zahlungen.size() - 2);
                Matcher matcher = Pattern.compile(".*:\\s*(\\d+)").matcher(statusDescription);
                if (matcher.matches()) {
                    String prevStatus = matcher.group(1);
                    int newStatus = Integer.parseInt(prevStatus);
                    this.setStatus(InvoiceState.fromState((int)newStatus));
                }
            }
        } else if (newOffen.getCents() < oldOffenCents) {
            this.setStatus(InvoiceState.PARTIAL_PAYMENT);
        }
        return new Zahlung(this, betrag, text, date);
    }

    private boolean shouldRemoveOpenReminders(Money betrag) {
        if (this.hasReminders()) {
            Money open = this.getOffenerBetrag();
            return open.subtractMoney(betrag).equals((Object)this.getRemindersBetrag());
        }
        return false;
    }

    public Money getRemindersBetrag() {
        Money ret = new Money(0);
        for (Zahlung zahlung : this.getZahlungen()) {
            String comment = zahlung.getBemerkung();
            if (!comment.equals(Messages.Rechnung_Mahngebuehr1) && !comment.equals(Messages.Rechnung_Mahngebuehr2) && !comment.equals(Messages.Rechnung_Mahngebuehr3)) continue;
            ret.addMoney(zahlung.getBetrag());
        }
        return ret.isNegative() ? ret.multiply(-1.0) : ret;
    }

    public boolean hasReminders() {
        for (Zahlung zahlung : this.getZahlungen()) {
            String comment = zahlung.getBemerkung();
            if (!comment.equals(Messages.Rechnung_Mahngebuehr1) && !comment.equals(Messages.Rechnung_Mahngebuehr2) && !comment.equals(Messages.Rechnung_Mahngebuehr3)) continue;
            return true;
        }
        return false;
    }

    private void removeOpenReminders() {
        for (Zahlung zahlung : this.getZahlungen()) {
            String comment = zahlung.getBemerkung();
            if (!comment.equals(Messages.Rechnung_Mahngebuehr1) && !comment.equals(Messages.Rechnung_Mahngebuehr2) && !comment.equals(Messages.Rechnung_Mahngebuehr3)) continue;
            zahlung.delete();
        }
    }

    public List<Zahlung> getZahlungen() {
        List<String> ids = this.getList("Zahlungen", false);
        ArrayList<Zahlung> ret = new ArrayList<Zahlung>();
        for (String id : ids) {
            Zahlung z = Zahlung.load(id);
            ret.add(z);
        }
        return ret;
    }

    public String getBemerkung() {
        return Rechnung.checkNull(this.getExtInfoStoredObjectByKey(FLD_EXT_REMARK));
    }

    public void setBemerkung(String bem) {
        this.setExtInfoStoredObjectByKey(FLD_EXT_REMARK, bem);
    }

    public String getInternalRemarks() {
        return Rechnung.checkNull(this.getExtInfoStoredObjectByKey(FLD_EXT_INTERNAL_REMARKS));
    }

    public void setInternalRemarks(String internalRemarks) {
        this.setExtInfoStoredObjectByKey(FLD_EXT_INTERNAL_REMARKS, internalRemarks);
    }

    public void addTrace(String name, String text) {
        Hashtable<String, String> hash = this.loadExtension();
        byte[] raw = (byte[])hash.get(name);
        ArrayList<String> trace = null;
        if (raw != null) {
            trace = StringTool.unpack((byte[])raw);
        }
        if (trace == null) {
            trace = new ArrayList<String>();
        }
        trace.add(String.valueOf(new TimeTool().toString(0)) + ": " + text);
        hash.put(name, (String)StringTool.pack(trace));
        this.flushExtension(hash);
    }

    public List<String> getTrace(String name) {
        Hashtable<String, String> hash = this.loadExtension();
        byte[] raw = (byte[])hash.get(name);
        ArrayList trace = null;
        if (raw != null) {
            trace = StringTool.unpack((byte[])raw);
        }
        if (trace == null) {
            trace = new ArrayList();
        }
        return trace;
    }

    public String getRnDatumFrist() {
        String stat = this.get(BILL_STATE_DATE);
        int frist = 0;
        int status = this.getStatus();
        if (status == InvoiceState.OPEN_AND_PRINTED.getState()) {
            frist = ConfigServiceHolder.get().getActiveMandator("rechnung/days_until_1st", 30);
        } else if (status == InvoiceState.DEMAND_NOTE_1_PRINTED.getState()) {
            frist = ConfigServiceHolder.get().getActiveMandator("rechnung/days_until_2nd", 10);
        } else if (status == InvoiceState.DEMAND_NOTE_2_PRINTED.getState()) {
            frist = ConfigServiceHolder.get().getActiveMandator("rechnung/days_until_3rd", 10);
        }
        TimeTool tm = new TimeTool(stat);
        tm.add(5, frist);
        return tm.toString(4);
    }

    public void reject(InvoiceState.REJECTCODE reason, String text) {
        this.setStatus(InvoiceState.DEFECTIVE);
        this.addTrace(REJECTED, String.valueOf(reason.toString()) + ", " + text);
    }

    public Hashtable<String, String> loadExtension() {
        return (Hashtable)this.getMap("ExtInfo");
    }

    public void flushExtension(Hashtable ext) {
        this.setMap("ExtInfo", ext);
    }

    public static Rechnung load(String id) {
        Rechnung ret = new Rechnung(id);
        if (ret.exists()) {
            return ret;
        }
        return null;
    }

    public static Rechnung getFromNr(String Rnnr) {
        Rechnung ret;
        String id = new Query(Rechnung.class).findSingle(BILL_NUMBER, "=", Rnnr);
        if (id != null && (ret = Rechnung.load(id)).isValid()) {
            return ret;
        }
        return null;
    }

    @Deprecated
    public static String getNextRnNummer() {
        String exists;
        JdbcLink j = Rechnung.getConnection();
        JdbcLink.Stm stm = j.getStatement();
        String nr = null;
        do {
            String lockid = PersistentObject.lock("RechnungsNummer", true);
            String pid = j.queryString("SELECT WERT FROM CONFIG WHERE PARAM='RechnungsNr'");
            if (StringTool.isNothing((Object)pid)) {
                pid = "0";
                j.exec("INSERT INTO CONFIG (PARAM,WERT) VALUES ('RechnungsNr','0')");
            }
            int lastNum = Integer.parseInt(pid) + 1;
            nr = Integer.toString(lastNum);
            j.exec("UPDATE CONFIG SET WERT='" + nr + "' WHERE PARAM='RechnungsNr'");
            PersistentObject.unlock("RechnungsNummer", lockid);
        } while ((exists = j.queryString("SELECT ID FROM RECHNUNGEN WHERE RnNummer=" + JdbcLink.wrap((String)nr))) != null);
        j.releaseStatement(stm);
        return nr;
    }

    protected Rechnung() {
    }

    protected Rechnung(String id) {
        super(id);
    }

    @Override
    public boolean delete() {
        for (Zahlung z : this.getZahlungen()) {
            z.set("RechnungsID", "");
            z.delete();
            z.set("RechnungsID", this.getId());
        }
        return super.delete();
    }

    @Override
    public String getLabel() {
        String[] vals = this.get(true, CASE_ID, BILL_NUMBER, BILL_DATE, BILL_AMOUNT_CENTS);
        StringBuilder sb = new StringBuilder();
        sb.append(vals[1]).append(" ").append(vals[2]);
        Fall fall = Fall.load(vals[0]);
        if (fall != null && fall.exists()) {
            sb.append(": ").append(fall.getPatient().getLabel()).append(" ");
        }
        int value = Rechnung.checkZero(vals[3]);
        sb.append(new Money(value));
        return sb.toString();
    }

    public String getRnId() {
        Patient p = this.getFall().getPatient();
        String pid = ConfigServiceHolder.getGlobal((String)"PatIDMode", (String)"number").equals("number") ? StringTool.pad((int)1, (char)'0', (String)p.getPatCode(), (int)6) : new TimeTool(p.getGeburtsdatum()).toString(9);
        String nr = StringTool.pad((int)1, (char)'0', (String)this.getNr(), (int)6);
        return String.valueOf(pid) + nr;
    }

    public int getStatusAtDate(TimeTool date) {
        List<String> trace = this.getTrace(STATUS_CHANGED);
        int ret = this.getStatus();
        TimeTool tt = new TimeTool();
        for (String s : trace) {
            String[] stm = s.split("\\s*:\\s");
            if (!tt.set(stm[0]) || !tt.isBefore(date)) continue;
            ret = Integer.parseInt(stm[1]);
        }
        return ret;
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    public boolean isCorrectable() {
        String rechnungsNr = this.getNr();
        if (rechnungsNr != null && rechnungsNr.isEmpty()) {
            return false;
        }
        InvoiceState invoiceState = this.getInvoiceState();
        if (invoiceState != null) {
            switch (invoiceState) {
                case PARTIAL_LOSS: 
                case TOTAL_LOSS: 
                case CANCELLED: 
                case TO_PRINT: 
                case OWING: 
                case DEPRECIATED: {
                    return false;
                }
                case UNKNOWN: 
                case BILLED: 
                case NOT_BILLED: 
                case ONGOING: 
                case OPEN: 
                case OPEN_AND_PRINTED: 
                case DEMAND_NOTE_1: 
                case DEMAND_NOTE_1_PRINTED: 
                case DEMAND_NOTE_2: 
                case DEMAND_NOTE_2_PRINTED: 
                case DEMAND_NOTE_3: 
                case DEMAND_NOTE_3_PRINTED: 
                case IN_EXECUTION: 
                case PARTIAL_PAYMENT: 
                case PAID: 
                case EXCESSIVE_PAYMENT: 
                case FROM_TODAY: 
                case NOT_FROM_TODAY: 
                case NOT_FROM_YOU: 
                case DEFECTIVE: 
                case STOP_LEGAL_PROCEEDING: 
                case REJECTED: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isStorno(Rechnung rechnung) {
        InvoiceState invoiceState = rechnung.getInvoiceState();
        return InvoiceState.CANCELLED.equals((Object)invoiceState) || InvoiceState.DEPRECIATED.equals((Object)invoiceState);
    }

    public static boolean hasStornoBeforeDate(Rechnung rechnung, TimeTool date) {
        boolean stornoSet = false;
        TimeTool stornoDate = new TimeTool();
        List<Zahlung> zahlungen = rechnung.getZahlungen();
        for (Zahlung zahlung : zahlungen) {
            if (!zahlung.getBemerkung().equals("Storno")) continue;
            stornoSet = true;
            stornoDate.set(zahlung.getDatum());
            break;
        }
        return stornoSet && stornoDate.isBeforeOrEqual(date);
    }

    public IInvoice toIInvoice() {
        return (IInvoice)CoreModelServiceHolder.get().load(this.getId(), IInvoice.class).orElseThrow(() -> new IllegalStateException("Could not convert invoice [" + this.getId() + "]"));
    }
}

