/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.ObjectEvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.extension.CoreOperationAdvisorHolder;
import ch.elexis.core.data.interfaces.IArticle;
import ch.elexis.core.data.interfaces.ICodeElement;
import ch.elexis.core.data.interfaces.IDiagnose;
import ch.elexis.core.data.interfaces.IOptifier;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.data.interfaces.IVerrechenbarAdjuster;
import ch.elexis.core.data.nopo.adapter.DiagnoseAdapter;
import ch.elexis.core.data.service.PoCodeElementServiceHolder;
import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.data.services.ICodeElementService;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.events.MessageEvent;
import ch.elexis.core.exceptions.PersistenceException;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.model.util.ElexisIdGenerator;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.StockServiceHolder;
import ch.elexis.core.status.ElexisStatus;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.data.Artikel;
import ch.elexis.data.Fall;
import ch.elexis.data.Mandant;
import ch.elexis.data.Messages;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Verrechnet;
import ch.elexis.data.VerrechnetCopy;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionedResource;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;

public class Konsultation
extends PersistentObject
implements Comparable<Konsultation> {
    private DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HHmmss");
    public static final String FLD_ENTRY = "Eintrag";
    public static final String DATE = "Datum";
    public static final String FLD_TIME = "Zeit";
    public static final String FLD_BILL_ID = "RechnungsID";
    public static final String FLD_CASE_ID = "FallID";
    public static final String FLD_MANDATOR_ID = "MandantID";
    public static final String FLD_JOINT_DIAGNOSEN = "Diagnosen";
    public static final String FLD_BILLABLE = "billable";
    private static final String TABLENAME = "BEHANDLUNGEN";
    volatile int actEntry;
    private static ArrayList<IVerrechenbarAdjuster> adjusters = new ArrayList();
    private final String STM_S_BDJ = "SELECT BDJ.DiagnoseId FROM BEHDL_DG_JOINT BDJ, DIAGNOSEN D WHERE BDJ.BehandlungsID=? AND D.ID = BDJ.DiagnoseID AND D.DG_CODE=? AND D.KLASSE=?;";

    static {
        Konsultation.addMapping(TABLENAME, FLD_MANDATOR_ID, "Datum=S:D:Datum", FLD_CASE_ID, FLD_BILL_ID, "Eintrag=S:V:Eintrag", FLD_TIME, "Diagnosen=JOINT:BehandlungsID:DiagnoseID:BEHDL_DG_JOINT", FLD_BILLABLE);
        List<IConfigurationElement> adjustersConfigurations = Extensions.getExtensions("ch.elexis.core.data.VerrechnungscodeAdjuster");
        for (IConfigurationElement elem : adjustersConfigurations) {
            try {
                Object o = elem.createExecutableExtension("class_pre");
                if (!(o instanceof IVerrechenbarAdjuster)) continue;
                adjusters.add((IVerrechenbarAdjuster)o);
            }
            catch (CoreException e) {
                log.warn("{} [{}]", (Object)e.getMessage(), (Object)elem.toString());
            }
        }
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    protected Konsultation(String id) {
        super(id);
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        Mandant m = this.getMandant();
        if (m == null || !m.isValid()) {
            return false;
        }
        Fall fall = this.getFall();
        return fall != null && fall.isValid();
    }

    public Fall getFall() {
        return Fall.load(this.get(FLD_CASE_ID));
    }

    @Deprecated
    public void setFall(Fall f) {
        this.transferToFall(f, false, true);
    }

    public void transferToFall(Fall f, boolean ignoreEditable, boolean setToStandartPreis) {
        if (ignoreEditable || this.isEditable(true)) {
            Fall alt = this.getFall();
            this.set(FLD_CASE_ID, f.getId());
            if (alt != null) {
                ICodeElementService codeElementService = PoCodeElementServiceHolder.get();
                HashMap<Object, Object> context = this.getCodeElementServiceContext();
                List<Verrechnet> vv = this.getLeistungen();
                for (Verrechnet verrechnet : vv) {
                    if (setToStandartPreis) {
                        verrechnet.setStandardPreis();
                        continue;
                    }
                    IVerrechenbar v = verrechnet.getVerrechenbar();
                    if (this.isTarmed(verrechnet)) {
                        Optional<ICodeElement> matchingVerrechenbar = codeElementService.createFromString(v.getCodeSystemName(), v.getCode(), context);
                        if (matchingVerrechenbar.isPresent()) {
                            int amount = verrechnet.getZahl();
                            this.removeLeistung(verrechnet);
                            int i = 0;
                            while (i < amount) {
                                this.addLeistung((IVerrechenbar)matchingVerrechenbar.get());
                                ++i;
                            }
                            continue;
                        }
                        MessageEvent.fireInformation((String)"Info", (String)("Achtung: durch den Fall wechsel wurde die Position " + v.getCode() + " automatisch entfernt, da diese im neuen Fall nicht vorhanden ist."));
                        this.removeLeistung(verrechnet);
                        continue;
                    }
                    TimeTool date = new TimeTool(verrechnet.getKons().getDatum());
                    double factor = v.getFactor(date, f);
                    verrechnet.set("VK_Scale", Double.toString(factor));
                }
            }
            this.refreshLastUpdateAndSendUpdateEvent(FLD_CASE_ID);
        }
    }

    private HashMap<Object, Object> getCodeElementServiceContext() {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        ret.put((Object)ICodeElementService.ContextKeys.CONSULTATION, this);
        Fall coverage = this.getFall();
        if (coverage != null) {
            ret.put((Object)ICodeElementService.ContextKeys.COVERAGE, coverage);
        }
        return ret;
    }

    private boolean isTarmed(Verrechnet verrechnet) {
        String fullname = verrechnet.get("Klasse");
        return fullname.contains("TarmedLeistung");
    }

    public Konsultation(Fall fall) {
        if (fall == null) {
            fall = (Fall)ElexisEventDispatcher.getSelected(Fall.class);
        }
        if (fall == null) {
            MessageEvent.fireError((String)"Kein Fall ausgew\u00e4hlt", (String)"Bitte zun\u00e4chst einen Fall ausw\u00e4hlen, dem die neue Konsultation zugeordnet werden soll");
        } else if (!fall.isOpen()) {
            MessageEvent.fireError((String)"Fall geschlossen", (String)"Zu einem abgeschlossenen Fall kann keine neue Konsultation erstellt werden");
        } else {
            this.create(null);
            TimeTool now = new TimeTool();
            this.set(new String[]{DATE, FLD_TIME, FLD_CASE_ID, FLD_MANDATOR_ID}, now.toString(4), now.toString(16), fall.getId(), ((IMandator)ContextServiceHolder.get().getActiveMandator().get()).getId());
            fall.getPatient().setInfoElement("LetzteBehandlung", this.getId());
        }
        if (Konsultation.getDefaultDiagnose() != null) {
            this.addDiagnose(Konsultation.getDefaultDiagnose());
        }
    }

    public static Konsultation load(String id) {
        Konsultation ret = new Konsultation(id);
        return ret;
    }

    public int getHeadVersion() {
        VersionedResource vr = this.getVersionedResource(FLD_ENTRY, false);
        return vr.getHeadVersion();
    }

    public VersionedResource getEintrag() {
        VersionedResource vr = this.getVersionedResource(FLD_ENTRY, true);
        return vr;
    }

    public void addXRef(String provider, String id, int pos, String text) {
        ElexisEventDispatcher.getInstance().fire(new ElexisEvent((Object)this, Konsultation.class, 8192, 1));
        VersionedResource vr = this.getEintrag();
        String ntext = vr.getHead();
        Samdas samdas = new Samdas(ntext);
        Samdas.Record record = samdas.getRecord();
        String recText = record.getText();
        if (pos == -1 || pos > recText.length()) {
            pos = recText.length();
            recText = String.valueOf(recText) + "\n" + text;
        } else {
            recText = String.valueOf(recText.substring(0, pos)) + "\n" + text + recText.substring(pos);
        }
        record.setText(recText);
        Samdas.XRef xref = new Samdas.XRef(provider, id, ++pos, text.length());
        record.add((Samdas.Range)xref);
        this.updateEintrag(samdas.toString(), true);
        ElexisEventDispatcher.getInstance().fire(new ElexisEvent((Object)this, Konsultation.class, 4, 10000));
    }

    private Samdas getEntryRaw() {
        VersionedResource vr = this.getEintrag();
        String ntext = vr.getHead();
        Samdas samdas = new Samdas(ntext);
        return samdas;
    }

    private void updateEntryRaw(Samdas samdas) {
        this.updateEintrag(samdas.toString(), false);
    }

    public void removeXRef(String provider, String id) {
        VersionedResource vr = this.getEintrag();
        String ntext = vr.getHead();
        Samdas samdas = new Samdas(ntext);
        Samdas.Record record = samdas.getRecord();
        String recText = record.getText();
        List xrefs = record.getXrefs();
        boolean changed = false;
        for (Samdas.XRef xref : xrefs) {
            if (!xref.getProvider().equals(provider) || !xref.getID().equals(id)) continue;
            if (recText.length() > xref.getPos() + xref.getLength()) {
                recText = String.valueOf(recText.substring(0, xref.getPos())) + recText.substring(xref.getPos() + xref.getLength());
                record.setText(recText);
            }
            record.remove((Samdas.Range)xref);
            changed = true;
        }
        if (changed) {
            this.updateEintrag(samdas.toString(), true);
        }
    }

    private boolean isEintragEditable() {
        boolean editable = false;
        boolean hasRight = AccessControlServiceHolder.get().evaluate(EvACE.of(IEncounter.class, (Right)Right.UPDATE).and(Right.EXECUTE));
        editable = hasRight ? this.isEditable(true, false, true) : this.isEditable(true, true, true);
        return editable;
    }

    public void setEintrag(VersionedResource eintrag, boolean force) {
        if (force || this.isEintragEditable()) {
            this.setVersionedResource(FLD_ENTRY, eintrag.getHead());
        }
    }

    public void updateEintrag(String eintrag, boolean force) {
        if (force || this.isEintragEditable()) {
            this.setVersionedResource(FLD_ENTRY, eintrag);
        }
    }

    public void purgeEintrag() {
        VersionedResource vr = this.getEintrag();
        vr.purge();
        this.setBinary(FLD_ENTRY, vr.serialize());
    }

    public Mandant getMandant() {
        return Mandant.load(this.get(FLD_MANDATOR_ID));
    }

    public void setMandant(Mandant m) {
        if (m != null) {
            this.set(FLD_MANDATOR_ID, m.getId());
        }
    }

    public void setMandant(IMandator m) {
        if (m != null) {
            this.set(FLD_MANDATOR_ID, m.getId());
        }
    }

    @Deprecated
    public void setDatum(String date, boolean force) {
        LocalDate localDate = LocalDate.parse(date, this.dateFormatter);
        if (force || this.isEditable(true)) {
            this.set(DATE, this.dateFormatter.format(localDate));
        }
    }

    @Nullable
    public LocalDateTime getDateTime() {
        String[] values = this.get(true, DATE, FLD_TIME);
        LocalDate date = LocalDate.parse(values[0], this.dateFormatter);
        LocalTime time = LocalTime.parse(values[1], this.timeFormatter);
        return LocalDateTime.of(date, time);
    }

    public void setDateTime(LocalDateTime dateTime, boolean force) {
        if (force || this.isEditable(true)) {
            this.set(new String[]{DATE, FLD_TIME}, this.dateFormatter.format(dateTime), this.timeFormatter.format(dateTime));
        }
    }

    public String getDatum() {
        String ret = this.get(DATE);
        return ret;
    }

    public Rechnung getRechnung() {
        String invoiceId = this.get(FLD_BILL_ID);
        if (invoiceId == null) {
            return null;
        }
        return Rechnung.load(invoiceId);
    }

    public List<Rechnung> getRechnungen() {
        List<VerrechnetCopy> konsVerrechnet = VerrechnetCopy.getVerrechnetCopyByConsultation(this);
        ArrayList<Rechnung> ret = new ArrayList<Rechnung>();
        HashSet<String> rechnungsIds = new HashSet<String>();
        for (VerrechnetCopy verrechnetCopy : konsVerrechnet) {
            String rechnungsId = verrechnetCopy.get("RechnungId");
            rechnungsIds.add(rechnungsId);
        }
        for (String rechnungsId : rechnungsIds) {
            Rechnung rechnung = Rechnung.load(rechnungsId);
            if (rechnung == null) continue;
            ret.add(rechnung);
        }
        return ret;
    }

    public void setRechnung(Rechnung r) {
        if (r != null) {
            this.set(FLD_BILL_ID, r.getId());
        }
    }

    private boolean isEditable(boolean checkMandant, boolean checkBill, boolean showError) {
        boolean ok;
        boolean bMandantLoggedIn;
        Mandant m = this.getMandant();
        checkMandant = !AccessControlServiceHolder.get().evaluate(EvACE.of((String)"LSTG_CHARGE_FOR_ALL"));
        boolean mandantOK = true;
        boolean mandatorIsActive = false;
        boolean billOK = true;
        Mandant mandator = ElexisEventDispatcher.getSelectedMandator();
        boolean bl = bMandantLoggedIn = mandator != null;
        if (m != null && mandator != null) {
            if (checkMandant && !m.getId().equals(mandator.getId())) {
                mandantOK = false;
            }
            if (checkBill) {
                InvoiceState state;
                Rechnung rn = this.getRechnung();
                billOK = rn == null || !rn.exists() ? true : (state = rn.getInvoiceState()) == InvoiceState.CANCELLED;
            }
        }
        if (mandator != null) {
            mandatorIsActive = !mandator.isInactive();
        }
        boolean bl2 = ok = billOK && mandantOK && bMandantLoggedIn && mandatorIsActive;
        if (ok) {
            return true;
        }
        if (showError) {
            StringBuilder sb = new StringBuilder();
            if (!bMandantLoggedIn) {
                sb.append("Es ist kein Mandant eingeloggt.");
            }
            if (!billOK) {
                sb.append("F\u00fcr diese Behandlung wurde bereits eine Rechnung erstellt.");
            }
            if (!mandantOK) {
                sb.append("Diese Behandlung ist nicht von Ihnen");
            }
            if (!mandatorIsActive) {
                sb.append("Der gew\u00e4hlte Mandant is inaktiv.");
            }
            MessageEvent.fireError((String)"Konsultation kann nicht ge\u00e4ndert werden", (String)sb.toString());
        }
        return false;
    }

    public boolean isEditable(boolean showError) {
        Fall fall = this.getFall();
        if (fall != null && !fall.isOpen() && showError) {
            MessageEvent.fireError((String)"Fall geschlossen", (String)"Diese Konsultation geh\u00f6rt zu einem abgeschlossenen Fall");
            return false;
        }
        return this.isEditable(true, true, showError);
    }

    public int getStatus() {
        return this.getStatus(this.getRechnung());
    }

    private int getStatus(Rechnung invoice) {
        if (invoice != null) {
            return invoice.getInvoiceState().getState();
        }
        Mandant rm = this.getMandant();
        if (rm != null && rm.equals(ElexisEventDispatcher.getSelected(Mandant.class))) {
            if (this.getDatum().equals(new TimeTool().toString(4))) {
                return InvoiceState.FROM_TODAY.getState();
            }
            return InvoiceState.NOT_FROM_TODAY.getState();
        }
        return InvoiceState.NOT_FROM_YOU.getState();
    }

    public String getStatusText() {
        String statusText = "";
        Rechnung rechnung = this.getRechnung();
        if (rechnung != null) {
            statusText = String.valueOf(statusText) + "RG " + rechnung.getNr() + ": ";
        }
        int status = this.getStatus(rechnung);
        InvoiceState invoiceState = InvoiceState.fromState((int)status);
        statusText = String.valueOf(statusText) + invoiceState.getLocaleText();
        return statusText;
    }

    @Override
    public String getLabel() {
        StringBuffer ret = new StringBuffer();
        Mandant m = this.getMandant();
        ret.append(this.getDatum()).append(" (").append(this.getStatusText()).append(") - ").append(m == null ? "?" : m.getLabel());
        return ret.toString();
    }

    public String getVerboseLabel() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getFall().getPatient().getName()).append(" ").append(this.getFall().getPatient().getVorname()).append(", ").append(this.getFall().getPatient().getGeburtsdatum()).append(" - ").append(this.getDatum());
        return ret.toString();
    }

    public ArrayList<IDiagnose> getDiagnosen() {
        ArrayList<IDiagnose> ret = new ArrayList<IDiagnose>();
        JdbcLink.Stm stm = this.getDBConnection().getStatement();
        ResultSet rs1 = stm.query("SELECT DIAGNOSEID FROM BEHDL_DG_JOINT INNER JOIN BEHANDLUNGEN on BehandlungsID=BEHANDLUNGEN.id where BEHDL_DG_JOINT.deleted='0' and BEHANDLUNGEN.deleted='0' AND BEHANDLUNGSID=" + JdbcLink.wrap((String)this.getId()));
        StringBuilder sb = new StringBuilder();
        try {
            try {
                while (rs1.next()) {
                    String dgID = rs1.getString(1);
                    JdbcLink.Stm stm2 = this.getDBConnection().getStatement();
                    ResultSet rs2 = stm2.query("SELECT DG_CODE,KLASSE FROM DIAGNOSEN WHERE ID=" + JdbcLink.wrap((String)dgID));
                    if (rs2.next()) {
                        sb.setLength(0);
                        sb.append(rs2.getString(2)).append("::");
                        sb.append(rs2.getString(1));
                        try {
                            Optional loaded = StoreToStringServiceHolder.get().loadFromString(sb.toString());
                            loaded.ifPresent(ld -> {
                                if (ld instanceof IDiagnosis) {
                                    ret.add(new DiagnoseAdapter((IDiagnosis)ld));
                                }
                            });
                        }
                        catch (Exception ex) {
                            log.error("Fehlerhafter Diagnosecode " + sb.toString());
                        }
                    }
                    rs2.close();
                    this.getDBConnection().releaseStatement(stm2);
                }
                rs1.close();
            }
            catch (Exception ex) {
                ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.data", 0, "Persistence error: " + ex.getMessage(), ex, 2);
                throw new PersistenceException((IStatus)status);
            }
        }
        finally {
            this.getDBConnection().releaseStatement(stm);
        }
        return ret;
    }

    public void addDiagnose(IDiagnose dg) {
        if (!this.isEditable(true)) {
            return;
        }
        String dgid = this.prepareDiagnoseSelectWithCodeAndClass(dg.getCode(), dg.getClass().getName());
        if (dgid != null) {
            return;
        }
        String diagnosisEntryExists = this.getDBConnection().queryString("SELECT ID FROM DIAGNOSEN WHERE KLASSE=" + JdbcLink.wrap((String)dg.getClass().getName()) + " AND DG_CODE=" + JdbcLink.wrap((String)dg.getCode()));
        StringBuilder sql = new StringBuilder(200);
        if (StringTool.isNothing((Object)diagnosisEntryExists)) {
            diagnosisEntryExists = ElexisIdGenerator.generateId();
            sql.append("INSERT INTO DIAGNOSEN (ID, LASTUPDATE, DG_CODE, DG_TXT, KLASSE) VALUES (").append(JdbcLink.wrap((String)diagnosisEntryExists)).append(",").append(Long.toString(System.currentTimeMillis())).append(",").append(JdbcLink.wrap((String)dg.getCode())).append(",").append(JdbcLink.wrap((String)dg.getText())).append(",").append(JdbcLink.wrap((String)dg.getClass().getName())).append(")");
            this.getDBConnection().exec(sql.toString());
            sql.setLength(0);
        }
        sql.append("INSERT INTO BEHDL_DG_JOINT (ID,BEHANDLUNGSID,DIAGNOSEID) VALUES (").append(JdbcLink.wrap((String)ElexisIdGenerator.generateId())).append(",").append(this.getWrappedId()).append(",").append(JdbcLink.wrap((String)diagnosisEntryExists)).append(")");
        this.getDBConnection().exec(sql.toString());
        this.getFall().getPatient().countItem(dg);
        CoreHub.getLoggedInContact().countItem(dg);
        this.refreshLastUpdateAndSendUpdateEvent(FLD_JOINT_DIAGNOSEN);
    }

    public void removeDiagnose(IDiagnose dg) {
        if (this.isEditable(true)) {
            String code;
            String dgid = this.prepareDiagnoseSelectWithCodeAndClass(dg.getCode(), dg.getClass().getName());
            if (dgid == null && (code = dg.getCode()) != null && code.length() == 2 && code.charAt(1) == '0') {
                code = code.substring(0, 1);
                dgid = this.prepareDiagnoseSelectWithCodeAndClass(code, dg.getClass().getName());
            }
            if (dgid == null) {
                log.warn("Requested delete of diagnosis which could not be resolved [{}] in consultation [{}]", (Object)(String.valueOf(dg.getCode()) + "/" + dg.getClass().getName()), (Object)this.getId());
            } else {
                StringBuilder sql = new StringBuilder();
                sql.append("DELETE FROM BEHDL_DG_JOINT WHERE BehandlungsID=").append(this.getWrappedId()).append(" AND DiagnoseId=" + JdbcLink.wrap((String)dgid));
                log.debug(sql.toString());
                this.getDBConnection().exec(sql.toString());
                this.refreshLastUpdateAndSendUpdateEvent(FLD_JOINT_DIAGNOSEN);
            }
        }
    }

    private String prepareDiagnoseSelectWithCodeAndClass(String code, String classname) {
        PreparedStatement pst = this.getDBConnection().getPreparedStatement("SELECT BDJ.DiagnoseId FROM BEHDL_DG_JOINT BDJ, DIAGNOSEN D WHERE BDJ.BehandlungsID=? AND D.ID = BDJ.DiagnoseID AND D.DG_CODE=? AND D.KLASSE=?;");
        try {
            pst.setString(1, this.getId());
            pst.setString(2, code);
            pst.setString(3, classname);
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        catch (SQLException e) {
            MessageEvent.fireError((String)"Fehler beim L\u00f6schen", (String)e.getMessage(), (Exception)e);
            log.error("Error deleting diagnosis", (Throwable)e);
        }
        finally {
            this.getDBConnection().releasePreparedStatement(pst);
        }
        return null;
    }

    public List<Verrechnet> getLeistungen() {
        Query qbe = new Query(Verrechnet.class);
        qbe.add("Konsultation", "=", this.getId());
        qbe.orderBy(false, "Klasse", "Leistg_code");
        return qbe.execute();
    }

    public List<Verrechnet> getLeistungen(String[] prefetch) {
        Query qbe = new Query(Verrechnet.class, "Konsultation", this.getId(), "LEISTUNGEN", prefetch);
        qbe.orderBy(false, "Klasse", "Leistg_code");
        return qbe.execute();
    }

    public Verrechnet getVerrechnet(IVerrechenbar iVerrechenbar) {
        if (iVerrechenbar != null && iVerrechenbar.getId() != null) {
            Query qbe = new Query(Verrechnet.class);
            qbe.add("Konsultation", "=", this.getId());
            qbe.add("Leistg_code", "=", iVerrechenbar.getId());
            List verrechnets = qbe.execute();
            if (verrechnets.size() == 1) {
                return (Verrechnet)verrechnets.get(0);
            }
        }
        return null;
    }

    @Deprecated
    public Result<Verrechnet> removeLeistung(Verrechnet ls) {
        if (this.isEditable(true)) {
            IVerrechenbar v = ls.getVerrechenbar();
            int z = ls.getZahl();
            Result<Verrechnet> result = v.getOptifier().remove(ls, this);
            if (result.isOK() && v instanceof Artikel) {
                Prescription prescription;
                IArticle art = (IArticle)((Object)v);
                Mandant mandator = ElexisEventDispatcher.getSelectedMandator();
                String artSts = StoreToStringServiceHolder.getStoreToString(art);
                StockServiceHolder.get().performSingleReturn(artSts, z, mandator != null ? mandator.getId() : null);
                String prescId = ls.getDetail("prescriptionId");
                if (prescId instanceof String && (prescription = Prescription.load(prescId)).getEntryType() == EntryType.SELF_DISPENSED) {
                    prescription.remove();
                    ElexisEventDispatcher.reload(Prescription.class);
                }
            }
            return result;
        }
        return new Result(Result.SEVERITY.WARNING, 3, "Behandlung geschlossen oder nicht von Ihnen", null, false);
    }

    @Deprecated
    public Result<IVerrechenbar> addLeistung(IVerrechenbar l) {
        if (this.isEditable(true)) {
            IVerrechenbar beforeAdjust = l;
            for (IVerrechenbarAdjuster iVerrechenbarAdjuster : adjusters) {
                l = iVerrechenbarAdjuster.adjust(l, this);
            }
            if (l != null) {
                IOptifier optifier = l.getOptifier();
                Result<IVerrechenbar> result = optifier.add(l, this);
                if (!result.isOK() && result.getCode() == 11) {
                    String initialResult = result.toString();
                    optifier.putContext("Seite", "r");
                    result = optifier.add(l, this);
                    if (!result.isOK() && result.getCode() == 11) {
                        optifier.putContext("Seite", "l");
                        result = optifier.add(l, this);
                    }
                    if (result.isOK()) {
                        MessageEvent.fireInformation((String)"Info", (String)("Achtung: " + initialResult + "\n\n Es wurde bei der Position " + l.getCode() + " automatisch die Seite gewechselt." + " Bitte korrigieren Sie die Leistung falls dies nicht korrekt ist."));
                    }
                    optifier.clearContext();
                }
                if (result.isOK()) {
                    ElexisEventDispatcher.update(this);
                    this.getFall().getPatient().countItem(l);
                    CoreHub.getLoggedInContact().countItem(l);
                    CoreHub.getLoggedInContact().statForString("LeistungenMFU", l.getCodeSystemName());
                }
                return result;
            }
            return new Result(Result.SEVERITY.WARNING, 1, "Folgende Leistung '" + beforeAdjust.getCode() + "' konnte im aktuellen Kontext (Fall, Konsultation, Gesetz) nicht verrechnet werden.", null, false);
        }
        return new Result(Result.SEVERITY.WARNING, 2, "Behandlung geschlossen oder nicht von Ihnen", null, false);
    }

    public String getAuthor() {
        VersionedResource.ResourceItem item;
        String author = "";
        VersionedResource resource = this.getEintrag();
        if (resource != null && (item = resource.getVersion(resource.getHeadVersion())) != null) {
            return item.remark;
        }
        return author;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getKosten() {
        int sum = 0;
        JdbcLink.Stm stm = this.getDBConnection().getStatement();
        try {
            try {
                ResultSet res = stm.query("SELECT EK_KOSTEN FROM LEISTUNGEN WHERE deleted='0' AND BEHANDLUNG=" + this.getWrappedId());
                while (res != null) {
                    if (!res.next()) {
                        return sum;
                    }
                    sum += res.getInt(1);
                }
                return sum;
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                this.getDBConnection().releaseStatement(stm);
                return 0;
            }
        }
        finally {
            this.getDBConnection().releaseStatement(stm);
        }
    }

    public int getMinutes() {
        int sum = 0;
        List<Verrechnet> l = this.getLeistungen();
        for (Verrechnet v : l) {
            IVerrechenbar iv = v.getVerrechenbar();
            if (iv == null) continue;
            sum += v.getZahl() * iv.getMinutes();
        }
        return sum;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public double getUmsatz() {
        double sum = 0.0;
        JdbcLink.Stm stm = this.getDBConnection().getStatement();
        try {
            try {
                ResultSet res = stm.query("SELECT VK_PREIS,ZAHL,SCALE FROM LEISTUNGEN WHERE deleted='0' AND BEHANDLUNG=" + this.getWrappedId());
                while (res != null) {
                    if (!res.next()) {
                        return sum;
                    }
                    double scale = res.getDouble(3) / 100.0;
                    sum += res.getDouble(1) * res.getDouble(2) * scale;
                }
                return sum;
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                this.getDBConnection().releaseStatement(stm);
                return 0.0;
            }
        }
        finally {
            this.getDBConnection().releaseStatement(stm);
        }
    }

    @Deprecated
    public double getGewinn() {
        return this.getUmsatz() - (double)this.getKosten();
    }

    public void changeScale(IVerrechenbar v, int scale) {
        if (this.isEditable(true)) {
            StringBuilder sb = new StringBuilder();
            sb.append("UPDATE LEISTUNGEN SET SCALE='").append(scale).append("' WHERE BEHANDLUNG=").append(this.getWrappedId()).append(" AND LEISTG_CODE=").append(JdbcLink.wrap((String)v.getId()));
            this.getDBConnection().exec(sb.toString());
        }
    }

    public void changeZahl(IVerrechenbar v, int nz) {
        if (this.isEditable(true)) {
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE LEISTUNGEN SET ZAHL=").append(nz).append(" WHERE LEISTG_CODE=").append(JdbcLink.wrap((String)v.getId())).append(" AND BEHANDLUNG=").append(this.getWrappedId());
            this.getDBConnection().exec(sql.toString());
        }
    }

    @Override
    public boolean delete() {
        return this.delete(true);
    }

    public boolean delete(boolean forced) {
        List<Verrechnet> vv;
        if ((forced || this.isEditable(true)) && ((vv = this.getLeistungen()).isEmpty() || forced && AccessControlServiceHolder.get().evaluate((EvaluatableACE)new ObjectEvaluatableACE(IEncounter.class, Right.REMOVE, StoreToStringServiceHolder.getStoreToString(this))))) {
            this.delete_dependent();
            return super.delete();
        }
        return false;
    }

    private boolean delete_dependent() {
        for (Verrechnet vv : new Query(Verrechnet.class, "Konsultation", this.getId()).execute()) {
            vv.delete();
        }
        this.getDBConnection().exec("DELETE FROM BEHDL_DG_JOINT WHERE BEHANDLUNGSID=" + this.getWrappedId());
        return true;
    }

    @Override
    public int compareTo(Konsultation b) {
        LocalDateTime me = this.getDateTime();
        LocalDateTime other = b.getDateTime();
        return me.compareTo(other);
    }

    public static Konsultation getAktuelleKons() {
        Konsultation ret = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
        Patient pat = ElexisEventDispatcher.getSelectedPatient();
        if (ret != null && (pat == null || ret.getFall().getPatient().getId().equals(pat.getId()))) {
            return ret;
        }
        if (pat != null) {
            ret = pat.getLetzteKons(true);
            return ret;
        }
        MessageEvent.fireError((String)"Kein Patient ausgew\u00e4hlt", (String)"Bitte w\u00e4hlen Sie zuerst einen Patienten aus");
        return null;
    }

    protected Konsultation() {
    }

    @Override
    public boolean isDragOK() {
        return true;
    }

    @Deprecated
    public static void neueKons(String initialText) {
        Patient actPatient = ElexisEventDispatcher.getSelectedPatient();
        Fall actFall = (Fall)ElexisEventDispatcher.getSelected(Fall.class);
        if (actFall == null) {
            if (actPatient == null) {
                MessageEvent.fireError((String)Messages.GlobalActions_CantCreateKons, (String)Messages.Core_Please_Select_first_a_Patient);
                return;
            }
            if (actFall == null) {
                Konsultation k = actPatient.getLetzteKons(false);
                if (k != null) {
                    actFall = k.getFall();
                    if (actFall == null) {
                        MessageEvent.fireError((String)Messages.GlobalActions_CantCreateKons, (String)Messages.GlobalActions_DoSelectCase);
                        return;
                    }
                } else {
                    Fall[] faelle = actPatient.getFaelle();
                    actFall = faelle == null || faelle.length == 0 ? actPatient.neuerFall(Fall.getDefaultCaseLabel(), Fall.getDefaultCaseReason(), Fall.getDefaultCaseLaw()) : faelle[0];
                }
            }
        } else if (!actFall.getPatient().equals(actPatient)) {
            if (actPatient != null) {
                Konsultation lk = actPatient.getLetzteKons(false);
                if (lk != null) {
                    actFall = lk.getFall();
                }
            } else {
                MessageEvent.fireError((String)Messages.GlobalActions_CantCreateKons, (String)Messages.GlobalActions_DoSelectCase);
                return;
            }
        }
        if (!actFall.isOpen()) {
            MessageEvent.fireError((String)Messages.GlobalActions_casclosed, (String)Messages.Core_Cannot_add_consultation_to_closed_case);
            return;
        }
        Konsultation actLetzte = actFall.getLetzteBehandlung();
        if (actLetzte != null && actLetzte.getDatum().equals(new TimeTool().toString(4)) && !CoreOperationAdvisorHolder.get().openQuestion(Messages.GlobalActions_SecondForToday, Messages.GlobalActions_SecondForTodayQuestion)) {
            return;
        }
        Konsultation n = actFall.neueKonsultation();
        n.setMandant(ElexisEventDispatcher.getSelectedMandator());
        if (initialText != null) {
            n.updateEintrag(initialText, false);
        }
        ElexisEventDispatcher.fireSelectionEvent(actFall);
        ElexisEventDispatcher.fireSelectionEvent(n);
    }

    public static IDiagnose getDefaultDiagnose() {
        IDiagnose ret = null;
        String diagnoseId = ConfigServiceHolder.getUser((String)"fall/std_diagnose", (String)"");
        if (diagnoseId.length() > 1) {
            ret = (IDiagnose)((Object)CoreHub.poFactory.createFromString(diagnoseId));
        }
        return ret;
    }

    public Konsultation createCopy(Fall fall, Rechnung invoiceSrc) {
        if (fall != null && invoiceSrc != null) {
            Konsultation clone = fall.neueKonsultation();
            Mandant m = this.getMandant();
            if (m != null) {
                clone.setMandant(m);
            }
            clone.setDatum(this.getDatum(), true);
            for (IDiagnose diagnose : this.getDiagnosen()) {
                clone.addDiagnose(diagnose);
            }
            VersionedResource vr = clone.getEintrag();
            vr.update("Diese Konsultation wurde durch die Korrektur der Rechnung " + invoiceSrc.getNr() + " erstellt.", "Rechnungskorrektur");
            clone.setEintrag(vr, true);
            return clone;
        }
        return null;
    }

    public boolean isBillable() {
        return this.get(FLD_BILLABLE).equals("1");
    }

    public void setBillable(boolean value) {
        if (value) {
            this.set(FLD_BILLABLE, "1");
        } else {
            this.set(FLD_BILLABLE, "0");
        }
    }

    static class BehandlungsComparator
    implements Comparator<Konsultation> {
        boolean rev;

        BehandlungsComparator(boolean reverse) {
            this.rev = reverse;
        }

        @Override
        public int compare(Konsultation b1, Konsultation b2) {
            TimeTool t1 = new TimeTool(b1.getDatum());
            TimeTool t2 = new TimeTool(b2.getDatum());
            if (this.rev) {
                return t2.compareTo((Calendar)t1);
            }
            return t1.compareTo((Calendar)t2);
        }
    }
}

