/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.core.ui.views.rechnung.RnActions;
import ch.elexis.core.ui.views.rechnung.RnContentProvider;
import ch.elexis.core.ui.views.rechnung.RnControlFieldProvider;
import ch.elexis.core.ui.views.rechnung.RnMenuListener;
import ch.elexis.core.ui.views.rechnung.invoice.InvoiceListBottomComposite;
import ch.elexis.data.Fall;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.Tree;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class RechnungsListeView
extends ViewPart
implements IRefreshable {
    public static final String ID = "ch.elexis.RechnungsListeView";
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this);
    CommonViewer cv;
    ViewerConfigurer vc;
    RnActions actions;
    RnContentProvider cntp;
    RnControlFieldProvider cfp;
    private InvoiceListBottomComposite invoiceListeBottomComposite;
    private boolean isOldShown = false;

    @Optional
    @Inject
    public void activeMandator(IMandator mandator) {
        if (this.invoiceListeBottomComposite != null) {
            this.invoiceListeBottomComposite.updateMahnAutomatic();
        }
    }

    public void createPartControl(Composite p) {
        p.setLayout((Layout)new GridLayout());
        Composite comp = new Composite(p, 0);
        comp.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        comp.setLayout((Layout)new GridLayout());
        this.cv = new CommonViewer();
        this.cntp = new RnContentProvider(this, this.cv);
        this.cfp = new RnControlFieldProvider();
        this.vc = new ViewerConfigurer(this.cntp, new ViewerConfigurer.TreeLabelProvider(), this.cfp, new ViewerConfigurer.DefaultButtonProvider(), new SimpleWidgetProvider(0, 514, this.cv));
        this.cv.create(this.vc, comp, 0, this.getViewSite());
        this.cv.addDoubleClickListener(new CommonViewer.PoDoubleClickListener(){

            @Override
            public void doubleClicked(PersistentObject obj, CommonViewer cv) {
                if (obj instanceof Patient) {
                    try {
                        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((Patient)obj));
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.PatDetail_v2");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                } else if (obj instanceof Fall) {
                    try {
                        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((Fall)obj));
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.FallDetailView");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                } else if (obj instanceof Rechnung) {
                    try {
                        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((Rechnung)obj));
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.RechnungsDetailView");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.invoiceListeBottomComposite = new InvoiceListBottomComposite(comp, 0);
        this.cv.getViewerWidget().getControl().setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        ViewMenus menu = new ViewMenus(this.getViewSite());
        this.actions = new RnActions(this);
        menu.createToolbar(new IAction[]{this.actions.reloadAction, this.actions.mahnWizardAction, this.actions.rnFilterAction, null, this.actions.rnExportAction});
        menu.createMenu(new IAction[]{this.actions.expandAllAction, this.actions.collapseAllAction, this.actions.printListeAction, this.actions.exportListAction, this.actions.addAccountExcessAction});
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener((IMenuListener)new RnMenuListener(this));
        this.cv.setContextMenu(mgr);
        this.cntp.startListening();
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public InvoiceListBottomComposite getInvoiceListeBottomComposite() {
        return this.invoiceListeBottomComposite;
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        this.cntp.stopListening();
        super.dispose();
    }

    public void setFocus() {
        if (!this.isOldShown) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Ansicht veraltet", (String)("Die Ansicht " + this.getTitle() + " ist veraltet, und wird nicht mehr unterst\u00fctzt. Bitte verwenden Sie die Rechnungsliste Ansicht."));
            this.isOldShown = true;
        }
    }

    List<Rechnung> createList() {
        IStructuredSelection sel = (IStructuredSelection)this.cv.getViewerWidget().getSelection();
        List at = sel.toList();
        LinkedList<Rechnung> ret = new LinkedList<Rechnung>();
        for (Tree t : at) {
            Rechnung rn;
            if (t.contents instanceof Patient) {
                for (Tree tp : t.getChildren()) {
                    for (Tree tf : tp.getChildren()) {
                        Rechnung rn2 = (Rechnung)tf.contents;
                        if (ret.contains(rn2)) continue;
                        ret.add(rn2);
                    }
                }
                continue;
            }
            if (t.contents instanceof Fall) {
                for (Tree tr : t.getChildren()) {
                    Rechnung rn3 = (Rechnung)tr.contents;
                    if (ret.contains(rn3)) continue;
                    ret.add(rn3);
                }
                continue;
            }
            if (!(t.contents instanceof Rechnung) || ret.contains(rn = (Rechnung)t.contents)) continue;
            ret.add(rn);
        }
        return ret;
    }

    @Override
    public void refresh() {
        this.reload(IInvoice.class);
    }

    @Inject
    @Optional
    public void reload(@UIEventTopic(value="info/elexis/model/reload") Class<?> clazz) {
        if (IInvoice.class.equals(clazz)) {
            CoreUiUtil.runAsyncIfActive(() -> this.cv.notify(CommonViewer.Message.update), (Object)this.cv);
        }
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }
}

