/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.codesystems;

import ch.elexis.core.constants.StringConstants;
import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.ICodeElementBlock;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.status.ElexisStatus;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.commands.EditEigenleistungUi;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.IDetailDisplay;
import ch.elexis.core.ui.views.codesystems.BlockElementViewerItem;
import ch.elexis.core.ui.views.codesystems.Messages;
import ch.elexis.data.Eigenleistung;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.StringTool;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.LoggerFactory;

public class BlockDetailDisplay
implements IDetailDisplay {
    private ScrolledForm form;
    private FormToolkit tk;
    private Text tName;
    private Text tMacro;
    private Combo cbMandant;
    private TableViewer viewer;
    private Button bNew;
    private Button bEigen;
    private Button bDiag;
    private List<IMandator> lMandanten;
    private DataBindingContext dbc = new DataBindingContext();
    private WritableValue<ICodeElementBlock> master = new WritableValue(null, ICodeElementBlock.class);
    private BlockComparator comparator;
    private Action removeLeistung;
    private Action moveUpAction;
    private Action moveDownAction;
    private Action editAction;
    private Action countAction;
    private TableViewerFocusCellManager focusCellManager;
    private final IChangeListener changeListener = event -> {
        if (this.master.getValue() instanceof ICodeElementBlock) {
            CoreModelServiceHolder.get().save((Identifiable)this.master.getValue());
        }
        ContextServiceHolder.get().postEvent("info/elexis/model/update", this.master.getValue());
    };

    @Inject
    public void selection(@Optional ICodeElementBlock block) {
        if (block != null && !this.form.isDisposed()) {
            Display.getDefault().syncExec(() -> this.display(block));
        }
    }

    @Optional
    @Inject
    public void update(@UIEventTopic(value="info/elexis/model/update") ICodeElementBlock block) {
        if (block != null && this.master.getValue() != null && ((ICodeElementBlock)this.master.getValue()).equals(block)) {
            this.updateViewerInput(block);
        }
    }

    @Override
    public Composite createDisplay(Composite parent, final IViewSite site) {
        this.tk = UiDesk.getToolkit();
        this.form = this.tk.createScrolledForm(parent);
        this.form.setData("TEST_COMP_NAME", (Object)"blkd_form");
        Composite body = this.form.getBody();
        body.setData("TEST_COMP_NAME", (Object)"blkd_body");
        body.setBackground(parent.getBackground());
        body.setLayout((Layout)new GridLayout(2, false));
        this.tk.createLabel(body, Messages.Core_Name).setBackground(parent.getBackground());
        this.tName = this.tk.createText(body, "", 2048);
        this.tName.setData("TEST_COMP_NAME", (Object)"blkd_Name_lst");
        this.tName.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        ISWTObservableValue txtNameObservableUi = WidgetProperties.text((int)24).observeDelayed(100, (Widget)this.tName);
        IObservableValue txtNameObservable = PojoProperties.value((String)"code", String.class).observeDetail(this.master);
        txtNameObservable.addChangeListener(this.changeListener);
        this.dbc.bindValue((IObservableValue)txtNameObservableUi, txtNameObservable);
        this.tk.createLabel(body, Messages.Core_Macro).setBackground(parent.getBackground());
        this.tMacro = this.tk.createText(body, "", 2048);
        this.tMacro.setData("TEST_COMP_NAME", (Object)"blkd_Makro_lst");
        this.tMacro.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        ISWTObservableValue txtMacroObservableUi = WidgetProperties.text((int)24).observeDelayed(100, (Widget)this.tMacro);
        IObservableValue txtMacroObservable = PojoProperties.value((String)"macro", String.class).observeDetail(this.master);
        txtMacroObservable.addChangeListener(this.changeListener);
        this.dbc.bindValue((IObservableValue)txtMacroObservableUi, txtMacroObservable);
        this.tk.createLabel(body, StringConstants.MANDATOR).setBackground(parent.getBackground());
        this.cbMandant = new Combo(body, 0);
        this.cbMandant.setData("TEST_COMP_NAME", (Object)"blkd_Mandant_cb");
        this.cbMandant.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tk.adapt((Composite)this.cbMandant);
        IQuery query = CoreModelServiceHolder.get().getQuery(IMandator.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__MANDATOR, IQuery.COMPARATOR.EQUALS, (Object)Boolean.TRUE);
        this.lMandanten = query.execute();
        this.cbMandant.add(Messages.Core_All);
        for (IMandator m : this.lMandanten) {
            this.cbMandant.add(m.getLabel());
        }
        this.cbMandant.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = BlockDetailDisplay.this.cbMandant.getSelectionIndex();
                java.util.Optional selected = ContextServiceHolder.get().getTyped(ICodeElementBlock.class);
                selected.ifPresent(block -> {
                    if (idx > 0) {
                        block.setMandator(BlockDetailDisplay.this.lMandanten.get(idx - 1));
                    } else {
                        block.setMandator(null);
                    }
                });
            }
        });
        Group gList = new Group(body, 2048);
        gList.setText(Messages.Core_Services);
        gList.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, true));
        gList.setLayout((Layout)new FillLayout());
        this.tk.adapt((Composite)gList);
        this.viewer = new TableViewer((Composite)gList, 66306);
        this.viewer.setData("TEST_COMP_NAME", (Object)"blkd_Leistung_Lst");
        this.tk.adapt(this.viewer.getControl(), true, true);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.comparator = new BlockComparator();
        this.createColumns();
        this.updateViewerInput(ContextServiceHolder.get().getTyped(ICodeElementBlock.class).orElse(null));
        TextTransfer textTransfer = TextTransfer.getInstance();
        Transfer[] types = new Transfer[]{textTransfer};
        this.viewer.addDropSupport(1, types, new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.data instanceof IArticle && ((IArticle)event.data).isProduct()) {
                    event.detail = 0;
                    event.detail = 0;
                    return;
                }
                event.detail = 1;
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                String[] dl;
                java.util.Optional block = ContextServiceHolder.get().getTyped(ICodeElementBlock.class);
                String drp = (String)event.data;
                String[] stringArray = dl = drp.split(",");
                int n = dl.length;
                int n2 = 0;
                while (n2 < n) {
                    String obj = stringArray[n2];
                    Object dropped = StoreToStringServiceHolder.getLoadFromString((String)obj);
                    if (dropped instanceof ICodeElement) {
                        block.ifPresent(b -> b.addElement((ICodeElement)dropped));
                    } else {
                        LoggerFactory.getLogger(this.getClass()).warn("Dropped unknown store to string [" + dl + "]");
                    }
                    ++n2;
                }
                block.ifPresent(b -> {
                    CoreModelServiceHolder.get().save((Identifiable)b);
                    BlockDetailDisplay.this.updateViewerInput((ICodeElementBlock)b);
                    ContextServiceHolder.get().postEvent("info/elexis/model/reload", ICodeElementBlock.class);
                });
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
        this.focusCellManager = new TableViewerFocusCellManager(this.viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewer));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ViewerCell focusCell = BlockDetailDisplay.this.focusCellManager.getFocusCell();
                int columnIndex = focusCell.getColumnIndex();
                if (columnIndex == 0) {
                    BlockDetailDisplay.this.countAction.run();
                }
            }
        });
        this.bNew = this.tk.createButton(body, Messages.BlockDetailDisplay_addPredefinedServices, 8);
        this.bNew.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.bNew.setData("TEST_COMP_NAME", (Object)"blkd_addPredefinedServices_btn");
        this.bNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    site.getPage().showView("ch.elexis.LeistungenView");
                }
                catch (Exception ex) {
                    ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.ui", 0, "Fehler beim Starten des Leistungscodes " + ex.getMessage(), ex, 2);
                    StatusManager.getManager().handle((IStatus)status, 2);
                }
            }
        });
        this.bEigen = this.tk.createButton(body, Messages.BlockDetailDisplay_addSelfDefinedServices, 8);
        this.bEigen.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.bEigen.setData("TEST_COMP_NAME", (Object)"blkd_createPredefinedServices_btn");
        this.bEigen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
                    handlerService.executeCommand("ch.elexis.eigenleistung.create", null);
                }
                catch (Exception ex) {
                    throw new RuntimeException("ch.elexis.eigenleistung.create", ex);
                }
                BlockDetailDisplay.this.viewer.refresh();
            }
        });
        this.bDiag = this.tk.createButton(body, "Diagnose hinzuf\u00fcgen", 8);
        this.bDiag.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.bDiag.setData("TEST_COMP_NAME", (Object)"btn_addDiagnosis_btn");
        this.bDiag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    site.getPage().showView("ch.elexis.DiagnosenView");
                }
                catch (Exception ex) {
                    ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.ui", 0, "Fehler beim Starten des Diagnosecodes " + ex.getMessage(), ex, 2);
                    StatusManager.getManager().handle((IStatus)status, 2);
                }
            }
        });
        this.makeActions();
        ViewMenus menus = new ViewMenus(site);
        menus.createControlContextMenu(this.viewer.getControl(), new ViewMenus.IMenuPopulator(){

            @Override
            public IAction[] fillMenu() {
                BlockElementViewerItem element = (BlockElementViewerItem)((IStructuredSelection)BlockDetailDisplay.this.viewer.getSelection()).getFirstElement();
                if (element != null) {
                    if (element.isCodeElementInstanceOf(Eigenleistung.class)) {
                        IAction[] iActionArray = new IAction[6];
                        iActionArray[0] = BlockDetailDisplay.this.moveUpAction;
                        iActionArray[1] = BlockDetailDisplay.this.moveDownAction;
                        iActionArray[3] = BlockDetailDisplay.this.countAction;
                        iActionArray[4] = BlockDetailDisplay.this.removeLeistung;
                        iActionArray[5] = BlockDetailDisplay.this.editAction;
                        return iActionArray;
                    }
                    IAction[] iActionArray = new IAction[5];
                    iActionArray[0] = BlockDetailDisplay.this.moveUpAction;
                    iActionArray[1] = BlockDetailDisplay.this.moveDownAction;
                    iActionArray[3] = BlockDetailDisplay.this.countAction;
                    iActionArray[4] = BlockDetailDisplay.this.removeLeistung;
                    return iActionArray;
                }
                return new IAction[0];
            }
        });
        return body;
    }

    @Override
    public Class<?> getElementClass() {
        return ICodeElementBlock.class;
    }

    @Override
    public void display(Object obj) {
        ICodeElementBlock block = (ICodeElementBlock)obj;
        this.master.setValue((Object)block);
        if (obj == null) {
            this.bNew.setEnabled(false);
            this.cbMandant.select(0);
        } else {
            IMandator mandator = block.getMandator();
            int sel = 0;
            if (mandator != null) {
                String[] items = this.cbMandant.getItems();
                sel = StringTool.getIndex((String[])items, (String)mandator.getLabel());
            }
            this.cbMandant.select(sel);
            this.bNew.setEnabled(true);
        }
        this.updateViewerInput(block);
    }

    private void updateViewerInput(ICodeElementBlock block) {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setInput(BlockElementViewerItem.of(block, true));
        }
    }

    @Override
    public String getTitle() {
        return Messages.BlockDetailDisplay_blocks;
    }

    private void createColumns() {
        String[] titles = new String[]{"Anz.", "Code", "Bezeichnung"};
        int[] bounds = new int[]{45, 125, 600};
        TableViewerColumn colAnz = this.createTableViewerColumn(titles[0], bounds[0], 0, 0);
        colAnz.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof BlockElementViewerItem) {
                    BlockElementViewerItem item = (BlockElementViewerItem)element;
                    return Integer.toString(item.getCount());
                }
                return "";
            }
        });
        this.addColumnSelectionListener(colAnz, 0);
        TableViewerColumn colCode = this.createTableViewerColumn(titles[1], bounds[1], 1, 0);
        colCode.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof BlockElementViewerItem) {
                    BlockElementViewerItem item = (BlockElementViewerItem)element;
                    return item.getCode();
                }
                return "";
            }
        });
        final ViewerComparator codeComparator = new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof BlockElementViewerItem && e2 instanceof BlockElementViewerItem) {
                    BlockElementViewerItem b1 = (BlockElementViewerItem)e1;
                    BlockElementViewerItem b2 = (BlockElementViewerItem)e2;
                    int result = b1.getCode().compareTo(b2.getCode());
                    return this.getSortedAscending(viewer) ? result : -result;
                }
                return 0;
            }

            private boolean getSortedAscending(Viewer viewer) {
                if (viewer.getData("codeSortAscending") != null) {
                    return (Boolean)viewer.getData("codeSortAscending");
                }
                return true;
            }
        };
        colCode.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BlockDetailDisplay.this.viewer.setComparator(codeComparator);
                if (BlockDetailDisplay.this.viewer.getComparator() == codeComparator) {
                    if (BlockDetailDisplay.this.viewer.getData("codeSortAscending") != null) {
                        BlockDetailDisplay.this.viewer.setData("codeSortAscending", (Object)((Boolean)BlockDetailDisplay.this.viewer.getData("codeSortAscending") == false ? 1 : 0));
                    } else {
                        BlockDetailDisplay.this.viewer.setData("codeSortAscending", (Object)Boolean.FALSE);
                    }
                    BlockDetailDisplay.this.viewer.refresh();
                }
            }
        });
        TableViewerColumn colBezeichnung = this.createTableViewerColumn(titles[2], bounds[2], 2, 0);
        colBezeichnung.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof BlockElementViewerItem) {
                    BlockElementViewerItem item = (BlockElementViewerItem)element;
                    return item.getText();
                }
                return "";
            }

            public Color getBackground(Object element) {
                BlockElementViewerItem item;
                String codeSystemName;
                if (element instanceof BlockElementViewerItem && (codeSystemName = (item = (BlockElementViewerItem)element).getCodeSystemName()) != null) {
                    String rgbColor = ConfigServiceHolder.getGlobal((String)("billing/color/" + codeSystemName), (String)"ffffff");
                    return UiDesk.getColorFromRGB(rgbColor);
                }
                return null;
            }
        });
        this.addColumnSelectionListener(colBezeichnung, 2);
    }

    private void addColumnSelectionListener(final TableViewerColumn column, final int index) {
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BlockDetailDisplay.this.viewer.getComparator() == null) {
                    BlockDetailDisplay.this.viewer.setComparator((ViewerComparator)BlockDetailDisplay.this.comparator);
                    BlockDetailDisplay.this.comparator.setDirection(1024);
                } else {
                    int direction = BlockDetailDisplay.this.comparator.getDirection();
                    if (direction == 1024) {
                        BlockDetailDisplay.this.comparator.setDirection(128);
                    } else {
                        BlockDetailDisplay.this.comparator.setDirection(0);
                        BlockDetailDisplay.this.viewer.setComparator(null);
                    }
                }
                BlockDetailDisplay.this.comparator.setColumnIndex(index);
                BlockDetailDisplay.this.viewer.getTable().setSortDirection(BlockDetailDisplay.this.comparator.getDirection());
                BlockDetailDisplay.this.viewer.getTable().setSortColumn(column.getColumn());
                BlockDetailDisplay.this.viewer.refresh();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber, int style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, style);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(false);
        return viewerColumn;
    }

    private void makeActions() {
        this.removeLeistung = new Action(Messages.Core_Remove){

            public void run() {
                java.util.Optional block = ContextServiceHolder.get().getTyped(ICodeElementBlock.class);
                block.ifPresent(b -> {
                    IStructuredSelection sel = (IStructuredSelection)BlockDetailDisplay.this.viewer.getSelection();
                    BlockElementViewerItem selectedElement = (BlockElementViewerItem)sel.getFirstElement();
                    if (selectedElement != null) {
                        selectedElement.remove();
                        BlockDetailDisplay.this.updateViewerInput((ICodeElementBlock)b);
                        ContextServiceHolder.get().postEvent("info/elexis/model/update", b);
                    }
                });
            }
        };
        this.moveUpAction = new Action(Messages.BlockDetailDisplay_moveUp){

            public void run() {
                BlockDetailDisplay.this.moveElement(true);
            }
        };
        this.moveDownAction = new Action(Messages.BlockDetailDisplay_moveDown){

            public void run() {
                BlockDetailDisplay.this.moveElement(false);
            }
        };
        this.editAction = new Action(Messages.Core_DoChange_ellipsis){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.BlockDetailDisplay_changeActionTooltip);
            }

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)BlockDetailDisplay.this.viewer.getSelection();
                BlockElementViewerItem selectedElement = (BlockElementViewerItem)sel.getFirstElement();
                PersistentObject poElement = null;
                ICodeElement firstElement = selectedElement.getFirstElement();
                if (firstElement instanceof Identifiable) {
                    poElement = NoPoUtil.loadAsPersistentObject((Identifiable)((Identifiable)firstElement));
                } else if (firstElement instanceof PersistentObject) {
                    poElement = (PersistentObject)firstElement;
                }
                if (poElement != null) {
                    EditEigenleistungUi.executeWithParams(poElement);
                    ContextServiceHolder.get().getTyped(ICodeElementBlock.class).ifPresent(b -> ContextServiceHolder.get().postEvent("info/elexis/model/update", b));
                }
            }
        };
        this.countAction = new Action("Anzahl"){

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)BlockDetailDisplay.this.viewer.getSelection();
                BlockElementViewerItem selectedElement = (BlockElementViewerItem)sel.getFirstElement();
                InputDialog dlg = new InputDialog(UiDesk.getTopShell(), "Anzahl \u00e4ndern", "Ganzzahlige neue Anzahl", Integer.toString(selectedElement.getCount()), new IInputValidator(){

                    public String isValid(String string) {
                        if (string != null && !string.isEmpty()) {
                            try {
                                Integer.parseInt(string);
                            }
                            catch (NumberFormatException e) {
                                return "Kein ganzzahliger Wert";
                            }
                        }
                        return null;
                    }
                });
                if (dlg.open() == 0) {
                    try {
                        String val = dlg.getValue();
                        selectedElement.setCount(Integer.parseInt(val));
                        java.util.Optional block = ContextServiceHolder.get().getTyped(ICodeElementBlock.class);
                        block.ifPresent(b -> {
                            CoreModelServiceHolder.get().save((Identifiable)b);
                            BlockDetailDisplay.this.updateViewerInput((ICodeElementBlock)b);
                            ContextServiceHolder.get().postEvent("info/elexis/model/update", b);
                        });
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    private void moveElement(boolean up) {
        java.util.Optional block = ContextServiceHolder.get().getTyped(ICodeElementBlock.class);
        block.ifPresent(b -> {
            IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
            BlockElementViewerItem selectedElement = (BlockElementViewerItem)sel.getFirstElement();
            if (selectedElement != null) {
                b.moveElement(selectedElement.getFirstElement(), up);
                CoreModelServiceHolder.get().save((Identifiable)b);
                this.updateViewerInput((ICodeElementBlock)b);
            }
        });
    }

    private class BlockComparator
    extends ViewerComparator {
        private int direction = 0;
        private int columnIndex = 0;

        private BlockComparator() {
        }

        public void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public void setDirection(int value) {
            this.direction = value == 1024 ? 1 : (value == 128 ? -1 : 0);
        }

        public int getDirection() {
            if (this.direction == 1) {
                return 1024;
            }
            if (this.direction == -1) {
                return 128;
            }
            return 0;
        }
    }
}

