/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.data.VerrechenbarFavorites;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class FavoritenComposite
extends Composite {
    private TableViewer tv;
    private Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
    private Font defaultFont;
    private Font boldFont;

    @org.eclipse.e4.core.di.annotations.Optional
    @Inject
    void reloadFavorites(@UIEventTopic(value="info/elexis/model/reload") Class<?> clazz) {
        if (VerrechenbarFavorites.Favorite.class.equals(clazz)) {
            this.update();
        }
    }

    public FavoritenComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        CLabel lblHeader = new CLabel((Composite)this, 0);
        lblHeader.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblHeader.setText("Favoriten");
        lblHeader.setImage(Images.IMG_STAR.getImage(ImageSize._75x66_TitleDialogIconSize));
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tcl_composite = new TableColumnLayout();
        composite.setLayout((Layout)tcl_composite);
        this.tv = new TableViewer(composite, 67584);
        final Table table = this.tv.getTable();
        table.setHeaderVisible(true);
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                int clientWidth = table.getClientArea().width;
                event.height = event.gc.getFontMetrics().getHeight() * 2 + 2;
                event.width = clientWidth * 2;
            }
        });
        table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                VerrechenbarFavorites.Favorite fav = (VerrechenbarFavorites.Favorite)item.getData();
                Optional cfs = fav.getObject();
                String simpleName = "?";
                String label = "?";
                if (cfs.isPresent()) {
                    simpleName = ((Identifiable)cfs.get()).getClass().getSimpleName();
                    label = ((Identifiable)cfs.get()).getLabel();
                }
                int yOffset = 0;
                if (FavoritenComposite.this.defaultFont == null && FavoritenComposite.this.boldFont == null) {
                    FavoritenComposite.this.defaultFont = event.gc.getFont();
                    FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)FavoritenComposite.this.defaultFont).setStyle(1);
                    FavoritenComposite.this.boldFont = boldDescriptor.createFont((Device)event.display);
                }
                switch (event.index) {
                    case 0: {
                        event.gc.setFont(FavoritenComposite.this.defaultFont);
                        event.gc.drawText(fav.getMacroString() != null ? fav.getMacroString() : "", event.x + 3, event.y + yOffset, true);
                        break;
                    }
                    case 1: {
                        event.gc.setFont(FavoritenComposite.this.boldFont);
                        event.gc.drawText(simpleName, event.x + 3, event.y + yOffset, true);
                        event.gc.setFont(FavoritenComposite.this.defaultFont);
                        event.gc.drawText(label, event.x + 3, event.y + event.gc.getFontMetrics().getHeight(), true);
                        break;
                    }
                }
            }
        });
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                VerrechenbarFavorites.Favorite fav;
                Optional po;
                StructuredSelection ss;
                ICodeSelectorTarget target = CodeSelectorHandler.getInstance().getCodeSelectorTarget();
                if (target != null && !(ss = (StructuredSelection)FavoritenComposite.this.tv.getSelection()).isEmpty() && (po = (fav = (VerrechenbarFavorites.Favorite)ss.getFirstElement()).getObject()).isPresent()) {
                    target.codeSelected(po.get());
                }
            }
        });
        TableViewerColumn tvcMacro = new TableViewerColumn(this.tv, 0);
        TableColumn tblclmnMakro = tvcMacro.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnMakro, (ColumnLayoutData)new ColumnPixelData(50, true, true));
        tblclmnMakro.setText("Makro");
        tvcMacro.setEditingSupport(new EditingSupport(tvcMacro.getViewer(), table){
            TextCellEditor editor;
            {
                this.editor = new TextCellEditor((Composite)table);
            }

            protected void setValue(Object element, Object value) {
                VerrechenbarFavorites.Favorite fav = (VerrechenbarFavorites.Favorite)element;
                fav.setMacroString((String)value);
                VerrechenbarFavorites.storeFavorites();
            }

            protected Object getValue(Object element) {
                VerrechenbarFavorites.Favorite fav = (VerrechenbarFavorites.Favorite)element;
                return fav.getMacroString();
            }

            protected CellEditor getCellEditor(Object element) {
                return this.editor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        TableViewerColumn tvcElement = new TableViewerColumn(this.tv, 0);
        TableColumn tblclmnNewColumn = tvcElement.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnNewColumn, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        tblclmnNewColumn.setText("Element");
        MenuManager mgr = new MenuManager();
        mgr.add((IAction)new Action(){
            {
                this.setText(Messages.ToggleVerrechenbarFavoriteAction_DeFavorize);
            }

            public void run() {
                StructuredSelection selection = (StructuredSelection)FavoritenComposite.this.tv.getSelection();
                VerrechenbarFavorites.Favorite fav = (VerrechenbarFavorites.Favorite)selection.getFirstElement();
                fav.getObject().ifPresent(obj -> VerrechenbarFavorites.setFavorite((Object)obj, (boolean)false));
                FavoritenComposite.this.tv.refresh();
            }
        });
        Menu menu = mgr.createContextMenu(this.tv.getControl());
        table.setMenu(menu);
        DragSource mine = new DragSource(this.tv.getControl(), 1);
        mine.setTransfer(this.types);
        mine.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                StructuredSelection ss = (StructuredSelection)FavoritenComposite.this.tv.getSelection();
                if (ss.isEmpty()) {
                    event.data = null;
                } else {
                    VerrechenbarFavorites.Favorite fav = (VerrechenbarFavorites.Favorite)ss.getFirstElement();
                    Optional favObj = fav.getObject();
                    if (favObj.isPresent()) {
                        event.data = StoreToStringServiceHolder.getStoreToString(favObj.get());
                    }
                }
            }

            public void dragStart(DragSourceEvent event) {
            }
        });
        this.tv.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tv.setLabelProvider((IBaseLabelProvider)new ColorizedLabelProvider());
        this.tv.setInput((Object)VerrechenbarFavorites.getFavorites());
        CoreUiUtil.injectServicesWithContext((Object)((Object)this));
    }

    public void dispose() {
        if (this.defaultFont != null) {
            this.defaultFont.dispose();
        }
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
    }

    protected void checkSubclass() {
    }

    public void update() {
        if (this.tv != null && this.tv.getControl() != null && !this.tv.getControl().isDisposed()) {
            this.tv.setInput((Object)VerrechenbarFavorites.getFavorites());
        }
    }

    private class ColorizedLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ColorizedLabelProvider() {
        }

        public String getText(Object element) {
            return "";
        }

        public Color getBackground(Object element) {
            VerrechenbarFavorites.Favorite fav = (VerrechenbarFavorites.Favorite)element;
            Optional v = fav.getObject();
            if (!v.isPresent()) {
                return null;
            }
            String codeSystemName = ((ICodeElement)v.get()).getCodeSystemName();
            if (codeSystemName == null) {
                return null;
            }
            String rgbColor = ConfigServiceHolder.getGlobal((String)("billing/color/" + codeSystemName), (String)"ffffff");
            return UiDesk.getColorFromRGB(rgbColor);
        }

        public Color getForeground(Object element) {
            return null;
        }
    }
}

