/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.services.internal;

import ch.elexis.core.events.MessageEvent;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.ICoverageService;
import ch.elexis.core.services.IEncounterService;
import ch.elexis.core.services.IUserService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.services.internal.Context;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.util.Optional;
import java.util.Set;

public class TypedModifier {
    private IUserService userService;
    private IEncounterService encounterService;
    private ICoverageService coverageService;
    private Context context;

    public TypedModifier(Context context) {
        this.context = context;
    }

    public void modifyFor(Object object) {
        Optional latestEncounter;
        if (object instanceof IPatient) {
            latestEncounter = this.getEncounterService().getLatestEncounter((IPatient)object);
            if (latestEncounter.isPresent()) {
                this.context.setTyped(latestEncounter.get(), true);
                this.context.setTyped(((IEncounter)latestEncounter.get()).getCoverage(), true);
            } else {
                this.context.removeTyped(IEncounter.class);
                this.context.removeTyped(ICoverage.class);
            }
        }
        if (object instanceof ICoverage) {
            latestEncounter = this.getCoverageService().getLatestEncounter((ICoverage)object);
            if (latestEncounter.isPresent()) {
                this.context.setTyped(latestEncounter.get(), true);
            } else {
                this.context.removeTyped(IEncounter.class);
            }
        }
        if (object instanceof IEncounter) {
            this.context.setTyped(((IEncounter)object).getCoverage(), true);
        }
        if (object instanceof IUser) {
            IUser user = (IUser)object;
            IContact userContact = ((IUser)object).getAssignedContact();
            this.context.setNamed("ch.elexis.core.services.icontext.active.usercontact", userContact);
            Optional defaultWorkingFor = this.getUserService().getDefaultExecutiveDoctorWorkingFor(user);
            if (defaultWorkingFor.isPresent()) {
                ContextServiceHolder.get().setActiveMandator((IMandator)defaultWorkingFor.get());
            } else {
                Set workingFor = this.getUserService().getExecutiveDoctorsWorkingFor(user);
                if (!workingFor.isEmpty()) {
                    ContextServiceHolder.get().setActiveMandator((IMandator)workingFor.iterator().next());
                } else {
                    MessageEvent.fireError((String)"Kein Mandant definiert", (String)"Sie k\u00f6nnen Elexis erst normal benutzen, wenn Sie f\u00fcr den Benutzer einen Mandanten definiert haben");
                }
            }
        }
    }

    public void modifyRemove(Class<?> clazz) {
        if (clazz.equals(IUser.class)) {
            ContextServiceHolder.get().setActivePatient(null);
            ContextServiceHolder.get().setActiveMandator(null);
        }
    }

    private IUserService getUserService() {
        if (this.userService == null) {
            this.userService = (IUserService)OsgiServiceUtil.getService(IUserService.class).get();
        }
        return this.userService;
    }

    private IEncounterService getEncounterService() {
        if (this.encounterService == null) {
            this.encounterService = (IEncounterService)OsgiServiceUtil.getService(IEncounterService.class).get();
        }
        return this.encounterService;
    }

    private ICoverageService getCoverageService() {
        if (this.coverageService == null) {
            this.coverageService = (ICoverageService)OsgiServiceUtil.getService(ICoverageService.class).get();
        }
        return this.coverageService;
    }
}

