/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.services.internal;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.services.IContext;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.dialogs.SelectFallNoObligationDialog;
import ch.elexis.core.ui.services.internal.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"event.topics=org/eclipse/e4/ui/LifeCycle/appStartupComplete"})
public class ContextService
implements IContextService,
EventHandler {
    private static Logger logger = LoggerFactory.getLogger(ContextService.class);
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    private Context root;
    private ConcurrentHashMap<String, Context> contexts;
    private IEclipseContext applicationContext;
    @Reference
    private EventAdmin eventAdmin;
    private Consumer<RunAndTrack> runAndTrackConsumer;
    private List<RunAndTrack> delayedRunAndTrack = new ArrayList<RunAndTrack>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDelayedRunAndTrack() {
        List<RunAndTrack> list = this.delayedRunAndTrack;
        synchronized (list) {
            this.delayedRunAndTrack.forEach(rt -> this.runAndTrackConsumer.accept((RunAndTrack)rt));
        }
    }

    @Activate
    public void activate() {
        logger.info("ACTIVATE");
        this.root = new Context(this);
        this.contexts = new ConcurrentHashMap();
        this.getRootContext().setNamed("ch.elexis.core.services.icontext.stationidentifier", CoreHub.getStationIdentifier());
        this.registerCoreUiFunctions();
    }

    private void registerCoreUiFunctions() {
        this.getRootContext().setNamed("SelectFallNoObligationDialog", (Object)new Supplier<ICoverage>(){
            private ICoverage ret;

            @Override
            public synchronized ICoverage get() {
                this.ret = null;
                Optional coverage = ContextServiceHolder.get().getNamed("SelectFallNoObligationDialog.coverage");
                Optional billable = ContextServiceHolder.get().getNamed("SelectFallNoObligationDialog.billable");
                if (coverage.isPresent() && billable.isPresent()) {
                    Display.getDefault().syncExec(() -> {
                        SelectFallNoObligationDialog dlg = new SelectFallNoObligationDialog((ICoverage)coverage.get(), (IBillable)billable.get());
                        if (dlg.open() == 0) {
                            this.ret = dlg.getCoverage();
                        }
                    });
                } else {
                    logger.warn("SelectFallNoObligationDialog missing context parameter [" + coverage + "] [" + billable + "]");
                }
                return this.ret;
            }
        });
        this.runAndTrackConsumer = new Consumer<RunAndTrack>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(RunAndTrack runAndTrack) {
                List<RunAndTrack> list = ContextService.this.delayedRunAndTrack;
                synchronized (list) {
                    if (ContextService.this.applicationContext != null) {
                        ContextService.this.applicationContext.runAndTrack(runAndTrack);
                    } else {
                        ContextService.this.delayedRunAndTrack.add(runAndTrack);
                    }
                }
            }
        };
        this.getRootContext().setNamed("AddRunAndTrackToE4Context", this.runAndTrackConsumer);
    }

    @Deactivate
    public void deactivate() {
        logger.info("DEACTIVATE");
    }

    public void handleEvent(Event event) {
        Object property = event.getProperty("org.eclipse.e4.data");
        if (property instanceof MApplication) {
            logger.info("APPLICATION STARTUP COMPLETE " + property);
            MApplication application = (MApplication)property;
            this.applicationContext = application.getContext();
            if (this.getRootContext() != null) {
                logger.info("SET APPLICATION CONTEXT " + this.applicationContext);
                ((Context)this.getRootContext()).setEclipseContext(this.applicationContext);
            }
            this.addDelayedRunAndTrack();
        }
    }

    public IContext getRootContext() {
        return this.root;
    }

    public Optional<IContext> getNamedContext(String name) {
        return Optional.ofNullable((IContext)this.contexts.get(name));
    }

    public IContext createNamedContext(String name) {
        Context context = new Context(this.root, name, this);
        this.contexts.put(name, context);
        return context;
    }

    public void releaseContext(String name) {
        Context context = this.contexts.get(name);
        if (context != null) {
            context.setParent(null);
            this.contexts.remove(name);
        }
    }

    private void postEvent(String topic, Object object, Map<String, Object> additionalProperties, boolean synchronous) {
        if (this.eventAdmin != null) {
            HashMap<String, Object> properites = new HashMap<String, Object>();
            properites.put("org.eclipse.e4.data", object);
            if (additionalProperties != null) {
                properites.putAll(additionalProperties);
            }
            Event event = new Event(topic, properites);
            if (synchronous) {
                this.eventAdmin.sendEvent(event);
            } else {
                this.eventAdmin.postEvent(event);
            }
        } else {
            throw new IllegalStateException("No EventAdmin available");
        }
    }

    public void postEvent(String topic, Object object, Map<String, Object> additionalProperties) {
        this.postEvent(topic, object, additionalProperties, false);
    }

    public void sendEvent(String topic, Object object, Map<String, Object> additionalProperties) {
        this.postEvent(topic, object, additionalProperties, true);
    }

    public <T> T submitContextInheriting(Callable<T> callable) {
        try {
            return (T)((ForkJoinTask)ForkJoinPool.commonPool().submit((Callable)callable)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LoggerFactory.getLogger(this.getClass()).error("", (Throwable)e);
            return null;
        }
    }
}

