/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.IUserGroup;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IUserGroupBuilder;
import ch.elexis.core.services.IElexisServerService;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.ElexisServerServiceHolder;
import ch.elexis.core.services.holder.UserServiceHolder;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.IUnlockable;
import ch.elexis.core.ui.locks.LockedRestrictedAction;
import ch.elexis.core.ui.preferences.Messages;
import ch.elexis.core.ui.preferences.inputs.PrefAccessDenied;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wb.swt.SWTResourceManager;

public class UserGroupsManagementPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IUnlockable {
    private TableViewer tableViewerUserGroups;
    private WritableValue<IUserGroup> wvUserGroup = new WritableValue(null, IUserGroup.class);
    private CheckboxTableViewer checkboxTableViewerUsers;
    private CheckboxTableViewer checkboxTableViewerAssociation;
    private CheckboxTableViewer checkboxTableViewerRoles;
    private RestrictedAction addUserGroupAction;
    private RestrictedAction deleteUserGroupAction;
    private RestrictedAction lockUserGroupAction;
    private Label userInfoLabel;

    public UserGroupsManagementPreferencePage() {
        this.setTitle("Benutzerverwaltung");
        this.noDefaultAndApplyButton();
    }

    public Control createContents(Composite parent) {
        if (!AccessControlServiceHolder.get().evaluate(EvACE.of(IUserGroup.class, (Right)Right.CREATE).and(Right.UPDATE).and(Right.DELETE))) {
            return new PrefAccessDenied(parent);
        }
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        MenuManager popManager = new MenuManager();
        this.addUserGroupAction = new RestrictedAction((EvaluatableACE)EvACE.of(IUserGroup.class, (Right)Right.CREATE), Messages.Core_Add_ellipsis){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
            }

            @Override
            public void doRun() {
                IInputValidator iiv = new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.length() < 3) {
                            return "Mindestens 3 Zeichen";
                        }
                        boolean allLettersOrDigits = newText.chars().allMatch(x -> Character.isLetterOrDigit(x));
                        if (!allLettersOrDigits) {
                            return "Nur Buchstaben und Zahlen erlaubt";
                        }
                        boolean isFree = UserServiceHolder.get().verifyGroupnameNotTaken(newText);
                        if (!isFree) {
                            return "Gruppennamen vergeben";
                        }
                        return null;
                    }
                };
                InputDialog id = new InputDialog(Hub.getActiveShell(), "Gruppennamen festlegen", "Gruppennamen festlegen - dieser kann nicht mehr ge\u00e4ndert, sowie zuk\u00fcnftig anderweitig verwendet werden.", null, iiv);
                int retVal = id.open();
                if (retVal == 0) {
                    IUserGroup newUser = (IUserGroup)new IUserGroupBuilder(CoreModelServiceHolder.get(), id.getValue()).buildAndSave();
                    UserGroupsManagementPreferencePage.this.updateUserGroupList();
                    UserGroupsManagementPreferencePage.this.tableViewerUserGroups.setSelection((ISelection)new StructuredSelection((Object)newUser));
                }
            }
        };
        popManager.add((IAction)this.addUserGroupAction);
        this.deleteUserGroupAction = new LockedRestrictedAction<IUserGroup>((EvaluatableACE)EvACE.of(IUserGroup.class, (Right)Right.REMOVE), Messages.Core_Delete){

            @Override
            public IUserGroup getTargetedObject() {
                if (UserGroupsManagementPreferencePage.this.tableViewerUserGroups == null) {
                    return null;
                }
                StructuredSelection ss = (StructuredSelection)UserGroupsManagementPreferencePage.this.tableViewerUserGroups.getSelection();
                return ss != null ? (IUserGroup)ss.getFirstElement() : null;
            }

            @Override
            public void doRun(IUserGroup userGroup) {
                CoreModelServiceHolder.get().remove((Identifiable)userGroup);
                UserGroupsManagementPreferencePage.this.updateUserGroupList();
                UserGroupsManagementPreferencePage.this.wvUserGroup.setValue(null);
            }
        };
        popManager.add((IAction)this.deleteUserGroupAction);
        if (IElexisServerService.ConnectionStatus.STANDALONE != ElexisServerServiceHolder.get().getConnectionStatus()) {
            this.lockUserGroupAction = new RestrictedAction((EvaluatableACE)EvACE.of(IUserGroup.class, (Right)Right.UPDATE), Messages.Leistungscodes_editItem){

                @Override
                public void doRun() {
                    StructuredSelection ss = (StructuredSelection)UserGroupsManagementPreferencePage.this.tableViewerUserGroups.getSelection();
                    IUserGroup u = (IUserGroup)ss.getFirstElement();
                    LockResponse acquireLock = LocalLockServiceHolder.get().acquireLock((Object)u);
                    if (acquireLock.isOk()) {
                        UserGroupsManagementPreferencePage.this.setUnlocked(true);
                    }
                }

                public ImageDescriptor getImageDescriptor() {
                    return Images.IMG_LOCK_OPEN.getImageDescriptor();
                }
            };
            popManager.add((IAction)this.lockUserGroupAction);
        }
        popManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                UserGroupsManagementPreferencePage.this.addUserGroupAction.reflectRight();
                UserGroupsManagementPreferencePage.this.deleteUserGroupAction.reflectRight();
                if (UserGroupsManagementPreferencePage.this.lockUserGroupAction != null) {
                    UserGroupsManagementPreferencePage.this.lockUserGroupAction.reflectRight();
                }
            }
        });
        SashForm sash = new SashForm(container, 256);
        sash.setLayout((Layout)new GridLayout(2, false));
        sash.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Composite compositeLeft = new Composite((Composite)sash, 0);
        compositeLeft.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout gl_compositeLeft = new GridLayout(1, false);
        gl_compositeLeft.marginWidth = 0;
        gl_compositeLeft.marginHeight = 0;
        compositeLeft.setLayout((Layout)gl_compositeLeft);
        Composite compositeButtons = new Composite(compositeLeft, 0);
        compositeButtons.setLayout((Layout)new FillLayout(256));
        compositeButtons.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnAdd = new Button(compositeButtons, 0x800000);
        btnAdd.setImage(Images.IMG_NEW.getImage());
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserGroupsManagementPreferencePage.this.addUserGroupAction.doRun();
            }
        });
        if (IElexisServerService.ConnectionStatus.STANDALONE != ElexisServerServiceHolder.get().getConnectionStatus()) {
            final Button btnLock = new Button(compositeButtons, 0x800002);
            btnLock.setSelection(LocalLockServiceHolder.get().isLocked(this.wvUserGroup.getValue()));
            btnLock.setImage(Images.IMG_LOCK_OPEN.getImage());
            btnLock.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IUserGroup userGroup = (IUserGroup)UserGroupsManagementPreferencePage.this.wvUserGroup.getValue();
                    if (LocalLockServiceHolder.get().isLocked((Object)userGroup)) {
                        LocalLockServiceHolder.get().releaseLock((Object)userGroup);
                    } else {
                        UserGroupsManagementPreferencePage.this.lockUserGroupAction.doRun();
                    }
                    boolean locked = LocalLockServiceHolder.get().isLocked(UserGroupsManagementPreferencePage.this.wvUserGroup.getValue());
                    btnLock.setSelection(locked);
                    UserGroupsManagementPreferencePage.this.setUnlocked(locked);
                }
            });
        }
        Composite compositeSelectorTable = new Composite(compositeLeft, 0);
        compositeSelectorTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tcl_compositeSelectorTable = new TableColumnLayout();
        compositeSelectorTable.setLayout((Layout)tcl_compositeSelectorTable);
        Composite compositeEdit = new Composite((Composite)sash, 0);
        GridLayout gl_compositeEdit = new GridLayout(2, false);
        gl_compositeEdit.horizontalSpacing = 0;
        gl_compositeEdit.verticalSpacing = 0;
        gl_compositeEdit.marginWidth = 0;
        gl_compositeEdit.marginHeight = 0;
        compositeEdit.setLayout((Layout)gl_compositeEdit);
        compositeEdit.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.userInfoLabel = new Label(compositeEdit, 0);
        this.userInfoLabel.setFont(SWTResourceManager.getFont(".AppleSystemUIFont", 14, 1));
        this.userInfoLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(compositeEdit, 0);
        this.tableViewerUserGroups = new TableViewer(compositeSelectorTable, 67584);
        this.tableViewerUserGroups.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table tableUserGroups = this.tableViewerUserGroups.getTable();
        tableUserGroups.setLinesVisible(true);
        this.tableViewerUserGroups.addSelectionChangedListener(e -> {
            this.releaseLockIfRequired();
            StructuredSelection ss = (StructuredSelection)e.getSelection();
            this.wvUserGroup.setValue(ss == null ? null : (IUserGroup)ss.getFirstElement());
            this.setUnlocked(IElexisServerService.ConnectionStatus.STANDALONE == ElexisServerServiceHolder.get().getConnectionStatus());
            compositeEdit.layout(true, true);
        });
        TableViewerColumn tableViewerColumnName = new TableViewerColumn(this.tableViewerUserGroups, 0);
        TableColumn tblclmnName = tableViewerColumnName.getColumn();
        tcl_compositeSelectorTable.setColumnData((Widget)tblclmnName, (ColumnLayoutData)new ColumnWeightData(100));
        tableViewerColumnName.setLabelProvider((CellLabelProvider)new UserGroupCellLabelProvider());
        Menu menu = popManager.createContextMenu((Control)tableUserGroups);
        tableUserGroups.setMenu(menu);
        new Label(compositeEdit, 0);
        new Label(compositeEdit, 0);
        Composite compositeAccounting = new Composite(compositeEdit, 0);
        compositeAccounting.setLayout((Layout)new GridLayout(3, true));
        compositeAccounting.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Group grpUsers = new Group(compositeAccounting, 0);
        grpUsers.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpUsers.setText("Benutzer");
        GridLayout gl_grp = new GridLayout(2, false);
        gl_grp.marginHeight = 0;
        grpUsers.setLayout((Layout)gl_grp);
        Composite compositeUsers = new Composite((Composite)grpUsers, 0);
        compositeUsers.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumnLayout tcl_compositeUsers = new TableColumnLayout();
        compositeUsers.setLayout((Layout)tcl_compositeUsers);
        this.checkboxTableViewerUsers = CheckboxTableViewer.newCheckList((Composite)compositeUsers, (int)67584);
        this.checkboxTableViewerUsers.addCheckStateListener(e -> {
            IUser u = (IUser)e.getElement();
            if (u == null) {
                return;
            }
            IUserGroup userGroup = (IUserGroup)this.wvUserGroup.getValue();
            if (e.getChecked()) {
                userGroup.addUser(u);
            } else {
                userGroup.removeUser(u);
            }
            CoreModelServiceHolder.get().save((Identifiable)userGroup);
        });
        this.checkboxTableViewerUsers.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.checkboxTableViewerUsers.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider());
        this.checkboxTableViewerUsers.setComparator((ViewerComparator)new UserViewerComparator());
        Group grpAssociation = new Group(compositeAccounting, 0);
        grpAssociation.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpAssociation.setText("t\u00e4tig f\u00fcr");
        gl_grp = new GridLayout(2, false);
        gl_grp.marginHeight = 0;
        grpAssociation.setLayout((Layout)gl_grp);
        Composite compositeAssociation = new Composite((Composite)grpAssociation, 0);
        compositeAssociation.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumnLayout tcl_compositeAssociation = new TableColumnLayout();
        compositeAssociation.setLayout((Layout)tcl_compositeAssociation);
        this.checkboxTableViewerAssociation = CheckboxTableViewer.newCheckList((Composite)compositeAssociation, (int)67584);
        this.checkboxTableViewerAssociation.addCheckStateListener(e -> {
            IMandator m = (IMandator)e.getElement();
            if (m == null) {
                return;
            }
            IUserGroup userGroup = (IUserGroup)this.wvUserGroup.getValue();
            UserServiceHolder.get().addOrRemoveExecutiveDoctorWorkingFor(userGroup, m, e.getChecked());
        });
        Group grpRoles = new Group(compositeAccounting, 0);
        grpRoles.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpRoles.setText("Rollenzuordnung");
        GridLayout gl_grpRoles = new GridLayout(2, false);
        gl_grpRoles.marginHeight = 0;
        grpRoles.setLayout((Layout)gl_grpRoles);
        Composite compositeRoles = new Composite((Composite)grpRoles, 0);
        compositeRoles.setLayout((Layout)new FillLayout(256));
        compositeRoles.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.checkboxTableViewerRoles = CheckboxTableViewer.newCheckList((Composite)compositeRoles, (int)67584);
        new Label(compositeEdit, 0);
        new Label(compositeEdit, 0);
        this.checkboxTableViewerRoles.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.checkboxTableViewerRoles.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                IRole r = (IRole)element;
                return r.getId();
            }
        });
        this.checkboxTableViewerRoles.addCheckStateListener(e -> {
            IRole r = (IRole)e.getElement();
            if (r == null) {
                return;
            }
            IUserGroup userGroup = (IUserGroup)this.wvUserGroup.getValue();
            if (e.getChecked()) {
                userGroup.addRole(r);
            } else {
                userGroup.removeRole(r);
            }
            CoreModelServiceHolder.get().save((Identifiable)userGroup);
        });
        this.checkboxTableViewerAssociation.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.checkboxTableViewerAssociation.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                IUserGroup userGroup = (IUserGroup)UserGroupsManagementPreferencePage.this.wvUserGroup.getValue();
                IMandator m = (IMandator)element;
                StringBuilder sb = new StringBuilder();
                sb.append(String.valueOf(m.getDescription1()) + " " + m.getDescription2());
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{m.getDescription3()})) {
                    sb.append(" (").append(m.getDescription3()).append(")");
                }
                return sb.toString();
            }
        });
        this.checkboxTableViewerAssociation.setComparator((ViewerComparator)new MandantViewerComparator());
        this.updateUsers();
        this.updateRoles();
        this.updateAssociations();
        this.wvUserGroup.addValueChangeListener((IValueChangeListener)new ValueChangedAdapter());
        this.updateUserGroupList();
        this.setUnlocked(IElexisServerService.ConnectionStatus.STANDALONE == ElexisServerServiceHolder.get().getConnectionStatus());
        sash.setWeights(new int[]{1, 5});
        return container;
    }

    public void init(IWorkbench workbench) {
    }

    private void updateUserGroupList() {
        List users = CoreModelServiceHolder.get().getQuery(IUserGroup.class).execute();
        users.sort((u1, u2) -> u1.getLabel().compareTo(u2.getLabel()));
        this.tableViewerUserGroups.setInput((Object)users);
    }

    private void updateUsers() {
        List users = CoreModelServiceHolder.get().getQuery(IUser.class).execute();
        this.checkboxTableViewerUsers.setInput((Object)users);
    }

    private void updateRoles() {
        List roles = CoreModelServiceHolder.get().getQuery(IRole.class).execute();
        this.checkboxTableViewerRoles.setInput((Object)roles);
    }

    private void updateAssociations() {
        this.checkboxTableViewerAssociation.setInput((Object)CoreModelServiceHolder.get().getQuery(IMandator.class).execute());
        this.checkboxTableViewerAssociation.setCheckedElements((Object[])new IMandator[0]);
    }

    protected void performApply() {
        this.releaseLockIfRequired();
        super.performApply();
    }

    public boolean performOk() {
        this.releaseLockIfRequired();
        return super.performOk();
    }

    public boolean performCancel() {
        this.releaseLockIfRequired();
        return super.performCancel();
    }

    private void releaseLockIfRequired() {
        IUserGroup userGroup = (IUserGroup)this.wvUserGroup.getValue();
        if (userGroup != null && LocalLockServiceHolder.get().isLocked((Object)userGroup)) {
            LocalLockServiceHolder.get().releaseLock((Object)userGroup);
        }
    }

    @Override
    public void setUnlocked(boolean unlocked) {
        this.checkboxTableViewerUsers.getTable().setEnabled(unlocked);
        this.checkboxTableViewerAssociation.getTable().setEnabled(unlocked);
        this.checkboxTableViewerRoles.getTable().setEnabled(unlocked);
    }

    public class MandantViewerComparator
    extends ViewerComparator {
        public int compare(Viewer viewer, Object o1, Object o2) {
            IMandator m1 = (IMandator)o1;
            IMandator m2 = (IMandator)o2;
            return m1.getDescription1().compareToIgnoreCase(m2.getDescription1());
        }
    }

    private class UserGroupCellLabelProvider
    extends CellLabelProvider {
        private UserGroupCellLabelProvider() {
        }

        public void update(ViewerCell cell) {
            IUserGroup userGroup = (IUserGroup)cell.getElement();
            cell.setText(userGroup.getLabel());
        }
    }

    public class UserViewerComparator
    extends ViewerComparator {
        public int compare(Viewer viewer, Object o1, Object o2) {
            IUser u1 = (IUser)o1;
            IUser u2 = (IUser)o2;
            return u1.getId().compareToIgnoreCase(u2.getId());
        }
    }

    private class ValueChangedAdapter
    implements IValueChangeListener<IUserGroup> {
        private ValueChangedAdapter() {
        }

        public void handleValueChange(ValueChangeEvent event) {
            IUserGroup userGroup = (IUserGroup)UserGroupsManagementPreferencePage.this.wvUserGroup.getValue();
            UserGroupsManagementPreferencePage.this.setErrorMessage(null);
            UserGroupsManagementPreferencePage.this.updateUsers();
            Object[] assignedUsers = userGroup != null ? userGroup.getUsers().toArray() : new Object[]{};
            UserGroupsManagementPreferencePage.this.checkboxTableViewerUsers.setCheckedElements(assignedUsers);
            UserGroupsManagementPreferencePage.this.updateRoles();
            Object[] assignedRoles = userGroup != null ? userGroup.getRoles().toArray() : new Object[]{};
            UserGroupsManagementPreferencePage.this.checkboxTableViewerRoles.setCheckedElements(assignedRoles);
            UserGroupsManagementPreferencePage.this.updateAssociations();
            UserGroupsManagementPreferencePage.this.checkboxTableViewerAssociation.setCheckedElements(UserServiceHolder.get().getExecutiveDoctorsWorkingFor(userGroup, true).toArray());
        }
    }
}

