/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange.elements;

import ch.elexis.core.data.interfaces.ILabItem;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.exchange.XChangeExporter;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.core.ui.exchange.elements.XidElement;
import ch.elexis.data.LabItem;

public class FindingElement
extends XChangeElement {
    public static final String ENCLOSING = "findings";
    public static final String XMLNAME = "finding";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_NORMRANGE = "normRange";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_UNITS = "unit";
    public static final String ATTR_GROUP = "group";
    public static final String ELEMENT_XID = "xid";
    public static final String XIDBASE = "www.xid.ch/labitems/";
    public static final String TYPE_NUMERIC = "numeric";
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_IMAGE = "image";
    public static final String TYPE_ABSOLUTE = "absolute";

    @Override
    public String getXMLName() {
        return XMLNAME;
    }

    FindingElement asExporter(XChangeExporter home, LabItem li) {
        this.asExporter(home);
        this.setAttribute(ATTR_NAME, li.getKuerzel());
        if (li.getTyp().equals((Object)LabItemTyp.NUMERIC)) {
            this.setAttribute(ATTR_TYPE, TYPE_NUMERIC);
            this.setAttribute(ATTR_NORMRANGE, li.getRefM());
            this.setAttribute(ATTR_UNITS, li.getEinheit());
        } else if (li.getTyp().equals((Object)LabItemTyp.ABSOLUTE)) {
            this.setAttribute(ATTR_TYPE, TYPE_ABSOLUTE);
        } else if (li.getTyp().equals((Object)LabItemTyp.TEXT)) {
            this.setAttribute(ATTR_TYPE, TYPE_TEXT);
        }
        this.setAttribute(ATTR_GROUP, li.getGroup());
        XidElement eXid = new XidElement().asExporter(home, (ILabItem)li);
        this.add(eXid);
        return this;
    }
}

