/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.data.service.StockServiceHolder;
import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.e4.providers.IdentifiableLabelProvider;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class DailyOrderDialog
extends TitleAreaDialog {
    private CDateTime dtDate;
    private TableViewer tableViewer;
    private IOrder currOrder;
    private TimeTool selectedDate;
    private List<IMandator> limitationList = new ArrayList<IMandator>();

    public DailyOrderDialog(Shell parentShell, IOrder currOrder) {
        super(parentShell);
        this.currOrder = currOrder;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.DailyOrderDialog_Title);
        this.setMessage(Messages.DailyOrderDialog_Message);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        area.setLayout((Layout)new GridLayout(1, false));
        Composite dateComposite = new Composite(area, 0);
        dateComposite.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        dateComposite.setLayout((Layout)new GridLayout(2, false));
        this.dtDate = new CDateTime(dateComposite, 0x200802);
        this.dtDate.setSelection(new Date());
        this.dtDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DailyOrderDialog.this.modifyArticlesUsedOn(DailyOrderDialog.this.selectedDate, false);
                DailyOrderDialog.this.selectedDate = new TimeTool(DailyOrderDialog.this.dtDate.getSelection());
                DailyOrderDialog.this.modifyArticlesUsedOn(DailyOrderDialog.this.selectedDate, true);
                DailyOrderDialog.this.tableViewer.setInput((Object)DailyOrderDialog.this.currOrder.getEntries());
            }
        });
        this.selectedDate = new TimeTool(this.dtDate.getSelection());
        final Button btnFilterMandators = new Button(dateComposite, 32);
        btnFilterMandators.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        btnFilterMandators.setText("nur von folgenden Mandanten ...");
        btnFilterMandators.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DailyOrderDialog.this.limitationList.clear();
                btnFilterMandators.setText("nur von folgenden Mandanten ...");
                if (btnFilterMandators.getSelection()) {
                    ListSelectionDialog lsd = new ListSelectionDialog(Display.getDefault().getActiveShell(), (Object)CoreModelServiceHolder.get().getQuery(IMandator.class).execute(), (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)IdentifiableLabelProvider.getInstance(), Messages.DailyOrderMandant);
                    int open = lsd.open();
                    if (open == 0) {
                        DailyOrderDialog.this.modifyArticlesUsedOn(DailyOrderDialog.this.selectedDate, false);
                        DailyOrderDialog.this.limitationList.addAll(Arrays.asList(lsd.getResult()).stream().map(m -> (IMandator)m).collect(Collectors.toList()));
                        String label = String.valueOf(Messages.DailyOrderMandantOnlyFollowing) + DailyOrderDialog.this.limitationList.stream().map(m -> m.getLabel()).reduce((u, t) -> String.valueOf(u) + ", " + t).orElse(Messages.DailyOrderMandantNone);
                        btnFilterMandators.setText(label);
                        DailyOrderDialog.this.modifyArticlesUsedOn(DailyOrderDialog.this.selectedDate, true);
                        DailyOrderDialog.this.tableViewer.setInput((Object)DailyOrderDialog.this.currOrder.getEntries());
                    } else {
                        btnFilterMandators.setSelection(false);
                    }
                }
            }
        });
        Composite tableComposite = new Composite(area, 0);
        tableComposite.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        TableColumnLayout tcLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tcLayout);
        this.tableViewer = new TableViewer(tableComposite, 67584);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewerColumn tvc = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tcAmount = tvc.getColumn();
        tcLayout.setColumnData((Widget)tcAmount, (ColumnLayoutData)new ColumnPixelData(70, false, false));
        tcAmount.setText(Messages.Core_Number);
        tvc = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tcArticle = tvc.getColumn();
        tcLayout.setColumnData((Widget)tcArticle, (ColumnLayoutData)new ColumnPixelData(300, true, true));
        tcArticle.setText(Messages.Core_Article);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new OrderLabelProvider());
        this.modifyArticlesUsedOn(this.selectedDate, true);
        this.tableViewer.setInput((Object)this.currOrder.getEntries());
        return area;
    }

    private void modifyArticlesUsedOn(TimeTool priorDate, boolean add) {
        IQuery query = CoreModelServiceHolder.get().getQuery(IEncounter.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__DATE, IQuery.COMPARATOR.EQUALS, (Object)priorDate.toLocalDate());
        if (!this.limitationList.isEmpty()) {
            query.startGroup();
            this.limitationList.stream().forEach(m -> query.or((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__MANDATOR, IQuery.COMPARATOR.EQUALS, m));
            query.andJoinGroups();
        }
        List dayEncounters = query.execute();
        for (IEncounter encounter : dayEncounters) {
            List encounterBilled = encounter.getBilled();
            for (IBilled billed : encounterBilled) {
                IOrderEntry orderEntry;
                IBillable billable = billed.getBillable();
                if (!(billable instanceof IArticle)) continue;
                IArticle art = (IArticle)billable;
                Optional mandator = ContextServiceHolder.get().getActiveMandator();
                IStockEntry stockEntry = StockServiceHolder.get().findPreferredStockEntryForArticle(StoreToStringServiceHolder.getStoreToString((Object)art), mandator.isPresent() ? ((IMandator)mandator.get()).getId() : null);
                int amount = (int)billed.getAmount();
                if (!add) {
                    amount *= -1;
                }
                if (stockEntry != null) {
                    orderEntry = this.currOrder.addEntry(stockEntry.getArticle(), stockEntry.getStock(), stockEntry.getProvider(), amount);
                    if (orderEntry.getAmount() == 0) {
                        CoreModelServiceHolder.get().remove((Identifiable)orderEntry);
                        CoreModelServiceHolder.get().refresh((Identifiable)this.currOrder, true);
                        continue;
                    }
                    CoreModelServiceHolder.get().save((Identifiable)orderEntry);
                    continue;
                }
                orderEntry = this.currOrder.addEntry(art, null, null, amount);
                if (orderEntry.getAmount() == 0) {
                    CoreModelServiceHolder.get().remove((Identifiable)orderEntry);
                    CoreModelServiceHolder.get().refresh((Identifiable)this.currOrder, true);
                    continue;
                }
                CoreModelServiceHolder.get().save((Identifiable)orderEntry);
            }
        }
    }

    public IOrder getOrder() {
        return this.currOrder;
    }

    protected void cancelPressed() {
        this.modifyArticlesUsedOn(this.selectedDate, false);
        super.cancelPressed();
    }

    class OrderContentProvider
    implements IStructuredContentProvider {
        OrderContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return DailyOrderDialog.this.currOrder.getEntries().toArray(new IOrderEntry[0]);
        }

        public void dispose() {
        }
    }

    class OrderLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        OrderLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IOrderEntry be = (IOrderEntry)element;
            switch (columnIndex) {
                case 0: {
                    return Integer.toString(be.getAmount());
                }
                case 1: {
                    return be.getArticle().getLabel();
                }
            }
            return "?";
        }
    }
}

