/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.services.holder.MedicationServiceHolder;
import ch.elexis.core.ui.views.controls.ArticleDefaultSignatureComposite;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ArticleDefaultSignatureTitleAreaDialog
extends TitleAreaDialog {
    private IArticle article;
    private ArticleDefaultSignatureComposite adsc;
    private IPrescription prescription;

    public ArticleDefaultSignatureTitleAreaDialog(Shell parentShell, IArticle article) {
        super(parentShell);
        this.article = article;
    }

    public ArticleDefaultSignatureTitleAreaDialog(Shell parentShell, IPrescription prescription) {
        super(parentShell);
        this.prescription = prescription;
        this.article = prescription.getArticle();
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage("F\u00fcr diesen ATC Code oder diesen Artikel folgende Standard-Signatur hinterlegen");
        this.setTitle("Standard-Signatur hinterlegen");
        Composite area = (Composite)super.createDialogArea(parent);
        this.adsc = new ArticleDefaultSignatureComposite(area, 0);
        this.adsc.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.adsc.setToolbarVisible(false);
        this.adsc.initDataBindings(null);
        this.adsc.setArticleToBind(this.article, false);
        if (this.prescription != null) {
            List doseAsFloats = MedicationServiceHolder.get().getDosageAsFloats(this.prescription);
            int i = 0;
            while (i < doseAsFloats.size()) {
                String val = this.trimTrailingZeros(Float.toString(((Float)doseAsFloats.get(i)).floatValue()));
                switch (i) {
                    case 0: {
                        this.adsc.setSignatureMorning(val);
                        break;
                    }
                    case 1: {
                        this.adsc.setSignatureNoon(val);
                        break;
                    }
                    case 2: {
                        this.adsc.setSignatureEvening(val);
                        break;
                    }
                    case 3: {
                        this.adsc.setSignatureNight(val);
                        break;
                    }
                }
                ++i;
            }
            this.adsc.setSignatureComment(this.prescription.getDisposalComment());
        }
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.adsc.updateModelNonDatabinding();
        this.adsc.save();
        super.okPressed();
    }

    private String trimTrailingZeros(String number) {
        if (!number.contains(".")) {
            return number;
        }
        return number.replaceAll("\\.?0*$", "");
    }
}

