/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.Artikel;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBillableOptifier;
import ch.elexis.core.model.IBillableVerifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IBillingSystemFactor;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.billable.AbstractOptifier;
import ch.elexis.core.model.billable.DefaultVerifier;
import ch.elexis.core.model.service.holder.CoreModelServiceHolder;
import ch.elexis.core.model.util.ModelUtil;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.types.ArticleSubTyp;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.types.VatInfo;
import ch.rgw.tools.Money;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;

public class TypedArticle
extends AbstractIdDeleteModelAdapter<Artikel>
implements IdentifiableWithXid,
IArticle {
    private static IBillableVerifier verifier;
    private static IBillableOptifier<TypedArticle> optifier;

    public TypedArticle(Artikel entity) {
        super((EntityWithId)entity);
    }

    public String getCodeSystemName() {
        return this.getTyp().getCodeSystemName();
    }

    public String getCodeSystemCode() {
        ArticleTyp typ = this.getTyp();
        if (typ == ArticleTyp.EIGENARTIKEL) {
            ArticleSubTyp subTyp = this.getSubTyp();
            if (subTyp == ArticleSubTyp.COMPLEMENTARY || subTyp == ArticleSubTyp.COMPLEMENTARY_REDUCED) {
                return "590";
            }
            if (subTyp == ArticleSubTyp.ADDITIVE || subTyp == ArticleSubTyp.COVID) {
                return "406";
            }
            if (subTyp == ArticleSubTyp.PHARMA) {
                return "402";
            }
            if (subTyp == ArticleSubTyp.NONPHARMA) {
                return "406";
            }
            if (subTyp == ArticleSubTyp.MAGISTERY) {
                return "410";
            }
            if (subTyp == ArticleSubTyp.MIGEL) {
                return "452";
            }
        } else if (typ == ArticleTyp.MIGEL) {
            return "452";
        }
        return super.getCodeSystemCode();
    }

    public String getCode() {
        String ret = ((Artikel)this.getEntity()).getSubId();
        if (ret == null || ret.isEmpty()) {
            ret = this.getId();
        }
        return ret;
    }

    public void setCode(String code) {
        ((Artikel)this.getEntityMarkDirty()).setSubId(code);
    }

    public String getText() {
        String name = ((Artikel)this.getEntity()).getName();
        if (!this.isProduct()) {
            StringBuilder label = new StringBuilder();
            String packageSizeString = this.getPackageSizeString();
            if (StringUtils.isNotBlank((CharSequence)packageSizeString)) {
                label.append(String.valueOf(packageSizeString) + " ");
            } else {
                label.append(String.valueOf(this.getPackageSize()) + " " + (this.getPackageUnit() != null ? this.getPackageUnit() : ""));
            }
            return String.valueOf(name) + " " + label.toString();
        }
        return name;
    }

    public void setText(String value) {
        ((Artikel)this.getEntityMarkDirty()).setName(value);
    }

    public String getGtin() {
        return ((Artikel)this.getEntity()).getEan();
    }

    public void setGtin(String value) {
        ((Artikel)this.getEntityMarkDirty()).setEan(value);
    }

    public String getName() {
        return ((Artikel)this.getEntity()).getName();
    }

    public void setName(String value) {
        ((Artikel)this.getEntityMarkDirty()).setName(value);
    }

    public int getSellingSize() {
        String unit = (String)this.getExtInfo("Verkaufseinheit");
        if (unit != null) {
            try {
                return Integer.parseInt(unit);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    public void setSellingSize(int value) {
        this.setExtInfo("Verkaufseinheit", Integer.toString(value));
    }

    public int getPackageSize() {
        String size = (String)this.getExtInfo("Verpackungseinheit");
        if (size == null && this.getTyp() == ArticleTyp.EIGENARTIKEL) {
            size = (String)this.getExtInfo("packageSizeString");
        }
        if (size != null) {
            try {
                return Integer.parseInt(size);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    public void setPackageSize(int value) {
        this.setExtInfo("Verpackungseinheit", Integer.toString(value));
    }

    public String getPackageUnit() {
        if (this.isTyp(ArticleTyp.EIGENARTIKEL)) {
            return (String)this.getExtInfo("measurementUnit");
        }
        if (this.isTyp(ArticleTyp.MIGEL)) {
            return (String)this.getExtInfo("unit");
        }
        return "";
    }

    public void setPackageUnit(String value) {
        if (this.isTyp(ArticleTyp.EIGENARTIKEL)) {
            this.setExtInfo("measurementUnit", value);
        } else if (this.isTyp(ArticleTyp.MIGEL)) {
            this.setExtInfo("unit", value);
        }
    }

    public void setPackageSizeString(String value) {
        this.setExtInfo("packageSizeString", value);
    }

    public String getPackageSizeString() {
        return StringUtils.defaultString((String)((String)this.getExtInfo("packageSizeString")));
    }

    public boolean isProduct() {
        if (this.isTyp(ArticleTyp.EIGENARTIKEL)) {
            return ((Artikel)this.getEntity()).getProduct() == null;
        }
        return false;
    }

    public ArticleTyp getTyp() {
        return ((Artikel)this.getEntity()).getTyp() != null ? ((Artikel)this.getEntity()).getTyp() : ArticleTyp.ARTIKEL;
    }

    public void setTyp(ArticleTyp value) {
        ((Artikel)this.getEntityMarkDirty()).setTyp(value);
    }

    public ArticleSubTyp getSubTyp() {
        return ArticleSubTyp.byCharSafe((String)((Artikel)this.getEntity()).getCodeclass());
    }

    public void setSubTyp(ArticleSubTyp value) {
        ((Artikel)this.getEntityMarkDirty()).setCodeclass(Character.toString(value.getTypeChar()));
    }

    public Object getExtInfo(Object key) {
        return this.extInfoHandler.getExtInfo(key);
    }

    public void setExtInfo(Object key, Object value) {
        this.extInfoHandler.setExtInfo(key, value);
    }

    public Map<Object, Object> getMap() {
        return this.extInfoHandler.getMap();
    }

    public VatInfo getVatInfo() {
        if (this.isTyp(ArticleTyp.EIGENARTIKEL)) {
            ArticleSubTyp subTyp = this.getSubTyp();
            switch (subTyp) {
                case PHARMA: 
                case MAGISTERY: 
                case COMPLEMENTARY_REDUCED: {
                    return VatInfo.VAT_CH_ISMEDICAMENT;
                }
                case NONPHARMA: 
                case COMPLEMENTARY: {
                    return VatInfo.VAT_CH_NOTMEDICAMENT;
                }
            }
            return VatInfo.VAT_NONE;
        }
        return VatInfo.VAT_NONE;
    }

    private boolean isTyp(ArticleTyp typ) {
        return this.getTyp() == typ;
    }

    public IArticle getProduct() {
        return ch.elexis.core.model.util.internal.ModelUtil.getAdapter((EntityWithId)((Artikel)this.getEntity()).getProduct(), IArticle.class);
    }

    public void setProduct(IArticle value) {
        if (value != null) {
            ((Artikel)this.getEntityMarkDirty()).setProduct((Artikel)((AbstractIdModelAdapter)value).getEntity());
        } else {
            ((Artikel)this.getEntityMarkDirty()).setProduct(null);
        }
    }

    public String getAtcCode() {
        return ((Artikel)this.getEntity()).getAtcCode();
    }

    public void setAtcCode(String value) {
        ((Artikel)this.getEntityMarkDirty()).setAtcCode(value);
    }

    public List<IArticle> getPackages() {
        IQuery<IArticle> query = ch.elexis.core.model.util.internal.ModelUtil.getQuery(IArticle.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IARTICLE__TYP, IQuery.COMPARATOR.EQUALS, (Object)this.getTyp());
        query.and((EStructuralFeature)ModelPackage.Literals.IARTICLE__PRODUCT, IQuery.COMPARATOR.EQUALS, (Object)this);
        return query.execute();
    }

    public synchronized IBillableOptifier<TypedArticle> getOptifier() {
        if (optifier == null) {
            optifier = new AbstractOptifier<TypedArticle>(CoreModelServiceHolder.get(), ContextServiceHolder.get()){

                protected void setPrice(TypedArticle billable, IBilled billed) {
                    billed.setFactor(1.0);
                    billed.setNetPrice(billable.getPurchasePrice());
                    Money sellingPrice = billable.getSellingPrice();
                    int vkPreis = sellingPrice != null ? sellingPrice.getCents() : 0;
                    double pkgSize = Math.abs(billable.getPackageSize());
                    double vkUnits = billable.getSellingSize();
                    if (pkgSize > 0.0 && vkUnits > 0.0 && pkgSize != vkUnits) {
                        billed.setPoints((int)Math.round(vkUnits * ((double)vkPreis / pkgSize)));
                    } else {
                        billed.setPoints(Math.round(vkPreis));
                    }
                }

                public Optional<IBillingSystemFactor> getFactor(IEncounter encounter) {
                    return Optional.empty();
                }
            };
        }
        return optifier;
    }

    public synchronized IBillableVerifier getVerifier() {
        if (verifier == null) {
            verifier = new DefaultVerifier();
        }
        return verifier;
    }

    public Money getPurchasePrice() {
        String priceString = ((Artikel)this.getEntity()).getEkPreis();
        if (StringUtils.isNumeric((CharSequence)priceString)) {
            return ModelUtil.getMoneyForCentString((String)priceString).orElse(null);
        }
        return new Money();
    }

    public void setPurchasePrice(Money value) {
        ((Artikel)this.getEntityMarkDirty()).setEkPreis(value != null ? value.getCentsAsString() : null);
    }

    public Money getSellingPrice() {
        String priceString = ((Artikel)this.getEntity()).getVkPreis();
        if (StringUtils.isNumeric((CharSequence)priceString)) {
            return ModelUtil.getMoneyForCentString((String)priceString).orElse(null);
        }
        return new Money();
    }

    public void setSellingPrice(Money value) {
        ((Artikel)this.getEntityMarkDirty()).setVkPreis(value != null ? value.getCentsAsString() : null);
    }

    public boolean isObligation() {
        if (this.isTyp(ArticleTyp.EIGENARTIKEL)) {
            return Boolean.valueOf((String)this.getExtInfo("healthInsuranceCostAbsorption"));
        }
        return false;
    }

    public void setObligation(boolean value) {
        if (this.isTyp(ArticleTyp.EIGENARTIKEL)) {
            this.setExtInfo("healthInsuranceCostAbsorption", Boolean.toString(value));
        }
    }

    public String getLabel() {
        return this.getText();
    }

    public boolean isVaccination() {
        String atcCode = this.getAtcCode();
        return atcCode != null && atcCode.toUpperCase().startsWith("J07") && !atcCode.toUpperCase().startsWith("J07AX");
    }
}

