/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.model.adapter;

import ch.elexis.core.ac.ACEAccessBitMapConstraint;
import ch.elexis.core.ac.AoboEntity;
import ch.elexis.core.ac.AoboEntityColumn;
import ch.elexis.core.ac.ObjectEvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractModelAdapterFactory;
import ch.elexis.core.jpa.model.adapter.MappingEntry;
import ch.elexis.core.jpa.model.adapter.internal.PredicateGroupStack;
import ch.elexis.core.jpa.model.adapter.internal.PredicateHandler;
import ch.elexis.core.jpa.model.adapter.internal.QueryCursor;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.services.ISubQuery;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.SingularAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.slf4j.LoggerFactory;

public abstract class AbstractModelQuery<T>
implements IQuery<T> {
    protected Class<T> clazz;
    protected EntityManager entityManager;
    protected CriteriaBuilder criteriaBuilder;
    protected List<Order> orderByList;
    protected CriteriaQuery<?> criteriaQuery;
    protected Root<? extends EntityWithId> rootQuery;
    protected AbstractModelAdapterFactory adapterFactory;
    protected Class<? extends EntityWithId> entityClazz;
    protected boolean includeDeleted;
    protected boolean refreshCache;
    protected int limit;
    protected int offset;
    private PredicateGroupStack predicateGroups;
    private PredicateHandler predicateHandler;
    private IAccessControlService accessControlService;

    public AbstractModelQuery(Class<T> clazz, boolean refreshCache, EntityManager entityManager, boolean includeDeleted) {
        this.clazz = clazz;
        this.entityManager = entityManager;
        this.criteriaBuilder = entityManager.getCriteriaBuilder();
        this.includeDeleted = includeDeleted;
        this.refreshCache = refreshCache;
        this.predicateGroups = new PredicateGroupStack(this.criteriaBuilder);
        this.orderByList = new ArrayList<Order>();
        this.initialize();
        this.predicateHandler = new PredicateHandler(this.predicateGroups, this.entityClazz, this.criteriaBuilder, this.rootQuery);
        if (EntityWithDeleted.class.isAssignableFrom(this.entityClazz) && !includeDeleted) {
            this.and((EStructuralFeature)ModelPackage.Literals.DELETEABLE__DELETED, IQuery.COMPARATOR.NOT_EQUALS, true);
        }
        this.addAobo();
        MappingEntry mappingForInterface = this.adapterFactory.getMappingForInterface(clazz);
        mappingForInterface.applyQueryPrecondition(this);
    }

    private void addAobo() {
        if (this.isAoboClass(this.entityClazz)) {
            Optional<ACEAccessBitMapConstraint> aoboOrSelf = this.isAoboOrSelf(this.entityClazz);
            Field aoboColumn = this.getAoboColumn(this.entityClazz);
            this.startGroup();
            this.or(aoboColumn.getName(), IQuery.COMPARATOR.EQUALS, null);
            if (aoboOrSelf.get() == ACEAccessBitMapConstraint.AOBO) {
                this.or(aoboColumn.getName(), IQuery.COMPARATOR.IN, this.getAoboMandatorIds());
            } else if (aoboOrSelf.get() == ACEAccessBitMapConstraint.SELF) {
                this.or(aoboColumn.getName(), IQuery.COMPARATOR.EQUALS, this.getSelfMandatorId());
            }
            this.andJoinGroups();
        }
    }

    private Field getAoboColumn(Class<? extends EntityWithId> entityClazz) {
        Field[] fieldArray = entityClazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(AoboEntityColumn.class)) {
                return field;
            }
            ++n2;
        }
        throw new IllegalStateException("AOBO entity class [" + entityClazz.getName() + "] has no AOBO column annotation");
    }

    private boolean isAoboClass(Class<? extends EntityWithId> entityClazz) {
        return entityClazz.isAnnotationPresent(AoboEntity.class) && this.isAoboAccessControl(entityClazz);
    }

    private String getSelfMandatorId() {
        if (this.accessControlService == null) {
            this.accessControlService = OsgiServiceUtil.getService(IAccessControlService.class).orElse(null);
        }
        return this.accessControlService != null ? this.accessControlService.getSelfMandatorId() : "-1";
    }

    private List<String> getAoboMandatorIds() {
        if (this.accessControlService == null) {
            this.accessControlService = OsgiServiceUtil.getService(IAccessControlService.class).orElse(null);
        }
        return this.accessControlService != null ? this.accessControlService.getAoboMandatorIds() : Collections.singletonList("-1");
    }

    private boolean isAoboAccessControl(Class<? extends EntityWithId> entityClazz) {
        return this.accessControlService != null ? this.isAoboOrSelf(entityClazz).isPresent() : false;
    }

    private Optional<ACEAccessBitMapConstraint> isAoboOrSelf(Class<? extends EntityWithId> entityClazz) {
        if (this.accessControlService == null) {
            this.accessControlService = OsgiServiceUtil.getService(IAccessControlService.class).orElse(null);
        }
        return this.accessControlService.isAoboOrSelf(new ObjectEvaluatableACE(entityClazz, Right.READ));
    }

    protected abstract void initialize();

    public IQuery<T> and(EStructuralFeature feature, IQuery.COMPARATOR comparator, Object value, boolean ignoreCase) {
        this.predicateHandler.and(feature, comparator, value, ignoreCase);
        return this;
    }

    public IQuery<T> and(String entityAttributeName, IQuery.COMPARATOR comparator, Object value, boolean ignoreCase) {
        this.predicateHandler.and(entityAttributeName, comparator, value, ignoreCase);
        return this;
    }

    public IQuery<T> andFeatureCompare(EStructuralFeature feature, IQuery.COMPARATOR comparator, EStructuralFeature otherFeature) {
        this.predicateHandler.andFeatureCompare(feature, comparator, otherFeature);
        return this;
    }

    public IQuery<T> or(EStructuralFeature feature, IQuery.COMPARATOR comparator, Object value, boolean ignoreCase) {
        this.predicateHandler.or(feature, comparator, value, ignoreCase);
        return this;
    }

    public IQuery<T> or(String entityAttributeName, IQuery.COMPARATOR comparator, Object value, boolean ignoreCase) {
        this.predicateHandler.or(entityAttributeName, comparator, value, ignoreCase);
        return this;
    }

    public IQuery<T> orderBy(EStructuralFeature feature, IQuery.ORDER order) {
        String entityAttributeName = this.predicateHandler.getAttributeName(feature, this.entityClazz);
        Optional<SingularAttribute> attribute = this.predicateHandler.resolveAttribute(this.entityClazz.getName(), entityAttributeName);
        if (!attribute.isPresent()) {
            throw new IllegalStateException("Could not resolve attribute [" + entityAttributeName + "] of entity [" + this.entityClazz + "]");
        }
        this.orderBy(attribute.get(), order);
        return this;
    }

    private void orderBy(SingularAttribute attribute, IQuery.ORDER direction) {
        Order orderBy = null;
        if (direction == IQuery.ORDER.ASC) {
            orderBy = this.criteriaBuilder.asc((Expression)this.rootQuery.get(attribute));
        } else if (direction == IQuery.ORDER.DESC) {
            orderBy = this.criteriaBuilder.desc((Expression)this.rootQuery.get(attribute));
        }
        if (orderBy != null) {
            this.orderByList.add(orderBy);
        }
    }

    public IQuery<T> orderBy(String fieldOrderBy, IQuery.ORDER order) {
        Optional<SingularAttribute> attribute = this.predicateHandler.resolveAttribute(this.entityClazz.getName(), fieldOrderBy);
        if (!attribute.isPresent()) {
            throw new IllegalStateException("Could not resolve attribute [" + fieldOrderBy + "] of entity [" + this.entityClazz + "]");
        }
        this.orderBy(attribute.get(), order);
        return this;
    }

    public IQuery<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public IQuery<T> offset(int offset) {
        this.offset = offset;
        return this;
    }

    private CriteriaBuilder.Case<Object> getCaseExpression(Map<String, Object> caseContext) {
        CriteriaBuilder.Case caseExpression = this.criteriaBuilder.selectCase();
        for (String caseInfo : caseContext.keySet()) {
            caseInfo = caseInfo.toLowerCase();
            Object value = caseContext.get(caseInfo);
            if (caseInfo.startsWith("when")) {
                String[] parts = caseInfo.split("\\|");
                if (parts.length == 4) {
                    Optional<SingularAttribute> attribute = this.predicateHandler.resolveAttribute(this.entityClazz.getName(), parts[1]);
                    if (attribute.isPresent()) {
                        if ("equals".equals(parts[2])) {
                            caseExpression.when((Expression)this.criteriaBuilder.equal((Expression)this.rootQuery.get(attribute.get()), (Object)parts[3]), value);
                            continue;
                        }
                        if (!"like".equals(parts[2])) continue;
                        caseExpression.when((Expression)this.criteriaBuilder.like((Expression)this.rootQuery.get(attribute.get()), parts[3]), value);
                        continue;
                    }
                    throw new IllegalStateException("[" + parts[1] + "] is not a known attribute");
                }
                throw new IllegalStateException("[" + caseInfo + "] is not in a known format");
            }
            if (!caseInfo.startsWith("otherwise")) continue;
            caseExpression.otherwise(value);
        }
        return caseExpression;
    }

    public IQuery<T> orderBy(Map<String, Object> caseContext, IQuery.ORDER order) {
        if (caseContext != null && !caseContext.isEmpty()) {
            CriteriaBuilder.Case<Object> caseExpression = this.getCaseExpression(caseContext);
            Order orderBy = null;
            if (order == IQuery.ORDER.ASC) {
                orderBy = this.criteriaBuilder.asc(caseExpression);
            } else if (order == IQuery.ORDER.DESC) {
                orderBy = this.criteriaBuilder.desc(caseExpression);
            }
            if (orderBy != null) {
                this.orderByList.add(orderBy);
            }
        }
        return this;
    }

    public <S> ISubQuery<S> createSubQuery(Class<S> clazz, IModelService modelService) {
        Class subEntityClazz = modelService.getEntityClass(clazz);
        Subquery sq = this.criteriaQuery.subquery(subEntityClazz);
        return new SubQuery((Subquery<? extends EntityWithId>)sq, subEntityClazz);
    }

    public IQuery<T> exists(ISubQuery<?> subQuery) {
        this.predicateHandler.exists((Subquery)subQuery.getQuery());
        return this;
    }

    public IQuery<T> notExists(ISubQuery<?> subQuery) {
        this.predicateHandler.notExists((Subquery)subQuery.getQuery());
        return this;
    }

    public IQuery<T> startGroup() {
        this.predicateGroups.createPredicateGroup();
        return this;
    }

    public IQuery<T> andJoinGroups() {
        this.predicateGroups.andPredicateGroups();
        return this;
    }

    public IQuery<T> orJoinGroups() {
        this.predicateGroups.orPredicateGroups();
        return this;
    }

    private TypedQuery<?> getTypedQuery() {
        int groups = this.predicateGroups.getPredicateGroupsSize();
        if (groups > 0) {
            if (groups == 2 && EntityWithDeleted.class.isAssignableFrom(this.entityClazz) && !this.includeDeleted) {
                this.andJoinGroups();
                groups = this.predicateGroups.getPredicateGroupsSize();
            }
            if (groups != 1) {
                throw new IllegalStateException("Query has open groups [" + groups + "]");
            }
            this.criteriaQuery = this.criteriaQuery.where((Expression)this.predicateGroups.getCurrentPredicateGroup().getPredicate());
            this.criteriaQuery.orderBy(this.orderByList);
        }
        TypedQuery query = this.entityManager.createQuery(this.criteriaQuery);
        if (this.refreshCache) {
            query.setHint("eclipselink.refresh", (Object)"True");
        }
        if (this.limit > 0) {
            query.setMaxResults(this.limit);
        }
        if (this.offset > 0) {
            query.setFirstResult(this.offset);
        }
        return query;
    }

    public IQueryCursor<T> executeAsCursor() {
        return this.executeAsCursor(null);
    }

    public IQueryCursor<T> executeAsCursor(Map<String, Object> queryHints) {
        TypedQuery<?> query = this.getTypedQuery();
        if (queryHints == null) {
            query.setHint("eclipselink.maintain-cache", (Object)"False");
        } else {
            queryHints.forEach((arg_0, arg_1) -> query.setHint(arg_0, arg_1));
        }
        query.setHint("eclipselink.cursor.scrollable", (Object)"True");
        ScrollableCursor cursor = (ScrollableCursor)query.getSingleResult();
        return new QueryCursor(cursor, this.adapterFactory, this.clazz);
    }

    public List<T> execute() {
        List ret = ((Stream)this.getTypedQuery().getResultStream().parallel()).map(e -> this.adapterFactory.getModelAdapter((EntityWithId)e, this.clazz, true).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
        this.entityManager.clear();
        return ret;
    }

    public Optional<T> executeSingleResult() {
        List<T> result = this.execute();
        if (!result.isEmpty()) {
            if (result.size() > 1) {
                StringBuilder info = new StringBuilder();
                info.append(String.valueOf(result.get(0).getClass().getName()) + ": ");
                for (T t : result) {
                    if (!(t instanceof Identifiable)) continue;
                    info.append(String.valueOf(((Identifiable)t).getId()) + " ");
                }
                LoggerFactory.getLogger(this.getClass()).warn("Multiple results where single expected. Returning first element of [{}]", (Object)info.toString(), (Object)new Throwable());
            }
            return Optional.of(result.get(0));
        }
        return Optional.empty();
    }

    public String toString() {
        Session session = ((JpaEntityManager)this.entityManager.unwrap(JpaEntityManager.class)).getActiveSession();
        DatabaseQuery databaseQuery = ((JpaQuery)this.getTypedQuery()).getDatabaseQuery();
        databaseQuery.prepareCall(session, (Record)new DatabaseRecord());
        String sqlString = databaseQuery.getSQLString();
        return sqlString;
    }

    private class SubQuery<S>
    implements ISubQuery<S> {
        private Subquery<? extends EntityWithId> subQuery;
        private Root<? extends EntityWithId> subRootQuery;
        private Class<? extends EntityWithId> entityClazz;
        private PredicateGroupStack predicateGroups;
        private PredicateHandler predicateHandler;

        public SubQuery(Subquery<? extends EntityWithId> subQuery, Class<? extends EntityWithId> entityClazz) {
            this.subQuery = subQuery;
            this.entityClazz = entityClazz;
            this.subRootQuery = subQuery.from(entityClazz);
            this.predicateGroups = new PredicateGroupStack(AbstractModelQuery.this.criteriaBuilder);
            this.predicateHandler = new PredicateHandler(this.predicateGroups, entityClazz, AbstractModelQuery.this.criteriaBuilder, this.subRootQuery);
            if (EntityWithDeleted.class.isAssignableFrom(entityClazz) && !AbstractModelQuery.this.includeDeleted) {
                this.and((EStructuralFeature)ModelPackage.Literals.DELETEABLE__DELETED, IQuery.COMPARATOR.NOT_EQUALS, true);
            }
        }

        public Object getQuery() {
            int groups = this.predicateGroups.getPredicateGroupsSize();
            if (groups > 0) {
                if (groups == 2 && EntityWithDeleted.class.isAssignableFrom(this.entityClazz) && !AbstractModelQuery.this.includeDeleted) {
                    this.andJoinGroups();
                    groups = this.predicateGroups.getPredicateGroupsSize();
                }
                if (groups == 1) {
                    this.subQuery = this.subQuery.where((Expression)this.predicateGroups.getCurrentPredicateGroup().getPredicate());
                } else {
                    throw new IllegalStateException("Query has open groups [" + groups + "]");
                }
            }
            return this.subQuery;
        }

        public void startGroup() {
            this.predicateGroups.createPredicateGroup();
        }

        public void andJoinGroups() {
            this.predicateGroups.andPredicateGroups();
        }

        public void orJoinGroups() {
            this.predicateGroups.orPredicateGroups();
        }

        public void and(EStructuralFeature feature, IQuery.COMPARATOR comparator, Object value, boolean ignoreCase) {
            this.predicateHandler.and(feature, comparator, value, ignoreCase);
        }

        public void andFeatureCompare(EStructuralFeature feature, IQuery.COMPARATOR comparator, EStructuralFeature otherFeature) {
            this.predicateHandler.andFeatureCompare(feature, comparator, otherFeature);
        }

        public void and(String entityAttributeName, IQuery.COMPARATOR comparator, Object value, boolean ignoreCase) {
            this.predicateHandler.and(entityAttributeName, comparator, value, ignoreCase);
        }

        public void or(EStructuralFeature feature, IQuery.COMPARATOR comparator, Object value, boolean ignoreCase) {
            this.predicateHandler.or(feature, comparator, value, ignoreCase);
        }

        public void or(String entityAttributeName, IQuery.COMPARATOR comparator, Object value, boolean ignoreCase) {
            this.predicateHandler.or(entityAttributeName, comparator, value, ignoreCase);
        }

        public void andParentCompare(String parentEntityAttributeName, IQuery.COMPARATOR comparator, String entityAttributeName) {
            this.predicateHandler.andCompare(AbstractModelQuery.this.rootQuery, AbstractModelQuery.this.entityClazz, parentEntityAttributeName, comparator, entityAttributeName);
        }
    }
}

