/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.mapper;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.fhir.accessor.DocumentReferenceAccessor;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IdentifiableDomainResourceAttributeMapper;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IDocumentTemplate;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IDocumentStore;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.DomainResource;

public class IDocumentAttributeMapper
implements IdentifiableDomainResourceAttributeMapper<IDocument, DocumentReference> {
    private DocumentReferenceAccessor accessor = new DocumentReferenceAccessor();
    private List<IDocumentStore> documentStores;

    public IDocumentAttributeMapper(List<IDocumentStore> documentStores) {
        this.documentStores = documentStores;
    }

    public DocumentReferenceAccessor getAccessor() {
        return this.accessor;
    }

    @Override
    public void elexisToFhir(IDocument elexis, DocumentReference fhir, SummaryEnum summaryEnum, Set<Include> includes) {
        fhir.setId((IIdType)new IdDt(DocumentReference.class.getSimpleName(), elexis.getId()));
        fhir.addIdentifier().setSystem("http://elexis.info/referenced-document-id").setValue(elexis.getId());
        this.mapMetaData((Identifiable)elexis, (DomainResource)fhir);
        if (SummaryEnum.DATA != summaryEnum) {
            this.mapNarrative((Identifiable)elexis, (DomainResource)fhir);
        }
        if (SummaryEnum.TEXT == summaryEnum || SummaryEnum.COUNT == summaryEnum) {
            return;
        }
        fhir.getCategory().clear();
        fhir.addCategory(new CodeableConcept(new Coding(CodingSystem.ELEXIS_DOCUMENT_STOREID.getSystem(), elexis.getStoreId(), "")));
        fhir.setDate(elexis.getLastchanged());
        if (elexis.getCategory() != null) {
            ICategory category = elexis.getCategory();
            CodeableConcept newConcept = new CodeableConcept(new Coding(CodingSystem.ELEXIS_DOCUMENT_CATEGORY.getSystem(), category.getName(), category.getName()));
            fhir.addCategory(newConcept);
        }
        if (elexis instanceof IDocumentTemplate && StringUtils.isNotBlank((CharSequence)((IDocumentTemplate)elexis).getTemplateTyp())) {
            fhir.addCategory(new CodeableConcept(new Coding(CodingSystem.ELEXIS_DOCUMENT_TEMPLATE_TYP.getSystem(), ((IDocumentTemplate)elexis).getTemplateTyp(), "")));
        }
        if (StringUtils.isNotBlank((CharSequence)elexis.getKeywords())) {
            fhir.setDescription(elexis.getKeywords());
        }
        DocumentReference.DocumentReferenceContentComponent content = new DocumentReference.DocumentReferenceContentComponent();
        Attachment attachment = new Attachment();
        String title = elexis.getTitle();
        String extension = FilenameUtils.getExtension((String)title);
        String documentExtension = elexis.getExtension();
        if (StringUtils.isEmpty((CharSequence)extension) || StringUtils.isNotBlank((CharSequence)documentExtension) && !documentExtension.equals(extension)) {
            title = String.valueOf(title) + "." + documentExtension;
        }
        attachment.setTitle(title);
        attachment.setUrl(this.getBinaryUrl(fhir));
        attachment.setCreation(elexis.getCreated());
        content.setAttachment(attachment);
        fhir.addContent(content);
    }

    private String getBinaryUrl(DocumentReference ret) {
        return String.valueOf(ret.getId()) + "/$binary-access-read";
    }

    @Override
    public void fhirToElexis(DocumentReference fhir, IDocument elexis) {
        Optional<IDocumentStore> documentStore = this.getDocumentStoreWithId(elexis.getStoreId());
        if (fhir.hasDate()) {
            elexis.setLastchanged(fhir.getDate());
        }
        if (fhir.hasContent() && ((DocumentReference.DocumentReferenceContentComponent)fhir.getContent().get(0)).hasAttachment() && ((DocumentReference.DocumentReferenceContentComponent)fhir.getContent().get(0)).getAttachment().hasTitle()) {
            elexis.setTitle(((DocumentReference.DocumentReferenceContentComponent)fhir.getContent().get(0)).getAttachment().getTitle());
        }
        if (fhir.hasContent() && ((DocumentReference.DocumentReferenceContentComponent)fhir.getContent().get(0)).hasAttachment() && ((DocumentReference.DocumentReferenceContentComponent)fhir.getContent().get(0)).getAttachment().hasCreation()) {
            elexis.setCreated(((DocumentReference.DocumentReferenceContentComponent)fhir.getContent().get(0)).getAttachment().getCreation());
        }
        documentStore.ifPresent(ds -> {
            Optional<String> category = this.accessor.getCategory((DomainResource)fhir);
            if (category.isPresent() && ds.isAllowed(IDocumentStore.Capability.CATEGORY)) {
                elexis.setCategory(ds.createCategory(category.get()));
            }
            Optional<String> keywords = this.accessor.getKeywords(fhir);
            if (ds.isAllowed(IDocumentStore.Capability.KEYWORDS)) {
                elexis.setKeywords((String)keywords.orElse(null));
            }
        });
    }

    private Optional<IDocumentStore> getDocumentStoreWithId(String id) {
        return this.documentStores.stream().filter(ds -> ds.getId().equals(id)).findFirst();
    }
}

