/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.tasks.internal.service;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.TaskDescriptor;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.tasks.internal.model.service.ContextServiceHolder;
import ch.elexis.core.tasks.internal.model.service.CoreModelServiceHolder;
import ch.elexis.core.tasks.internal.model.service.TaskModelAdapterFactory;
import ch.elexis.core.tasks.internal.service.LogProgressMonitor;
import ch.elexis.core.tasks.internal.service.TaskServiceHolder;
import ch.elexis.core.tasks.internal.service.TaskServiceImpl;
import ch.elexis.core.tasks.model.ITask;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.TaskState;
import ch.elexis.core.tasks.model.TaskTriggerType;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task
extends AbstractIdDeleteModelAdapter<ch.elexis.core.jpa.entities.Task>
implements Identifiable,
ITask,
Runnable {
    private static final Gson GSON = new Gson();
    private Logger logger;
    private IProgressMonitor progressMonitor;
    private String taskId;
    private boolean isTriggerSync = false;

    public Task(ch.elexis.core.jpa.entities.Task entity) {
        super((EntityWithId)entity);
    }

    public Task(ITaskDescriptor taskDescriptor, TaskTriggerType triggerType, IProgressMonitor progressMonitor, Map<String, String> runContext) {
        this(new ch.elexis.core.jpa.entities.Task());
        this.taskId = String.valueOf(taskDescriptor.isSingleton() ? "Task-S-" : "Task---") + this.getId();
        ((ch.elexis.core.jpa.entities.Task)this.getEntity()).setState(TaskState.DRAFT.getValue());
        ((ch.elexis.core.jpa.entities.Task)this.getEntity()).setTriggerEvent(triggerType.getValue());
        ((ch.elexis.core.jpa.entities.Task)this.getEntity()).setTaskDescriptor((TaskDescriptor)((AbstractIdModelAdapter)taskDescriptor).getEntityMarkDirty());
        if (runContext != null) {
            ((ch.elexis.core.jpa.entities.Task)this.getEntity()).setRunContext(GSON.toJson(runContext));
            this.isTriggerSync = Boolean.valueOf(runContext.get("isTriggerSync"));
        }
        String stationIdentifier = ContextServiceHolder.get().getRootContext().getStationIdentifier();
        ((ch.elexis.core.jpa.entities.Task)this.getEntity()).setRunner(StringUtils.abbreviate((String)stationIdentifier, (int)64));
        ((ch.elexis.core.jpa.entities.Task)this.getEntity()).setCreatedAt(Long.valueOf(System.currentTimeMillis()));
        this.logger = LoggerFactory.getLogger((String)("Task [" + taskDescriptor.getReferenceId() + "]"));
        this.logger.debug("state = {}, origin = {}, originReferenceId = {}", new Object[]{this.getState(), taskDescriptor.getId(), taskDescriptor.getReferenceId()});
        this.progressMonitor = progressMonitor != null ? progressMonitor : new LogProgressMonitor(this.logger);
        AccessControlServiceHolder.get().doPrivileged(() -> CoreModelServiceHolder.get().save((Identifiable)this));
    }

    @Override
    public IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    @Override
    public Map<String, Serializable> getRunContext() {
        String json = ((ch.elexis.core.jpa.entities.Task)this.getEntity()).getRunContext();
        if (json != null) {
            return (Map)GSON.fromJson(json, Map.class);
        }
        return new HashMap<String, Serializable>();
    }

    @Override
    public TaskState getState() {
        int val = ((ch.elexis.core.jpa.entities.Task)this.getEntity()).getState();
        return TaskState.get(val);
    }

    void setState(TaskState state) {
        ((ch.elexis.core.jpa.entities.Task)this.getEntity()).setState(state.getValue());
        if (TaskState.READY == state) {
            String userId = ContextServiceHolder.get().getActiveUser().map(u -> u.getId()).orElse(null);
            String mandatorId = ContextServiceHolder.get().getActiveMandator().map(u -> u.getId()).orElse(null);
            this.logger.info("state = {}, activeUserId = {}, activeMandatorId = {}", new Object[]{this.getState(), userId, mandatorId});
        } else if (TaskState.FAILED == state) {
            this.logger.warn("state = {}, result = [{}]", (Object)this.getState(), this.getResult());
        } else if (TaskState.COMPLETED == state || TaskState.CANCELLED == state) {
            this.logger.info("state = {}, result = [{}]", (Object)this.getState(), this.getResult());
        } else {
            this.logger.debug("state = {}", (Object)this.getState());
        }
        CoreModelServiceHolder.get().save((Identifiable)this);
        TaskServiceImpl ts = (TaskServiceImpl)TaskServiceHolder.get();
        ts.notify(this);
    }

    private void setResult(Map<String, Serializable> result) {
        String json = GSON.toJson(result);
        ((ch.elexis.core.jpa.entities.Task)this.getEntity()).setResult(json);
        CoreModelServiceHolder.get().save((Identifiable)this);
    }

    @Override
    public ITaskDescriptor getTaskDescriptor() {
        Optional adapter = TaskModelAdapterFactory.getInstance().getModelAdapter((EntityWithId)((ch.elexis.core.jpa.entities.Task)this.getEntity()).getTaskDescriptor(), ITaskDescriptor.class, true, false);
        return adapter.orElse(null);
    }

    @Override
    public TaskTriggerType getTriggerEvent() {
        int val = ((ch.elexis.core.jpa.entities.Task)this.getEntity()).getTriggerEvent();
        return TaskTriggerType.get(val);
    }

    public Map<String, Serializable> getResult() {
        String json = ((ch.elexis.core.jpa.entities.Task)this.getEntity()).getResult();
        if (json != null) {
            return (Map)GSON.fromJson(json, Map.class);
        }
        return new HashMap<String, Serializable>();
    }

    @Override
    public <T> List<T> getResultEntryAsTypedList(String key, Class<T> clazz) {
        List list = (List)((Object)this.getResult().get(key));
        if (list != null && !list.isEmpty()) {
            String json = GSON.toJson((Object)list);
            Type type = TypeToken.getParameterized(ArrayList.class, (Type[])new Type[]{clazz}).getType();
            return (List)GSON.fromJson(json, type);
        }
        return Collections.emptyList();
    }

    @Override
    public <T> T getResultEntryTyped(String key, Class<T> clazz) {
        Map map;
        String json = ((ch.elexis.core.jpa.entities.Task)this.getEntity()).getResult();
        if (json != null && !(map = (Map)GSON.fromJson(json, Map.class)).isEmpty()) {
            String valueToString = GSON.toJson(map.get(key));
            return (T)GSON.fromJson(valueToString, clazz);
        }
        return null;
    }

    @Override
    public <T> T getRunContextEntryTyped(String key, Class<T> clazz) {
        Map<String, Serializable> map = this.getRunContext();
        String valueToString = GSON.toJson((Object)map.get(key));
        return (T)GSON.fromJson(valueToString, clazz);
    }

    @Override
    public void setStateCompletedManual(String remark) {
        String userId = ContextServiceHolder.get().getActiveUser().map(u -> u.getId()).orElse(null);
        String stationId = ContextServiceHolder.get().getStationIdentifier();
        String note = String.valueOf(System.currentTimeMillis()) + "#" + userId + "@" + stationId + ":" + remark;
        this.setState(TaskState.COMPLETED_MANUAL);
        Map<String, Serializable> result = this.getResult();
        result.put(TaskState.COMPLETED_MANUAL.name(), (Serializable)((Object)note));
        this.setResult(result);
    }

    @Override
    public boolean isSucceeded() {
        return TaskState.COMPLETED == this.getState();
    }

    @Override
    public boolean isFailed() {
        return TaskState.FAILED == this.getState();
    }

    @Override
    public boolean isFinished() {
        return TaskState.COMPLETED == this.getState() || TaskState.COMPLETED_WARN == this.getState() || TaskState.FAILED == this.getState() || TaskState.CANCELLED == this.getState();
    }

    private void removeTaskRecord() {
        AccessControlServiceHolder.get().doPrivileged(() -> CoreModelServiceHolder.get().remove((Identifiable)this));
    }

    @Override
    public void run() {
        Thread.currentThread().setName(this.taskId);
        ITaskDescriptor originTaskDescriptor = this.getTaskDescriptor();
        try {
            try {
                IUser owner;
                if (this.isTriggerSync) {
                    owner = ContextServiceHolder.get().getActiveUser().orElse(null);
                } else {
                    owner = originTaskDescriptor.getOwner();
                    if (owner == null) {
                        throw new TaskException(1, "No task owner defined");
                    }
                }
                if (this.isThreadLocalContextService()) {
                    ContextServiceHolder.get().setActiveUser(owner);
                    IContact user_assignedContact = owner.getAssignedContact();
                    if (user_assignedContact != null && user_assignedContact.isMandator()) {
                        IMandator mandator = CoreModelServiceHolder.get().load(user_assignedContact.getId(), IMandator.class).orElse(null);
                        ContextServiceHolder.get().setActiveMandator(mandator);
                    }
                }
                ((ch.elexis.core.jpa.entities.Task)this.getEntity()).setRunAt(Long.valueOf(System.currentTimeMillis()));
                this.setState(TaskState.READY);
                String runnableWithContextId = originTaskDescriptor.getIdentifiedRunnableId();
                IIdentifiedRunnable runnableWithContext = TaskServiceHolder.get().instantiateRunnableById(runnableWithContextId);
                HashMap<String, Serializable> effectiveRunContext = new HashMap<String, Serializable>();
                effectiveRunContext.putAll(runnableWithContext.getDefaultRunContext());
                effectiveRunContext.putAll(originTaskDescriptor.getRunContext());
                effectiveRunContext.putAll(this.getRunContext());
                this.assertRequiredRunContextParameters(effectiveRunContext);
                ((ch.elexis.core.jpa.entities.Task)this.getEntity()).setRunContext(GSON.toJson(effectiveRunContext));
                this.setState(TaskState.IN_PROGRESS);
                try {
                    Map<String, Serializable> result = runnableWithContext.run(effectiveRunContext, this.progressMonitor, this.logger);
                    if (result == null) {
                        result = Collections.emptyMap();
                    }
                    this.setResult(result);
                    ((ch.elexis.core.jpa.entities.Task)this.getEntity()).setFinishedAt(Long.valueOf(System.currentTimeMillis()));
                    TaskState exitState = result.containsKey("markerWarn") ? TaskState.COMPLETED_WARN : TaskState.COMPLETED;
                    this.setState(exitState);
                    if (effectiveRunContext.containsKey("markerDoNotPersist") || this.getResult().containsKey("markerDoNotPersist")) {
                        this.removeTaskRecord();
                    }
                }
                catch (OperationCanceledException oce) {
                    this.setState(TaskState.CANCELLED);
                    ((ch.elexis.core.jpa.entities.Task)this.getEntity()).setFinishedAt(Long.valueOf(System.currentTimeMillis()));
                    this.setResult(Collections.singletonMap("resultData", oce.getMessage()));
                }
                this.progressMonitor.done();
            }
            catch (Error | Exception e) {
                this.setResult(Collections.singletonMap("exceptionMessage", e.getMessage()));
                Throwable throwable = e.getCause() != null ? e.getCause() : e;
                this.logger.warn(e.getMessage(), throwable);
                ((ch.elexis.core.jpa.entities.Task)this.getEntity()).setFinishedAt(Long.valueOf(System.currentTimeMillis()));
                this.setState(TaskState.FAILED);
                if (this.isThreadLocalContextService()) {
                    ContextServiceHolder.get().setActiveUser(null);
                    ContextServiceHolder.get().setActiveMandator(null);
                }
            }
        }
        finally {
            if (this.isThreadLocalContextService()) {
                ContextServiceHolder.get().setActiveUser(null);
                ContextServiceHolder.get().setActiveMandator(null);
            }
        }
    }

    private void assertRequiredRunContextParameters(Map<String, Serializable> effectiveRunContext) throws TaskException {
        boolean hasMissingRequiredRunContextParameter = effectiveRunContext.values().contains("missingRequired");
        if (hasMissingRequiredRunContextParameter) {
            List missingValues = effectiveRunContext.keySet().stream().filter(key -> ((Serializable)effectiveRunContext.get(key)).equals("missingRequired")).collect(Collectors.toList());
            throw new TaskException(1, "Missing required run-context-parameter(s): " + missingValues);
        }
    }

    private boolean isThreadLocalContextService() {
        return !ContextServiceHolder.get().getClass().getName().startsWith("ch.elexis.core.ui.services");
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        throw new UnsupportedOperationException();
    }

    public IXid getXid(String domain) {
        throw new UnsupportedOperationException();
    }

    public String getLabel() {
        return "Task [" + this.getId() + "/" + this.getTaskDescriptor().getReferenceId() + "] <= (" + (Object)((Object)this.getTriggerEvent()) + "): " + (Object)((Object)this.getState());
    }

    @Override
    public String getRunner() {
        return ((ch.elexis.core.jpa.entities.Task)this.getEntity()).getRunner();
    }

    @Override
    public LocalDateTime getCreatedAt() {
        return ((ch.elexis.core.jpa.entities.Task)this.getEntity()).getCreatedAtLocalDateTime();
    }

    @Override
    public LocalDateTime getRunAt() {
        return ((ch.elexis.core.jpa.entities.Task)this.getEntity()).getRunAtLocalDateTime();
    }

    @Override
    public LocalDateTime getFinishedAt() {
        return ((ch.elexis.core.jpa.entities.Task)this.getEntity()).getFinishedAtLocalDateTime();
    }

    @Override
    public boolean isSystem() {
        return ((ch.elexis.core.jpa.entities.Task)this.getEntity()).isSystem();
    }

    @Override
    public void setSystem(boolean value) {
        ((ch.elexis.core.jpa.entities.Task)this.getEntity()).setSystem(value);
    }
}

