/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import ch.rgw.tools.StringTool;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FuzzyMatcher {
    public static final int LITERAL = 0;
    public static final int LEVENSHTEIN = 1;
    public static final int SHIFT_AND = 2;
    public static final int REGEX = 3;
    public static final int SYNPHON = 4;
    public static final int EXACT = 0;
    public static final int SHARP = 1;
    public static final int MEDIUM = 2;
    public static final int BLURRED = 3;
    String pattern;
    int type;
    int level;
    boolean emptyMatches = false;
    private static Logger log = Logger.getLogger("Matcher");
    private static final String Vokale = "[aeiou\ufffd\ufffd\ufffdyh]";
    private static final String[] grps = new String[]{"1,ei,ey,ay,ai,eu", "2,au,aw", "x,ks,gs", "b,p,mb,mp", "g,ck,k,q", "s,sch,sz,ts,cz,ch,c,z", "d,t,mt,md", "f,ph,v,w"};

    public static String Version() {
        return "1.1.1";
    }

    private FuzzyMatcher() {
    }

    public static FuzzyMatcher createWLDMatcher(String pattern, int level) {
        FuzzyMatcher ret = new FuzzyMatcher();
        ret.type = 1;
        ret.pattern = pattern;
        ret.level = level;
        if (level > 2) {
            ret.emptyMatches = true;
        }
        log.log(Level.FINE, "create WLDMatcher level " + ret.level);
        return ret;
    }

    public static FuzzyMatcher createSynphonMatcher(String pattern, int level) {
        FuzzyMatcher ret = new FuzzyMatcher();
        ret.type = 4;
        if (level > 2) {
            ret.emptyMatches = true;
        }
        switch (level) {
            case 1: {
                ret.level = 5;
                break;
            }
            case 2: {
                ret.level = 3;
                break;
            }
            default: {
                ret.level = 2;
            }
        }
        ret.pattern = FuzzyMatcher.SYPH_compile(pattern.trim(), ret.level);
        log.log(Level.FINE, "create SYPHMatcher level " + ret.level);
        log.log(Level.FINE, "pattern: " + ret.pattern);
        return ret;
    }

    public static FuzzyMatcher createLiteralMatcher(String pattern, int level) {
        FuzzyMatcher ret = new FuzzyMatcher();
        ret.type = 0;
        ret.level = level;
        ret.pattern = pattern;
        return ret;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean match(String w1) {
        if (StringTool.isNothing(w1)) {
            return this.emptyMatches;
        }
        String wort = w1.trim();
        if (this.level == 0) {
            return wort.equals(this.pattern);
        }
        String[] pat = wort.split("[\\s,\\.]");
        if (pat.length < 1 || StringTool.isNothing(pat[0]) || pat[0].equals(" ")) {
            return this.emptyMatches;
        }
        switch (this.type) {
            case 1: {
                return FuzzyMatcher.WLD(pat[0], this.pattern, '*', this.level) <= this.level;
            }
            case 4: {
                return FuzzyMatcher.SynPhon(pat[0], this.pattern, this.level);
            }
            case 0: {
                return pat[0].equalsIgnoreCase(this.pattern);
            }
        }
        return false;
    }

    private static String formatierung(String wort, char modus) {
        String res = wort.toUpperCase();
        res = res.replaceAll("\u00e4", "ae");
        res = res.replaceAll("\u00c4", "Ae");
        res = res.replaceAll("\u00f6", "oe");
        res = res.replaceAll("\u00d6", "Oe");
        res = res.replaceAll("\u00fc", "ue");
        res = res.replaceAll("\u00dc", "Ue");
        if (modus == '*') {
            res = res.replaceAll("\\**", "\\*");
        }
        return res;
    }

    public static int WLD(String wort, String muster, char modus, int limit) {
        int spmin;
        int k;
        int i;
        int[] d = new int[100];
        if (modus == '+' || modus == '*') {
            String ww = FuzzyMatcher.formatierung(wort, modus);
            String mm = FuzzyMatcher.formatierung(muster, modus);
            if (modus == '*' && ww.length() < mm.length() - 1 && ww.indexOf(42) != -1) {
                i = ww.length();
                wort = mm;
                muster = String.valueOf(ww) + "*";
                if ((i /= 3) < limit) {
                    limit = i;
                }
            } else {
                wort = ww;
                muster = mm;
            }
        }
        if (muster.charAt(0) == '*') {
            k = 0;
            while (k <= wort.length()) {
                d[k] = 0;
                ++k;
            }
        } else {
            d[0] = muster.equals("") ? 0 : 1;
            i = muster.charAt(0) == '?' ? 0 : 1;
            k = 1;
            while (k <= wort.length()) {
                if (muster.charAt(0) == wort.charAt(k - 1)) {
                    i = 0;
                }
                d[k] = k - 1 + i;
                ++k;
            }
        }
        int n = spmin = d[0] == 0 || wort.length() == 0 ? d[0] : d[1];
        if (spmin > limit) {
            return 100;
        }
        i = 2;
        while (i <= muster.length()) {
            char c = muster.charAt(i - 1);
            int p = c == '*' || c == '?' ? 0 : 1;
            int q = c == '*' ? 0 : 1;
            int r = c == '*' ? 0 : 1;
            int d2 = d[0];
            d[0] = d2 + q;
            spmin = d[0];
            k = 1;
            while (k <= wort.length()) {
                int d1 = d2;
                d2 = d[k];
                int x1 = d1 + (c == wort.charAt(k - 1) ? 0 : p);
                int x2 = d2 + q;
                int x3 = d[k - 1] + r;
                if (x1 < x2) {
                    x2 = x1;
                }
                int n2 = d[k] = x2 < x3 ? x2 : x3;
                if (d[k] < spmin) {
                    spmin = d[k];
                }
                ++k;
            }
            if (spmin > limit) {
                return 100;
            }
            ++i;
        }
        return d[wort.length()] <= limit ? d[wort.length()] : 100;
    }

    public static String SYPH_compile(String wort, int l) {
        String r1 = wort.toLowerCase();
        int i = 0;
        while (i < grps.length) {
            String[] px = grps[i].split(",");
            int j = 1;
            while (j < px.length) {
                r1 = r1.replaceAll(px[j], px[0]);
                ++j;
            }
            ++i;
        }
        String r2 = r1.replaceAll(Vokale, "");
        String r3 = r2.replaceAll("(.)\\1", "$1");
        if (r3.length() > l) {
            return r3.substring(0, l);
        }
        return r3;
    }

    public static boolean SynPhon(String wort, String pattern, int l) {
        String cw = FuzzyMatcher.SYPH_compile(wort, l);
        return cw.equals(pattern);
    }
}

