/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt;

import com.equo.chromium.swt.Browser;
import com.equo.chromium.swt.internal.WebBrowser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.browser.CefBrowserSwt;

public interface ChromiumBrowser {
    public static Collection<ChromiumBrowser> getAllBrowsers() {
        ArrayList<ChromiumBrowser> browsers = new ArrayList<ChromiumBrowser>();
        if (CefApp.CefAppState.INITIALIZED.equals((Object)CefApp.getState())) {
            CefApp app = CefApp.getInstance();
            Set<CefClient> clients = app.getAllClients();
            for (CefClient client : clients) {
                Object[] clientBrowsers;
                Object[] objectArray = clientBrowsers = client.getAllBrowser();
                int n = clientBrowsers.length;
                int n2 = 0;
                while (n2 < n) {
                    Object browser = objectArray[n2];
                    if (browser instanceof CefBrowserSwt) {
                        Browser composite = (Browser)((CefBrowserSwt)browser).getComposite();
                        ChromiumBrowser webBrowser = (ChromiumBrowser)composite.getWebBrowser();
                        browsers.add(webBrowser);
                    }
                    ++n2;
                }
            }
        }
        return browsers;
    }

    public void executeJavacript(String var1);

    public void find(String var1, boolean var2, boolean var3);

    public void zoom(double var1);

    public void addConsoleListener(ConsoleListener var1);

    public void removeConsoleListener(ConsoleListener var1);

    public List<Object> getErrors();

    public static void earlyInit() throws ClassNotFoundException {
        Class.forName("com.equo.chromium.swt.internal.Engine");
    }

    public static boolean clearCookies(String urlPattern, String namePattern) {
        return WebBrowser.clearCookie(urlPattern, namePattern);
    }

    public CompletableFuture<byte[]> captureScreenshot();

    public CompletableFuture<byte[]> captureScreenshot(int var1, int var2, int var3, int var4, int var5);

    @FunctionalInterface
    public static interface ConsoleListener {
        public boolean message(int var1, String var2, String var3, int var4);
    }
}

