/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.views;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.ILabResult;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabOrder;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.laboratory.controls.LaborChartComposite;
import ch.elexis.core.ui.laboratory.controls.LaborOrdersComposite;
import ch.elexis.core.ui.laboratory.controls.LaborResultsComposite;
import ch.elexis.core.ui.laboratory.dialogs.LaborVerordnungDialog;
import ch.elexis.core.ui.laboratory.views.LaborOrderPulldownMenuCreator;
import ch.elexis.core.ui.laboratory.views.LaborblattView;
import ch.elexis.core.ui.util.Importer;
import ch.elexis.core.ui.util.Log;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.part.ViewPart;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class LaborView
extends ViewPart
implements IRefreshable {
    public static final String ID = "ch.elexis.Labor";
    private static Log log = Log.get((String)"LaborView");
    private CTabFolder tabFolder;
    private LaborResultsComposite resultsComposite;
    private LaborOrdersComposite ordersComposite;
    private LaborChartComposite laborChartComposite;
    protected boolean isCompareMode;
    private Action fwdAction;
    private Action backAction;
    private Action printAction;
    private Action importAction;
    private Action xmlAction;
    private Action newAction;
    private Action newColumnAction;
    private Action refreshAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    private Action selectAction;
    private ViewMenus menu;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);
    private List<TreeItem> selectedItems = new ArrayList<TreeItem>();

    @Inject
    void activePatient(@Optional IPatient patient) {
        CoreUiUtil.runAsyncIfActive(() -> {
            this.resultsComposite.selectPatient((Patient)NoPoUtil.loadAsPersistentObject((Identifiable)patient));
            this.resetCheckboxes();
        }, (Object)this.tabFolder);
        CoreUiUtil.runAsyncIfActive(() -> this.ordersComposite.selectPatient((Patient)NoPoUtil.loadAsPersistentObject((Identifiable)patient)), (Object)this.tabFolder);
        CoreUiUtil.runAsyncIfActive(() -> this.laborChartComposite.selectPatient((Patient)NoPoUtil.loadAsPersistentObject((Identifiable)patient)), (Object)this.tabFolder);
    }

    @Inject
    @Optional
    public void reload(@UIEventTopic(value="info/elexis/model/reload") Class<?> clazz) {
        if (!(this.resultsComposite == null || this.resultsComposite.isDisposed() || this.ordersComposite == null || this.ordersComposite.isDisposed() || this.laborChartComposite == null || this.laborChartComposite.isDisposed())) {
            if (ILabItem.class.equals(clazz)) {
                Display.getDefault().asyncExec(() -> this.resultsComposite.reload());
            } else if (ILabResult.class.equals(clazz)) {
                Display.getDefault().asyncExec(() -> {
                    this.resultsComposite.reload();
                    this.ordersComposite.reload();
                });
            } else if (ILabOrder.class.equals(clazz)) {
                Display.getDefault().asyncExec(() -> this.ordersComposite.reload());
            }
        }
    }

    public void createPartControl(Composite parent) {
        this.setTitleImage(Images.IMG_VIEW_LABORATORY.getImage());
        this.tabFolder = new CTabFolder(parent, 128);
        this.tabFolder.setLayout((Layout)new FillLayout());
        CTabItem resultsTabItem = new CTabItem(this.tabFolder, 0);
        resultsTabItem.setText("Resultate");
        this.resultsComposite = new LaborResultsComposite((Composite)this.tabFolder, 0, this);
        resultsTabItem.setControl((Control)this.resultsComposite);
        CTabItem ordersTabItem = new CTabItem(this.tabFolder, 0);
        ordersTabItem.setText("Verordnungen");
        this.ordersComposite = new LaborOrdersComposite((Composite)this.tabFolder, 0);
        ordersTabItem.setControl((Control)this.ordersComposite);
        final CTabItem chartTabItem = new CTabItem(this.tabFolder, 0);
        chartTabItem.setText("Histogramm");
        chartTabItem.setForeground(UiDesk.getColor((String)"grau"));
        this.laborChartComposite = new LaborChartComposite((Composite)this.tabFolder, 0, this);
        this.laborChartComposite.setLayout((Layout)new FillLayout());
        chartTabItem.setControl((Control)this.laborChartComposite);
        chartTabItem.setData("enabled", (Object)false);
        chartTabItem.getControl().setEnabled(false);
        this.tabFolder.setSelection(0);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LaborView.this.tabFolder.getSelection() == chartTabItem) {
                    if (Boolean.TRUE.equals(chartTabItem.getData("enabled"))) {
                        LaborView.this.laborChartComposite.updateCharts(LaborView.this.laborChartComposite.getChartsComposite());
                    } else {
                        LaborView.this.tabFolder.setSelection(0);
                    }
                } else {
                    LaborView.this.resultsComposite.reload();
                    LaborView.this.ordersComposite.reload();
                }
            }
        });
        this.makeActions();
        this.menu = new ViewMenus(this.getViewSite());
        this.menu.createMenu(new IAction[]{this.newAction, this.backAction, this.fwdAction, this.printAction, this.importAction, this.xmlAction, this.selectAction});
        LaborOrderPulldownMenuCreator menuCreator = new LaborOrderPulldownMenuCreator(parent.getShell());
        if (menuCreator.getSelected() != null) {
            IAction dropDownAction = menuCreator.getAction();
            IActionBars actionBars = this.getViewSite().getActionBars();
            IToolBarManager toolbar = actionBars.getToolBarManager();
            toolbar.add(dropDownAction);
            dropDownAction.setText(menuCreator.getSelected().getText());
            dropDownAction.setToolTipText(menuCreator.getSelected().getToolTipText());
            dropDownAction.setImageDescriptor(menuCreator.getSelected().getImageDescriptor());
        }
        IToolBarManager tm = this.getViewSite().getActionBars().getToolBarManager();
        List importers = Extensions.getClasses((List)Extensions.getExtensions((String)"ch.elexis.core.ui.LaborDatenImport"), (String)"ToolbarAction", (boolean)false);
        for (IAction ac : importers) {
            tm.add(ac);
        }
        if (!importers.isEmpty()) {
            tm.add((IContributionItem)new Separator());
        }
        tm.add((IAction)this.selectAction);
        tm.add((IAction)this.refreshAction);
        tm.add((IAction)this.newColumnAction);
        tm.add((IAction)this.newAction);
        tm.add((IAction)this.backAction);
        tm.add((IAction)this.fwdAction);
        tm.add((IAction)this.expandAllAction);
        tm.add((IAction)this.collapseAllAction);
        tm.add((IAction)this.printAction);
        Patient act = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
        if (act != null && act != this.resultsComposite.getPatient()) {
            this.resultsComposite.selectPatient(act);
        }
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        super.dispose();
    }

    public void setFocus() {
        if (this.resultsComposite.isVisible()) {
            this.resultsComposite.setFocus();
        } else if (this.ordersComposite.isVisible()) {
            this.ordersComposite.setFocus();
        }
    }

    public void refresh() {
        this.activePatient(ContextServiceHolder.get().getActivePatient().orElse(null));
    }

    private void makeActions() {
        this.fwdAction = new Action(Messages.LaborView_nextPage){

            public void run() {
                LaborView.this.resultsComposite.setColumnOffset(LaborView.this.resultsComposite.getColumnOffset() + 1);
                LaborView.this.resultsComposite.reload();
                LaborView.this.tabFolder.setSelection(0);
            }
        };
        this.backAction = new Action(Messages.LaborView_prevPage){

            public void run() {
                LaborView.this.resultsComposite.setColumnOffset(LaborView.this.resultsComposite.getColumnOffset() - 1);
                LaborView.this.resultsComposite.reload();
                LaborView.this.tabFolder.setSelection(0);
            }
        };
        this.printAction = new Action(Messages.Core_Print_ellipsis){

            public void run() {
                try {
                    LaborblattView lb = (LaborblattView)LaborView.this.getViewSite().getPage().showView("ch.elexis.Laborblatt");
                    Patient pat = ElexisEventDispatcher.getSelectedPatient();
                    lb.createLaborblatt(pat, LaborView.this.resultsComposite.getPrintHeaders(), LaborView.this.resultsComposite.getPrintRows(), LaborView.this.resultsComposite.getSkipIndex());
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        };
        this.importAction = new Action(Messages.Core_Import_Action){
            {
                this.setImageDescriptor(Images.IMG_IMPORT.getImageDescriptor());
                this.setToolTipText(Messages.LaborView_importToolTip);
            }

            public void run() {
                Importer imp = new Importer(LaborView.this.getViewSite().getShell(), "ch.elexis.core.ui.LaborDatenImport");
                imp.create();
                imp.setMessage(Messages.Core_Choose_Import_Source);
                imp.getShell().setText(Messages.LaborView_labImporterCaption);
                imp.setTitle(Messages.LaborView_labImporterText);
                imp.open();
            }
        };
        this.xmlAction = new Action(Messages.LaborView_xmlExport){

            public void run() {
                FileDialog fsel;
                String fname;
                Document doc = LaborView.this.makeXML();
                if (doc != null && (fname = (fsel = new FileDialog(Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell())).open()) != null) {
                    try {
                        FileOutputStream fout = new FileOutputStream(fname);
                        OutputStreamWriter cout = new OutputStreamWriter((OutputStream)fout, "UTF-8");
                        XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
                        xout.output(doc, (Writer)cout);
                        cout.close();
                        fout.close();
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                        SWTHelper.alert((String)Messages.Core_Error, (String)(String.valueOf(Messages.LaborView_couldntwrite) + fname));
                    }
                }
            }
        };
        this.selectAction = new Action("Ausgew\u00e4hlte Werte vergleichen"){

            public void run() {
                LaborView.this.isCompareMode = !LaborView.this.isCompareMode;
                CTabItem chartTabItem = LaborView.this.tabFolder.getItem(2);
                if (LaborView.this.isCompareMode) {
                    this.setText("Ausgew\u00e4hlte Werte vergleichen");
                    this.setImageDescriptor(Images.IMG_CHART_CURVE.getImageDescriptor());
                    LaborView.this.resultsComposite.showCheckboxes(true);
                    chartTabItem.setData("enabled", (Object)true);
                    chartTabItem.getControl().setEnabled(true);
                    chartTabItem.setText("Histogramm");
                    chartTabItem.setForeground(UiDesk.getColor((String)"schwarz"));
                    LaborView.this.laborChartComposite.updateCharts(LaborView.this.laborChartComposite.getChartsComposite());
                } else {
                    this.setText("Vergleichen");
                    this.setImageDescriptor(Images.IMG_CHART_CURVE.getImageDescriptor());
                    LaborView.this.resultsComposite.showCheckboxes(false);
                    chartTabItem.setData("enabled", (Object)false);
                    chartTabItem.getControl().setEnabled(false);
                    chartTabItem.setText("Histogramm");
                    chartTabItem.setForeground(UiDesk.getColor((String)"grau"));
                }
                LaborView.this.resultsComposite.getViewer().refresh();
            }
        };
        this.newColumnAction = new Action(Messages.Core_prescribe_Laboratory){

            public void run() {
                LaborView.this.tabFolder.setSelection(0);
                LaborView.this.resultsComposite.toggleNewColumn();
            }
        };
        this.newAction = new Action(Messages.Core_prescribe_Laboratory){

            public void run() {
                Patient patient = ElexisEventDispatcher.getSelectedPatient();
                if (patient == null) {
                    return;
                }
                TimeTool date = new TimeTool();
                LaborVerordnungDialog dialog = new LaborVerordnungDialog(LaborView.this.getSite().getShell(), patient, date);
                if (dialog.open() == 0) {
                    LaborView.this.tabFolder.setSelection(1);
                }
            }
        };
        this.refreshAction = new Action(Messages.Core_Update){

            public void run() {
                LaborView.this.resultsComposite.reload();
                LaborView.this.ordersComposite.reload();
            }
        };
        this.expandAllAction = new Action(Messages.LaborView_expand_all){

            public void run() {
                if (LaborView.this.tabFolder.getSelectionIndex() == 0) {
                    LaborView.this.resultsComposite.expandAll();
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_ARROWDOWN.getImageDescriptor();
            }
        };
        this.collapseAllAction = new Action(Messages.LaborView_collapse_all){

            public void run() {
                if (LaborView.this.tabFolder.getSelectionIndex() == 0) {
                    LaborView.this.resultsComposite.collapseAll();
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_ARROWUP.getImageDescriptor();
            }
        };
        this.newColumnAction.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
        this.newAction.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
        this.fwdAction.setImageDescriptor(Images.IMG_NEXT.getImageDescriptor());
        this.backAction.setImageDescriptor(Images.IMG_PREVIOUS.getImageDescriptor());
        this.printAction.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
        this.xmlAction.setImageDescriptor(Images.IMG_EXPORT.getImageDescriptor());
        this.refreshAction.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
        this.selectAction.setImageDescriptor(Images.IMG_CHART_CURVE.getImageDescriptor());
    }

    public Document makeXML() {
        Document doc = null;
        try {
            doc = new Document();
            Element r = new Element("Laborblatt");
            r.setAttribute("Erstellt", new TimeTool().toString(0));
            Patient actpat = ElexisEventDispatcher.getSelectedPatient();
            if (actpat == null) {
                return doc;
            }
            r.setAttribute("Patient", actpat.getLabel());
            doc.setRootElement(r);
            Element Daten = new Element("Daten");
            r.setAttribute("Patient", actpat.getLabel());
            HashMap groupedResults = LabResult.getGrouped((Patient)actpat);
            List<String> dates = this.getDates(groupedResults);
            for (String d : dates) {
                Element dat = new Element("Datum");
                dat.setAttribute("Tag", d);
                Daten.addContent((Content)dat);
            }
            r.addContent((Content)Daten);
            ArrayList groupNames = new ArrayList();
            groupNames.addAll(groupedResults.keySet());
            for (String g : groupNames) {
                Element eGroup = new Element("Gruppe");
                eGroup.setAttribute("Name", g);
                HashMap itemMap = (HashMap)groupedResults.get(g);
                List<LabItem> items = this.getItems(itemMap);
                if (items == null) {
                    log.log("Ung\u00fcltige Gruppe " + g, 3);
                    continue;
                }
                if (items.isEmpty()) continue;
                for (LabItem it : items) {
                    Element eItem = new Element("Parameter");
                    eItem.setAttribute("Name", it.getName());
                    eItem.setAttribute("K\u00fcrzel", it.getKuerzel());
                    eItem.setAttribute("Einheit", it.getEinheit());
                    HashMap resultsPerDate = (HashMap)itemMap.get(it.getShortLabel());
                    Set resultDates = resultsPerDate.keySet();
                    for (String date : resultDates) {
                        List results = (List)resultsPerDate.get(date);
                        Element eResult = new Element("Resultat");
                        eResult.setAttribute("Datum", date);
                        eItem.addContent((Content)eResult);
                        for (LabResult lr : results) {
                            eResult.addContent(lr.getResult());
                        }
                        Element ref = new Element("Referenz");
                        ref.setAttribute("m", it.get("RefMann"));
                        ref.setAttribute("w", it.get("RefFrauOrTx"));
                        eItem.addContent((Content)ref);
                    }
                    eGroup.addContent((Content)eItem);
                }
                if (eGroup.getContentSize() == 0) continue;
                r.addContent((Content)eGroup);
            }
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
        }
        return doc;
    }

    private List<LabItem> getItems(HashMap<String, HashMap<String, List<LabResult>>> itemMap) {
        Set<String> keys = itemMap.keySet();
        ArrayList<LabItem> ret = new ArrayList<LabItem>();
        for (String string : keys) {
            Collection<List<LabResult>> values = itemMap.get(string).values();
            if (values.isEmpty()) continue;
            Iterator<List<LabResult>> iter = values.iterator();
            List<LabResult> first = iter.next();
            while (first.isEmpty() && iter.hasNext()) {
                first = iter.next();
            }
            ret.add((LabItem)first.get(0).getItem());
        }
        return ret;
    }

    public List<String> getDates(HashMap<String, HashMap<String, HashMap<String, List<LabResult>>>> map) {
        ArrayList<String> ret = new ArrayList<String>();
        HashSet<String> dateStrings = new HashSet<String>();
        for (String group : map.keySet()) {
            HashMap<String, HashMap<String, List<LabResult>>> itemMap = map.get(group);
            for (String item : itemMap.keySet()) {
                dateStrings.addAll(itemMap.get(item).keySet());
            }
        }
        ret.addAll(dateStrings);
        Collections.sort(ret);
        return ret;
    }

    public void activation(boolean mode) {
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    public void reloadContents(Class clazz) {
        clazz.equals(LabItem.class);
    }

    public void setSelectedItems(List<TreeItem> items) {
        this.selectedItems = new ArrayList<TreeItem>(items);
    }

    public List<TreeItem> getSelectedItems() {
        return this.selectedItems;
    }

    private void resetCheckboxes() {
        if (this.resultsComposite != null) {
            this.resultsComposite.resetCheckboxes();
        }
    }
}

