/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.preferences;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.ac.EvACEs;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.preferences.inputs.PrefAccessDenied;
import ch.elexis.data.LabMapping;
import ch.elexis.data.Query;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabSettings
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger log = LoggerFactory.getLogger(LabSettings.class);
    private Text txtKeepUnseen;
    private String daysKeepUnseen;
    private Text txtAnzahlMonate;
    private Font histogramFont;

    public LabSettings() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.USER));
        this.getPreferenceStore().setDefault("lab/localRefValues", true);
    }

    protected Control createContents(Composite parent) {
        if (AccessControlServiceHolder.get().evaluate(EvACEs.LAB_SEEN)) {
            return super.createContents(parent);
        }
        return new PrefAccessDenied(parent);
    }

    protected void createFieldEditors() {
        FontData[] fontData;
        this.addField((FieldEditor)new BooleanFieldEditor("lab/showMandantOnly", Messages.LabSettings_showOrdersActiveMandant, this.getFieldEditorParent()));
        this.addField((FieldEditor)new RadioGroupFieldEditor("lab/heartrate_unseen", Messages.LabSettings_frequencyNewLabvalues, 3, (String[][])new String[][]{{Messages.Core_Normal, "1"}, {Messages.LabSettings_medium, "2"}, {Messages.LabSettings_slow, "3"}}, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("lab/localRefValues", Messages.LabSettings_useLocalLabRefValues, this.getFieldEditorParent()));
        Composite area = new Composite(this.getFieldEditorParent(), 0);
        area.setLayoutData((Object)new GridData(4, 128, true, false));
        area.setLayout((Layout)new GridLayout(2, false));
        Label lblKeepUnseen = new Label(area, 0);
        lblKeepUnseen.setText(Messages.LabSettings_showNewLabvaluesDays);
        this.txtKeepUnseen = new Text(area, 2048);
        this.txtKeepUnseen.setLayoutData((Object)new GridData(4, 128, true, false));
        this.txtKeepUnseen.setText(this.daysKeepUnseen);
        Button btnValidateMappings = new Button(area, 8);
        btnValidateMappings.setText(Messages.LabSettings_validateMappings);
        btnValidateMappings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Query query = new Query(LabMapping.class);
                query.add("id", "<>", "VERSION");
                List mappings = query.execute();
                int countDeleted = 0;
                for (LabMapping labMapping : mappings) {
                    if (labMapping.isMappingValid()) continue;
                    ++countDeleted;
                    labMapping.delete();
                }
                MessageDialog.openInformation((Shell)LabSettings.this.getShell(), (String)Messages.LabSettings_validateMappings, (String)MessageFormat.format(Messages.LabSettings_validateMappingsResult, countDeleted));
            }
        });
        Label lblHistogramTitle = new Label(this.getFieldEditorParent(), 0);
        lblHistogramTitle.setText("Histogramm");
        FontData[] fontDataArray = fontData = lblHistogramTitle.getFont().getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setHeight(10);
            ++n2;
        }
        this.histogramFont = new Font((Device)this.getFieldEditorParent().getDisplay(), fontData);
        lblHistogramTitle.setFont(this.histogramFont);
        GridData histogramTitleGridData = new GridData(4, 128, true, false);
        histogramTitleGridData.verticalIndent = 40;
        lblHistogramTitle.setLayoutData((Object)histogramTitleGridData);
        Label separator = new Label(this.getFieldEditorParent(), 258);
        separator.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite histogramComposite = new Composite(this.getFieldEditorParent(), 0);
        histogramComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        histogramComposite.setLayout((Layout)new GridLayout(1, false));
        BooleanFieldEditor histogramPopupCheckbox = new BooleanFieldEditor("histogramPopupCheckbox", "Histogramm Popup anzeigen", histogramComposite);
        this.addField((FieldEditor)histogramPopupCheckbox);
        Composite monthsComposite = new Composite(histogramComposite, 0);
        monthsComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        monthsComposite.setLayout((Layout)new GridLayout(2, false));
        Label lblAnzahlMonate = new Label(monthsComposite, 0);
        lblAnzahlMonate.setText("Anzahl Monate");
        this.txtAnzahlMonate = new Text(monthsComposite, 2048);
        this.txtAnzahlMonate.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtAnzahlMonate.setText(ConfigServiceHolder.getUser((String)"anzahlMonate", (String)"12"));
        this.txtAnzahlMonate.addModifyListener(event -> ConfigServiceHolder.setUser((String)"anzahlMonate", (String)this.txtAnzahlMonate.getText()));
    }

    public void dispose() {
        this.disposeResources();
        super.dispose();
    }

    private void disposeResources() {
        if (this.histogramFont != null && !this.histogramFont.isDisposed()) {
            this.histogramFont.dispose();
        }
    }

    public void init(IWorkbench workbench) {
        this.daysKeepUnseen = ConfigServiceHolder.getGlobal((String)"lab/keepUnseen", null);
        if (this.daysKeepUnseen == null || !this.isValidNumber(this.daysKeepUnseen)) {
            ConfigServiceHolder.setGlobal((String)"lab/keepUnseen", (String)"3");
            this.daysKeepUnseen = "3";
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        FieldEditor fe;
        super.propertyChange(event);
        if (event.getSource() instanceof FieldEditor && "lab/localRefValues".equals((fe = (FieldEditor)event.getSource()).getPreferenceName()) && event.getNewValue().equals(Boolean.TRUE)) {
            MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)Messages.LabSettings_enableUseLocalLabRefValues_title, (String)Messages.LabSettings_enableUseLocalLabRefValues_text);
        }
    }

    public boolean performOk() {
        if (this.isValidNumber(this.txtKeepUnseen.getText())) {
            ConfigServiceHolder.setGlobal((String)"lab/keepUnseen", (String)this.txtKeepUnseen.getText());
        }
        this.disposeResources();
        ConfigServiceHolder.setUser((String)"anzahlMonate", (String)this.txtAnzahlMonate.getText());
        return super.performOk();
    }

    private boolean isValidNumber(String nrString) {
        try {
            Integer.parseInt(nrString);
            return true;
        }
        catch (NumberFormatException nfe) {
            log.warn("Can't use [" + nrString + "] for KeepUnseen in lab settings as it can't be parsed to an integer.");
            return false;
        }
    }
}

