/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.controls;

import ch.elexis.core.data.interfaces.ILabItem;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.laboratory.actions.LaborParameterEditAction;
import ch.elexis.core.ui.laboratory.actions.LaborResultEditDetailAction;
import ch.elexis.core.ui.laboratory.actions.LaborResultOrderDeleteAction;
import ch.elexis.core.ui.laboratory.actions.LaborResultSetNonPathologicAction;
import ch.elexis.core.ui.laboratory.actions.LaborResultSetPathologicAction;
import ch.elexis.core.ui.laboratory.controls.LaborChartPopupManager;
import ch.elexis.core.ui.laboratory.controls.LaborResultsContentProvider;
import ch.elexis.core.ui.laboratory.controls.Messages;
import ch.elexis.core.ui.laboratory.controls.model.LaborItemResults;
import ch.elexis.core.ui.laboratory.controls.util.ChangeNewDateSelection;
import ch.elexis.core.ui.laboratory.controls.util.ChangeResultsDateSelection;
import ch.elexis.core.ui.laboratory.controls.util.DisplayDoubleClickListener;
import ch.elexis.core.ui.laboratory.controls.util.LabResultEditingSupport;
import ch.elexis.core.ui.laboratory.controls.util.LaborResultsLabelProvider;
import ch.elexis.core.ui.laboratory.views.LaborView;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LaborResultsComposite
extends Composite {
    public static final String ID = "ch.elexis.LaborResultsComposite";
    private final FormToolkit tk = UiDesk.getToolkit();
    private Form form;
    private Patient actPatient;
    public TreeViewer viewer;
    private TreeViewerFocusCellManager focusCell;
    private TreeViewerColumn newColumn;
    private int newColumnIndex;
    public static final String COLUMN_DATE_KEY = "labresult.date";
    private List<TreeViewerColumn> resultColumns = new ArrayList<TreeViewerColumn>();
    private LaborResultsContentProvider contentProvider = new LaborResultsContentProvider();
    private int columnOffset = 0;
    private boolean reloadPending;
    private static final int COLUMNS_PER_PAGE = 7;
    private TreeViewerColumn checkboxColumn;
    private List<TreeItem> selectedItems = new ArrayList<TreeItem>();
    private LaborView parentLaborView;
    private LaborChartPopupManager laborChartPopupManager;
    private boolean showHistogramPopup = ConfigServiceHolder.getUser((String)"histogramPopupCheckbox", (boolean)false);
    private boolean mouseTrackListenerAdded = false;
    private MouseTrackAdapter mouseTrackListener;

    public LaborResultsComposite(Composite parent, int style, LaborView parentLaborView) {
        super(parent, style);
        this.parentLaborView = parentLaborView;
        this.laborChartPopupManager = new LaborChartPopupManager(this.actPatient);
        this.createContent();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public int getColumnOffset() {
        return this.columnOffset;
    }

    public void setColumnOffset(int newOffset) {
        List<TimeTool> dates = this.contentProvider.getDates();
        if (dates.size() <= 7) {
            this.columnOffset = 0;
        } else if (newOffset + 7 <= dates.size() && newOffset >= 0) {
            this.columnOffset = newOffset;
        }
    }

    private void setInitialColumnOffset() {
        List<TimeTool> dates = this.contentProvider.getDates();
        int offset = dates.size() - 7;
        if (offset > 0) {
            this.setColumnOffset(offset);
        } else {
            this.setColumnOffset(0);
        }
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout());
        this.form = this.tk.createForm((Composite)this);
        this.form.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        this.viewer = new TreeViewer(body, 66336);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.getTree().addListener(13, event -> {
            if (event.detail == 32) {
                TreeItem item = (TreeItem)event.item;
                if (item.getChecked()) {
                    if (this.selectedItems.size() >= 5) {
                        item.setChecked(false);
                        MessageBox messageBox = new MessageBox(this.getShell(), 40);
                        messageBox.setMessage("Sie k\u00f6nnen maximal 5 Elemente ausw\u00e4hlen.");
                        messageBox.setText("Auswahlgrenze erreicht");
                        messageBox.open();
                    } else {
                        this.selectedItems.add(item);
                    }
                } else {
                    this.selectedItems.remove(item);
                }
                this.parentLaborView.setSelectedItems(this.selectedItems);
            }
        });
        this.checkboxColumn = new TreeViewerColumn(this.viewer, 0);
        this.checkboxColumn.getColumn().setWidth(0);
        this.checkboxColumn.getColumn().setText("");
        this.checkboxColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.focusCell = new TreeViewerFocusCellManager(this.viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewer));
        this.viewer.addDoubleClickListener((IDoubleClickListener)new DisplayDoubleClickListener(this));
        final MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                List<LabResult> results = LaborResultsComposite.this.getSelectedResults();
                if (results != null) {
                    mgr.add((IAction)new LaborResultSetPathologicAction(results, (StructuredViewer)LaborResultsComposite.this.viewer));
                    mgr.add((IAction)new LaborResultSetNonPathologicAction(results, (StructuredViewer)LaborResultsComposite.this.viewer));
                    mgr.add((IAction)new LaborResultEditDetailAction(results, (StructuredViewer)LaborResultsComposite.this.viewer));
                    mgr.add((IAction)new LaborResultOrderDeleteAction(results, (StructuredViewer)LaborResultsComposite.this.viewer));
                    mgr.add((IContributionItem)new Separator());
                    mgr.add((IAction)new LaborParameterEditAction(results, (StructuredViewer)LaborResultsComposite.this.viewer));
                }
            }
        });
        this.viewer.getControl().setMenu(mgr.createContextMenu(this.viewer.getControl()));
        TreeViewerColumn parameterColumn = new TreeViewerColumn(this.viewer, 0);
        parameterColumn.getColumn().setWidth(200);
        parameterColumn.getColumn().setText(Messages.Core_Parameter);
        parameterColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            private StringBuilder sb = new StringBuilder();

            public String getText(Object element) {
                if (element instanceof String) {
                    String groupName = (String)element;
                    if (groupName.length() > 2 && groupName.charAt(1) == ' ') {
                        groupName = groupName.substring(2);
                    }
                    return groupName;
                }
                if (element instanceof LaborItemResults) {
                    this.sb.setLength(0);
                    ILabItem item = ((LaborItemResults)element).getFirstResult().getItem();
                    this.sb.append("       " + item.getKuerzel()).append(" - ").append(item.getName()).append(" [").append(item.getUnit()).append("]");
                    return this.sb.toString();
                }
                return "";
            }
        });
        TreeViewerColumn referenceColumn = new TreeViewerColumn(this.viewer, 0);
        referenceColumn.getColumn().setWidth(100);
        referenceColumn.getColumn().setText(Messages.Core_Reference);
        referenceColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LaborItemResults) {
                    if (LaborResultsComposite.this.actPatient.getGeschlecht().equals("m")) {
                        return ((LaborItemResults)element).getFirstResult().getRefMale();
                    }
                    return ((LaborItemResults)element).getFirstResult().getRefFemale();
                }
                return "";
            }
        });
        this.newColumn = new TreeViewerColumn(this.viewer, 0);
        this.newColumn.getColumn().setWidth(5);
        TimeTool now = new TimeTool();
        this.newColumn.getColumn().setText("Neu (" + now.toString(4) + ")");
        this.newColumn.getColumn().setData(COLUMN_DATE_KEY, (Object)now);
        this.newColumn.getColumn().addSelectionListener((SelectionListener)new ChangeNewDateSelection(this.newColumn, this));
        this.newColumn.setLabelProvider((CellLabelProvider)new LaborResultsLabelProvider(this.newColumn));
        this.newColumn.setEditingSupport((EditingSupport)new LabResultEditingSupport(this, this.viewer, this.newColumn));
        this.newColumnIndex = 2;
        int i = 0;
        while (i < 7) {
            TreeViewerColumn column = new TreeViewerColumn(this.viewer, 0);
            column.getColumn().setWidth(75);
            column.getColumn().setText("");
            column.setLabelProvider((CellLabelProvider)new LaborResultsLabelProvider(column));
            column.getColumn().addSelectionListener((SelectionListener)new ChangeResultsDateSelection(column, this));
            this.resultColumns.add(column);
            ++i;
        }
        if (this.showHistogramPopup) {
            this.addTreeMouseTrackListener();
        }
    }

    private void addTreeMouseTrackListener() {
        this.mouseTrackListener = new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                if (LaborResultsComposite.this.laborChartPopupManager != null && !LaborResultsComposite.this.laborChartPopupManager.dispose()) {
                    LaborResultsComposite.this.laborChartPopupManager.dispose();
                }
                Point point = new Point(e.x, e.y);
                TreeItem item = LaborResultsComposite.this.viewer.getTree().getItem(point);
                LaborResultsComposite.this.laborChartPopupManager.dispose();
                LaborResultsComposite.this.createChartPopup(item, e);
            }

            public void mouseExit(MouseEvent e) {
                if (LaborResultsComposite.this.laborChartPopupManager != null && !LaborResultsComposite.this.laborChartPopupManager.dispose()) {
                    LaborResultsComposite.this.laborChartPopupManager.dispose();
                }
            }
        };
        this.viewer.getTree().addMouseTrackListener((MouseTrackListener)this.mouseTrackListener);
        this.mouseTrackListenerAdded = true;
    }

    public void createChartPopup(TreeItem item, MouseEvent e) {
        Object data = item.getData();
        if (data instanceof LaborItemResults) {
            this.laborChartPopupManager.createChartPopup(item, e, this.viewer, this.actPatient);
        }
    }

    public List<LabResult> getSelectedResults() {
        ViewerCell cell = this.focusCell.getFocusCell();
        return this.getSelectedResults(cell);
    }

    private List<LabResult> getSelectedResults(ViewerCell cell) {
        TreeViewerColumn column;
        TimeTool time;
        if (cell != null && cell.getColumnIndex() > 3 && (time = (TimeTool)(column = this.resultColumns.get(cell.getColumnIndex() - 4)).getColumn().getData(COLUMN_DATE_KEY)) != null && cell.getElement() instanceof LaborItemResults) {
            LaborItemResults results = (LaborItemResults)cell.getElement();
            return results.getResult(time.toString(9));
        }
        return null;
    }

    public String[] getPrintHeaders() {
        TreeColumn[] columns;
        ArrayList<String> ret = new ArrayList<String>();
        TreeColumn[] treeColumnArray = columns = this.viewer.getTree().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn = treeColumnArray[n2];
            if (treeColumn != this.newColumn.getColumn()) {
                ret.add(treeColumn.getText());
            }
            ++n2;
        }
        return ret.toArray(new String[ret.size()]);
    }

    public TreeItem[] getPrintRows() {
        ArrayList<TreeItem> ret = new ArrayList<TreeItem>();
        this.getAllItems(this.viewer.getTree(), ret);
        return ret.toArray(new TreeItem[ret.size()]);
    }

    private void getAllItems(Tree tree, List<TreeItem> allItems) {
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.getAllItems(item, allItems);
            ++n2;
        }
    }

    private void getAllItems(TreeItem currentItem, List<TreeItem> allItems) {
        TreeItem[] children = currentItem.getItems();
        int i = 0;
        while (i < children.length) {
            allItems.add(children[i]);
            this.getAllItems(children[i], allItems);
            ++i;
        }
    }

    public void reload() {
        this.viewer.getContentProvider().inputChanged((Viewer)this.viewer, null, (Object)LabResult.getGrouped((Patient)this.actPatient));
        int i = 0;
        while (i < this.resultColumns.size()) {
            this.resultColumns.get(i).getColumn().setData(COLUMN_DATE_KEY, null);
            this.resultColumns.get(i).getColumn().setText("");
            ++i;
        }
        List<TimeTool> dates = this.contentProvider.getDates();
        int i2 = 0;
        while (i2 < dates.size() && i2 < this.resultColumns.size() && i2 + this.columnOffset < dates.size()) {
            this.resultColumns.get(i2).getColumn().setText(dates.get(i2 + this.columnOffset).toString(4));
            this.resultColumns.get(i2).getColumn().setData(COLUMN_DATE_KEY, (Object)dates.get(i2 + this.columnOffset));
            ++i2;
        }
        this.viewer.refresh();
    }

    public void selectPatient(Patient patient) {
        this.actPatient = patient;
        if (!this.isVisible()) {
            this.reloadPending = true;
            return;
        }
        this.setRedraw(false);
        this.resetCheckboxes();
        this.viewer.setInput((Object)LabResult.getGrouped((Patient)this.actPatient));
        TimeTool now = new TimeTool();
        this.newColumn.getColumn().setData(COLUMN_DATE_KEY, (Object)now);
        this.newColumn.getColumn().setText("Neu (" + now.toString(4) + ")");
        this.setInitialColumnOffset();
        int i = 0;
        while (i < this.resultColumns.size()) {
            this.resultColumns.get(i).getColumn().setData(COLUMN_DATE_KEY, null);
            this.resultColumns.get(i).getColumn().setText("");
            ++i;
        }
        List<TimeTool> dates = this.contentProvider.getDates();
        int i2 = 0;
        while (i2 < dates.size() && i2 < this.resultColumns.size()) {
            this.resultColumns.get(i2).getColumn().setText(dates.get(i2 + this.columnOffset).toString(4));
            this.resultColumns.get(i2).getColumn().setData(COLUMN_DATE_KEY, (Object)dates.get(i2 + this.columnOffset));
            ++i2;
        }
        this.viewer.expandAll();
        this.setRedraw(true);
    }

    public void resetCheckboxes() {
        for (TreeItem item : this.selectedItems) {
            item.setChecked(false);
        }
        this.selectedItems.clear();
        this.parentLaborView.setSelectedItems(this.selectedItems);
    }

    public boolean setFocus() {
        boolean showHistogramPopup;
        if (this.reloadPending) {
            this.selectPatient(this.actPatient);
            this.reloadPending = false;
        }
        if (showHistogramPopup = ConfigServiceHolder.getUser((String)"histogramPopupCheckbox", (boolean)false)) {
            if (!this.mouseTrackListenerAdded) {
                this.addTreeMouseTrackListener();
                this.mouseTrackListenerAdded = true;
            }
        } else if (this.mouseTrackListenerAdded) {
            this.viewer.getTree().removeMouseTrackListener((MouseTrackListener)this.mouseTrackListener);
            this.mouseTrackListenerAdded = false;
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        }
        if (this.laborChartPopupManager != null && !this.laborChartPopupManager.dispose()) {
            this.laborChartPopupManager.dispose();
        }
        return super.setFocus();
    }

    public Patient getPatient() {
        return this.actPatient;
    }

    public void expandAll() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.expandAll();
        }
    }

    public void collapseAll() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.collapseAll();
        }
    }

    public void toggleNewColumn() {
        if (this.newColumn.getColumn().getWidth() > 10) {
            this.newColumn.getColumn().setWidth(5);
        } else {
            this.newColumn.getColumn().setWidth(100);
        }
        this.viewer.refresh();
    }

    public int[] getSkipIndex() {
        int[] ret = new int[]{this.newColumnIndex};
        return ret;
    }

    public void showCheckboxes(boolean show) {
        if (show) {
            this.checkboxColumn.getColumn().setWidth(70);
        } else {
            this.checkboxColumn.getColumn().setWidth(0);
        }
        this.viewer.refresh();
    }

    public List<TreeItem> getSelectedItems() {
        return this.selectedItems;
    }

    public void setSelectedItems(List<TreeItem> selectedItems) {
        this.selectedItems = selectedItems;
    }
}

