/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.text.docx.preference;

import ch.elexis.core.model.IImage;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.MimeType;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.icons.Images;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.LoggerFactory;

public class SignatureImageComposite
extends Composite {
    private Label userLbl;
    private Button globalBtn;
    private Button imageBtn;
    private IUser user;
    private IImage signatureImage;

    public SignatureImageComposite(IUser user, Composite parentComposite) {
        super(parentComposite, 0);
        this.user = user;
        this.signatureImage = CoreModelServiceHolder.get().load("signature_" + user.getId(), IImage.class).orElse(null);
        this.createContent();
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout(3, false));
        this.userLbl = new Label((Composite)this, 0);
        this.userLbl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.userLbl.setText(this.user.getId());
        this.globalBtn = new Button((Composite)this, 32);
        this.globalBtn.setText(" global ");
        this.globalBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigServiceHolder.get().set(SignatureImageComposite.this.user.getAssignedContact(), "", SignatureImageComposite.this.globalBtn.getSelection());
            }
        });
        this.globalBtn.setSelection(ConfigServiceHolder.get().get(this.user.getAssignedContact(), "", false));
        this.imageBtn = new Button((Composite)this, 8);
        this.imageBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SignatureImageComposite.this.signatureImage == null) {
                    FileDialog fd = new FileDialog(SignatureImageComposite.this.getShell(), 4096);
                    String filename = fd.open();
                    if (filename != null) {
                        try {
                            Throwable throwable = null;
                            Object var5_7 = null;
                            try (FileInputStream fis = new FileInputStream(new File(filename));){
                                SignatureImageComposite.this.signatureImage = (IImage)CoreModelServiceHolder.get().create(IImage.class);
                                SignatureImageComposite.this.signatureImage.setId("signature_" + SignatureImageComposite.this.user.getId());
                                SignatureImageComposite.this.signatureImage.setTitle("SignatureImage");
                                SignatureImageComposite.this.signatureImage.setDate(LocalDate.now());
                                SignatureImageComposite.this.signatureImage.setImage(IOUtils.toByteArray((InputStream)fis));
                                MimeType mimeType = MimeType.getByExtension((String)FilenameUtils.getExtension((String)filename));
                                SignatureImageComposite.this.signatureImage.setMimeType(mimeType);
                                CoreModelServiceHolder.get().save((Identifiable)SignatureImageComposite.this.signatureImage);
                                SignatureImageComposite.this.imageBtn.setImage(Images.IMG_DELETE.getImage());
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e1) {
                            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error setting signature image", (Object)e);
                        }
                    }
                } else {
                    CoreModelServiceHolder.get().remove((Identifiable)SignatureImageComposite.this.signatureImage);
                    SignatureImageComposite.this.signatureImage = null;
                    SignatureImageComposite.this.imageBtn.setImage(Images.IMG_NEW.getImage());
                }
            }
        });
        this.imageBtn.setImage(this.signatureImage != null ? Images.IMG_DELETE.getImage() : Images.IMG_NEW.getImage());
    }
}

