/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal.text;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.format.AddressFormatUtil;
import ch.elexis.core.model.format.PersonFormatUtil;
import ch.elexis.core.services.IContext;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.text.ITextPlaceholderResolver;
import ch.elexis.core.text.PlaceholderAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;

@Component
public class RechnungsstellerTextPlaceholderResolver
implements ITextPlaceholderResolver {
    public String getSupportedType() {
        return "Rechnungssteller";
    }

    public List<PlaceholderAttribute> getSupportedAttributes() {
        return Arrays.asList(RechnungsstellerAttribute.values()).stream().map(m -> new PlaceholderAttribute(this.getSupportedType(), m.name(), m.getLocaleText())).collect(Collectors.toList());
    }

    public Optional<String> replaceByTypeAndAttribute(IContext context, String attribute) {
        IContact biller = this.getIdentifiable(context).orElse(null);
        if (biller != null) {
            return Optional.ofNullable(this.replace(biller, attribute.toLowerCase()));
        }
        return Optional.empty();
    }

    public Optional<? extends Identifiable> getIdentifiable(IContext context) {
        IMandator mandantor = context.getTyped(IMandator.class).orElse(null);
        if (mandantor == null) {
            mandantor = context.getNamed(this.getSupportedType()).orElse(null);
        }
        if (mandantor != null) {
            return Optional.of(mandantor.getBiller());
        }
        return Optional.empty();
    }

    private String replace(IContact iContact, String lcAttribute) {
        RechnungsstellerAttribute mandantAttribut = (RechnungsstellerAttribute)this.searchEnum(RechnungsstellerAttribute.class, lcAttribute);
        switch (mandantAttribut) {
            case Anrede: {
                if (iContact.isPerson()) {
                    return PersonFormatUtil.getSalutation((IPerson)((IPerson)CoreModelServiceHolder.get().load(iContact.getId(), IPerson.class).get()));
                }
                return "";
            }
            case Name: {
                if (iContact.isPerson()) {
                    return String.valueOf(iContact.getDescription2()) + " " + iContact.getDescription1();
                }
                return iContact.getDescription1();
            }
            case Anschrift: {
                return AddressFormatUtil.getPostalAddress((IContact)iContact, (boolean)true);
            }
            case Anschriftzeile: {
                return AddressFormatUtil.getPostalAddress((IContact)iContact, (boolean)false);
            }
        }
        return null;
    }

    private static enum RechnungsstellerAttribute implements ILocalizedEnum
    {
        Name("Name des Rechnungssteller"),
        Anrede("Anrede des Rechnungssteller"),
        Anschrift("Mehrzeilige Anschrift"),
        Anschriftzeile("Einzeilige Anschrift");

        final String description;

        private RechnungsstellerAttribute(String description) {
            this.description = description;
        }

        public String getLocaleText() {
            return this.description;
        }
    }
}

