/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.eenv;

import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.eenv.AccessTokenUtil;
import ch.elexis.core.time.TimeUtil;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.TimerTask;
import org.apache.commons.lang3.StringUtils;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.representations.AccessTokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshAccessTokenTimerTask
extends TimerTask {
    private final KeycloakDeployment keycloakDeployment;
    private final IContextService contextService;
    private final Logger logger;

    public RefreshAccessTokenTimerTask(KeycloakDeployment keycloakDeployment, IContextService contextService) {
        this.keycloakDeployment = keycloakDeployment;
        this.contextService = contextService;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public void run() {
        this.contextService.getTyped(AccessToken.class).ifPresent(this::refreshAccessToken);
    }

    private void refreshAccessToken(AccessToken accessToken) {
        Optional activeUser = this.contextService.getActiveUser();
        if (!activeUser.isPresent()) {
            this.contextService.removeTyped(AccessToken.class);
            this.logger.warn("Found access-token but no active user. Removed access-token.");
            return;
        }
        String activeUserId = ((IUser)activeUser.get()).getId();
        if (!StringUtils.equals((CharSequence)activeUserId, (CharSequence)accessToken.getUsername())) {
            this.contextService.removeTyped(AccessToken.class);
            this.logger.warn("Found access-token for user [{}] but active user id [{}]. Removed access-token.", (Object)accessToken.getUsername(), (Object)activeUserId);
            return;
        }
        long accessTokenTimeLeft = accessToken.getAccessTokenExpiration().getTime() - new Date().getTime();
        if (accessTokenTimeLeft <= 60000L) {
            Date refreshTokenExpiration = accessToken.getAccessTokenExpiration();
            if (refreshTokenExpiration != null && refreshTokenExpiration.getTime() > new Date().getTime()) {
                try {
                    AccessTokenResponse invokeRefresh = ServerRequest.invokeRefresh((KeycloakDeployment)this.keycloakDeployment, (String)accessToken.getRefreshToken());
                    AccessToken _accessToken = AccessTokenUtil.load(invokeRefresh);
                    this.contextService.setTyped((Object)_accessToken);
                    this.logger.info("RT Refreshed access-token for [{}], valid until [{}], refresh until [{}]", new Object[]{activeUserId, TimeUtil.toLocalDateTime((Date)_accessToken.getAccessTokenExpiration()), TimeUtil.toLocalDateTime((Date)_accessToken.refreshTokenExpiration())});
                    return;
                }
                catch (IOException | ServerRequest.HttpFailure e) {
                    this.logger.warn("Failed to refresh access-token via refresh-token", e);
                }
            }
            HashMap<String, String> eventMap = new HashMap<String, String>();
            eventMap.put("title", "EE Login expired");
            eventMap.put("message", "Your EE login expired, please re-login to Elexis");
            this.logger.warn("Re-Login required, user informed");
            this.contextService.sendEvent("info/elexis/notification/warn", null, eventMap);
        }
    }
}

