/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.importer.div.importers;

import ch.elexis.core.importer.div.importers.ExcelWrapper;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IContactBuilder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.Gender;
import ch.elexis.core.ui.exchange.KontaktMatcher;
import ch.elexis.core.ui.importer.div.importers.KontaktImporter;
import ch.elexis.core.ui.importer.div.importers.MediportInsurerImporter;
import ch.elexis.core.ui.importer.div.importers.Messages;
import ch.elexis.core.ui.importer.div.importers.Presets;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Organisation;
import ch.rgw.tools.BinConverter;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VCard;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KontaktImporterBlatt
extends Composite {
    String filename;
    Label lbFileName;
    Combo cbMethods;
    boolean bKeepID;
    boolean mediportInsuererList;
    int method;
    private final Logger log = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    static final String[] methods = new String[]{"XLS", "CSV", Messages.KontaktImporterBlatt_kklistHeading};
    private static final String PRESET_RUSSI = "e3ad14dc49e27dbcc4771b41b34cdd902f9cfcc6";
    private static final String PRESET_UNIVERSAL = "275789de20bc918890cc753c49931e72166a4bc0";
    private static final String PRESET_HERTEL = "a4a9f3bd410443399ee05d5e033d94513a64239b";

    public KontaktImporterBlatt(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)this, 0).setText(Messages.Core_FileType);
        new Label((Composite)this, 0).setText(Messages.Core_File);
        this.cbMethods = new Combo((Composite)this, 4);
        this.cbMethods.setItems(methods);
        this.cbMethods.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                KontaktImporterBlatt.this.method = KontaktImporterBlatt.this.cbMethods.getSelectionIndex();
            }
        });
        this.cbMethods.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        Button bLoad = new Button((Composite)this, 8);
        bLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(KontaktImporterBlatt.this.getShell(), 4096);
                String file = fd.open();
                KontaktImporterBlatt.this.lbFileName.setText(file == null ? "" : file);
                KontaktImporterBlatt.this.filename = KontaktImporterBlatt.this.lbFileName.getText();
            }
        });
        bLoad.setText(Messages.Core_Select_File);
        this.lbFileName = new Label((Composite)this, 0);
        bLoad.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.lbFileName.setText(Messages.Core_Please_Select_Type_and_File);
        this.lbFileName.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)true));
        final Button btnMediportInsuranceList = new Button((Composite)this, 32);
        btnMediportInsuranceList.setText(Messages.KontaktImporterBlatt_MediportInsurer);
        btnMediportInsuranceList.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        btnMediportInsuranceList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KontaktImporterBlatt.this.mediportInsuererList = btnMediportInsuranceList.getSelection();
            }
        });
        final Button bKeep = new Button((Composite)this, 32);
        bKeep.setText(Messages.KontaktImporterBlatt_KeepID);
        bKeep.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)true));
        bKeep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KontaktImporterBlatt.this.bKeepID = bKeep.getSelection();
            }
        });
    }

    public boolean doImport(IProgressMonitor moni) {
        if (this.filename != null && this.filename.length() > 0) {
            switch (this.method) {
                case 0: {
                    return this.importExcel(this.filename, moni);
                }
                case 1: {
                    return this.importCSV(this.filename);
                }
                case 2: {
                    return this.importKK(this.filename);
                }
            }
        }
        return false;
    }

    public boolean importKK(String file) {
        ExcelWrapper exw = new ExcelWrapper();
        exw.setFieldTypes(new Class[]{Integer.class, String.class, String.class, String.class, String.class, Integer.class, Integer.class});
        exw.load(file, 0);
        int i = exw.getFirstRow() + 1;
        while (i <= exw.getLastRow()) {
            String[] row = exw.getRow(i).toArray(new String[0]);
            if (row != null && row.length == 7) {
                this.log.info(String.valueOf(Messages.KontaktImporterBlatt_Importing) + StringTool.join((String[])row, (String)" "));
                String bagnr = StringTool.getSafe((String[])row, (int)0);
                String name = StringTool.getSafe((String[])row, (int)1);
                String zweig = StringTool.getSafe((String[])row, (int)2);
                String adresse = StringTool.getSafe((String[])row, (int)3);
                String typ = StringTool.getSafe((String[])row, (int)4);
                String EANInsurance = StringTool.getSafe((String[])row, (int)5);
                String EANReceiver = StringTool.getSafe((String[])row, (int)6);
                String[] adr = this.splitAdress(adresse);
                Organisation kk = KontaktMatcher.findOrganisation((String)name, null, (String)adr[0], (String)adr[1], (String)adr[2], (KontaktMatcher.CreateMode)KontaktMatcher.CreateMode.CREATE);
                if (kk == null) {
                    return false;
                }
                kk.setInfoElement("EAN", (Object)EANInsurance);
                kk.setInfoElement("BAGNr", (Object)bagnr);
                kk.set("Bezeichnung2", zweig);
                kk.set("Kuerzel", StringTool.limitLength((String)(String.valueOf(Messages.Core_KK_Short) + StringTool.getFirstWord((String)name)), (int)39));
            }
            ++i;
        }
        return true;
    }

    String[] splitAdress(String adr) {
        String[] ret = new String[3];
        String[] m1 = adr.split("\\s*,\\s*");
        String[] plzOrt = m1[m1.length - 1].split(" ", 2);
        ret[0] = m1.length == 1 ? "" : m1[0];
        ret[1] = plzOrt[0];
        ret[2] = plzOrt.length > 1 ? plzOrt[1] : "";
        return ret;
    }

    public boolean importExcel(String file, IProgressMonitor moni) {
        ExcelWrapper exw = new ExcelWrapper();
        exw.load(file, 0);
        List row = exw.getRow(exw.getFirstRow());
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            for (String field : row) {
                digest.update(field.getBytes("iso-8859-1"));
            }
            byte[] dg = digest.digest();
            String vgl = BinConverter.bytesToHexStr((byte[])dg);
            this.log.info(String.valueOf(Messages.KontaktImporterBlatt_Importing) + " SHA1 war " + vgl + "\nFirst row was: " + row);
            if (vgl.equals(PRESET_RUSSI)) {
                return Presets.importRussi(exw, this.bKeepID, moni);
            }
            if (vgl.equals(PRESET_UNIVERSAL)) {
                return Presets.importUniversal(exw, this.bKeepID, moni);
            }
            if (vgl.equals(PRESET_HERTEL)) {
                return Presets.importHertel(exw, this.bKeepID, moni);
            }
            SWTHelper.showError((String)Messages.KontaktImporterBlatt_DatatypeErrorHeading, (String)Messages.KontaktImporterBlatt_DatatypeErrorText, (String)(String.valueOf(Messages.KontaktImporterBlatt_DatatypeErrorExplanation) + " SHA1 was " + vgl));
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
        }
        return false;
    }

    public boolean importXML(String file) {
        SWTHelper.showError((String)Messages.KontaktImporterBlatt_DatatypeErrorHeading, (String)Messages.KontaktImporterBlatt_DatatypeErrorText, (String)Messages.KontaktImporterBlatt_xmlImportNotSupported);
        return false;
    }

    public boolean importCSV(String file) {
        if (this.mediportInsuererList) {
            block5: {
                if (file == null) {
                    this.log.warn("No file selected");
                    SWTHelper.showError((String)Messages.Core_Select_File, (String)Messages.Core_Select_File, (String)Messages.Core_Please_Select_Type_and_File);
                    return false;
                }
                try {
                    String filename = file.toLowerCase();
                    if (filename.endsWith("csv")) break block5;
                    SWTHelper.showError((String)Messages.Core_FileType, (String)MessageFormat.format(Messages.KontaktImporterBlatt_DatatypeErrorNoCSV, file));
                    return false;
                }
                catch (FileNotFoundException e) {
                    this.log.error("Error parsing expected mediport insurer csv file [" + file + "]", (Throwable)e);
                    return false;
                }
            }
            List<Organisation> importedInsurer = MediportInsurerImporter.importCSVFromStream(new FileInputStream(file));
            SWTHelper.showInfo((String)Messages.KontaktImporterBlatt_csvImportMediportInsurerDone, (String)MessageFormat.format(Messages.KontaktImporterBlatt_csvImportMediportInsurerMsg, importedInsurer.size()));
            return true;
        }
        SWTHelper.showError((String)Messages.KontaktImporterBlatt_DatatypeErrorHeading, (String)Messages.KontaktImporterBlatt_DatatypeErrorText, (String)Messages.KontaktImporterBlatt_csvImportNotSupported);
        return false;
    }

    public boolean importVCard(String file) {
        String vorname;
        String name;
        Kontakt k;
        String fqname;
        String ort;
        String plz;
        String strasse;
        String gebdat;
        VCard vcard;
        block5: {
            try {
                vcard = new VCard((InputStream)new FileInputStream(file));
                gebdat = "";
                strasse = "";
                plz = "";
                ort = "";
                fqname = vcard.getElement("N");
                if (fqname != null) break block5;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        String[] names = vcard.getValue(fqname).split(";");
        String email = vcard.getElementValue("EMAIL");
        String address = vcard.getElementValue("ADR");
        String title = vcard.getElementValue("TITLE");
        String tel = vcard.getElementValue("TEL");
        if (address != null) {
            String[] adr = address.split(";");
            strasse = adr[2];
            plz = adr[5];
            ort = adr[3];
        }
        if ((k = KontaktImporter.queryKontakt(name = names[0], vorname = names[1], strasse, plz, ort, false)) == null) {
            IPerson iPerson = (IPerson)new IContactBuilder.PersonBuilder(CoreModelServiceHolder.get(), vorname, name, new TimeTool(gebdat).toLocalDate(), Gender.MALE).build();
            iPerson.setTitel(title);
            CoreModelServiceHolder.get().save((Identifiable)iPerson);
        }
        return true;
    }
}

