/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.text;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.text.EnhancedTextField;
import ch.elexis.core.ui.util.GenericObjectDropTarget;
import ch.elexis.core.ui.util.IKonsExtension;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public class ETFDropReceiver
implements GenericObjectDropTarget.IReceiver {
    EnhancedTextField etf;
    Hashtable<Class<?>, IKonsExtension> targets;

    ETFDropReceiver(EnhancedTextField et) {
        this.etf = et;
        this.targets = new Hashtable();
    }

    public void addReceiver(Class<?> clazz, IKonsExtension rec) {
        this.targets.put(clazz, rec);
    }

    public void removeReceiver(Class<?> clazz, IKonsExtension rec) {
        this.targets.remove(clazz);
    }

    private IKonsExtension getTargetForObject(Object o) {
        Class<?>[] interfaces;
        IKonsExtension ret = this.targets.get(o.getClass());
        if (ret == null && (interfaces = o.getClass().getInterfaces()) != null && interfaces.length > 0) {
            Class<?>[] classArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> inter = classArray[n2];
                ret = this.targets.get(inter);
                if (ret != null) break;
                ++n2;
            }
        }
        return ret;
    }

    @Override
    public void dropped(List<Object> list, DropTargetEvent e) {
        if (list != null && !list.isEmpty()) {
            Object object;
            IKonsExtension rec;
            Point point = UiDesk.getDisplay().getCursorLocation();
            Point mapped = UiDesk.getDisplay().map(null, (Control)this.etf.text, point);
            Point maxOffset = this.etf.text.getLocationAtOffset(this.etf.text.getCharCount());
            int pos = this.etf.text.getCharCount();
            if (mapped.y < maxOffset.y) {
                pos = this.etf.text.getOffsetAtLocation(new Point(0, mapped.y));
            }
            if ((rec = this.getTargetForObject(object = list.get(0))) != null) {
                rec.insert(object, pos);
            } else {
                Konsultation actKons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
                if (actKons != null) {
                    this.etf.text.insert(this.getLabel(object));
                    actKons.updateEintrag(this.etf.getContentsAsXML(), false);
                }
            }
        }
    }

    private String getLabel(Object object) {
        if (object instanceof PersistentObject) {
            return ((PersistentObject)object).getLabel();
        }
        if (object instanceof Identifiable) {
            return ((Identifiable)object).getLabel();
        }
        return object.toString();
    }

    @Override
    public boolean accept(List<Object> list) {
        return true;
    }
}

