/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange.elements;

import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.exchange.XChangeExporter;
import ch.elexis.core.ui.exchange.elements.MetaElement;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.data.Konsultation;
import ch.elexis.data.NamedBlob2;
import java.util.List;

public class MarkupElement
extends XChangeElement {
    public static final String XMLNAME = "markup";
    public static final String ATTR_POS = "pos";
    public static final String ATTR_LEN = "length";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_TEXT = "text";
    public static final String ATTRIB_HINT = "hint";
    public static final String ELEME_META = "meta";

    @Override
    public String getXMLName() {
        return XMLNAME;
    }

    public MarkupElement asExporter(XChangeExporter home, Samdas.XRef xref) {
        this.asExporter(home);
        this.setAttribute(ATTR_POS, Integer.toString(xref.getPos()));
        this.setAttribute(ATTR_LEN, Integer.toString(xref.getLength()));
        this.setAttribute(ATTR_TYPE, xref.getProvider());
        this.addMeta("id", xref.getID());
        this.addMeta("provider", xref.getProvider());
        if (this.shouldAddContent(xref)) {
            this.addContent(home, xref);
        }
        return this;
    }

    private void addContent(XChangeExporter home, Samdas.XRef xref) {
        NamedBlob2 contentBlob;
        if (xref.getProvider().toLowerCase().contains("privatnotizen") && (contentBlob = NamedBlob2.load((String)xref.getID())) != null && contentBlob.exists()) {
            this.addMeta("content", contentBlob.getString());
        }
    }

    private boolean shouldAddContent(Samdas.XRef xref) {
        return xref.getProvider().toLowerCase().contains("privatnotizen");
    }

    public void doImport(Konsultation kons) {
        if (this.getMeta("content") != null && this.getMeta("provider") != null) {
            String provider = this.getMeta("provider").getAttr("value");
            this.importContent(kons, provider, this.getMeta("id"), this.getMeta("content"));
        }
    }

    private void importContent(Konsultation kons, String provider, MetaElement metaId, MetaElement metaContent) {
        String id = metaId.getAttr("value");
        String content = metaContent.getAttr("value");
        Integer pos = Integer.parseInt(this.getAttr(ATTR_POS));
        Integer length = Integer.parseInt(this.getAttr(ATTR_LEN));
        if (provider.toLowerCase().contains("privatnotizen") && id.contains(":")) {
            String[] idparts = id.split(":");
            if (idparts.length > 1) {
                id = String.valueOf(kons.getMandant().getId()) + ":" + idparts[1];
            }
            NamedBlob2 contentBlob = NamedBlob2.create((String)id, (boolean)false);
            contentBlob.putString(content);
            Samdas samdas = new Samdas(kons.getEintrag().getHead());
            Samdas.Record record = samdas.getRecord();
            Samdas.XRef xref = new Samdas.XRef(provider, id, pos.intValue(), length.intValue());
            record.add((Samdas.Range)xref);
            kons.updateEintrag(samdas.toString(), true);
        }
    }

    public void addMeta(String name, String value) {
        MetaElement meta = new MetaElement().asExporter(this.sender, name, value);
        this.add(meta);
    }

    public MetaElement getMeta(String name) {
        List<? extends XChangeElement> meta = this.getChildren(ELEME_META, MetaElement.class);
        if (meta != null && !meta.isEmpty()) {
            for (MetaElement metaElement : meta) {
                if (!name.equals(metaElement.getAttr("name"))) continue;
                return metaElement;
            }
        }
        return null;
    }
}

