/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.FlatDataLoader;
import ch.elexis.core.ui.actions.PersistentObjectLoader;
import ch.elexis.core.ui.dialogs.KontaktErfassenDialog;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.dialogs.provider.KontaktSelektorLabelProvider;
import ch.elexis.core.ui.e4.providers.IdentifiableLabelProvider;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultControlFieldProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.data.BezugsKontakt;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Organisation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class KontaktSelektor
extends TitleAreaDialog
implements CommonViewer.PoDoubleClickListener {
    public static final int HINTSIZE = 12;
    public static final int HINT_NAME = 0;
    public static final int HINT_FIRSTNAME = 1;
    public static final int HINT_BIRTHDATE = 2;
    public static final int HINT_STREET = 3;
    public static final int HINT_ZIP = 4;
    public static final int HINT_PLACE = 5;
    public static final int HINT_PHONE = 6;
    public static final int HINT_ADD = 7;
    public static final int HINT_FAX = 8;
    public static final int HINT_MAIL = 9;
    public static final int HINT_SEX = 10;
    public static final int HINT_PATIENT = 11;
    CommonViewer cv;
    ViewerConfigurer vc;
    private final String title;
    private final String message;
    private Object selection;
    Button bAll;
    Button bPersons;
    Button bOrgs;
    KontaktFilter fp;
    FilterButtonAdapter fba;
    String[] hints;
    boolean showBezugsKontakt = false;
    boolean showMandatKontakt = false;
    String extraText = null;
    private ListViewer bezugsKontaktViewer = null;
    private ListViewer mandantenViewer = null;
    private boolean isSelecting = false;
    private final PersistentObjectLoader kl;
    private boolean enableEmptyField = false;
    private String emptyFieldLabel;
    private Class targetClass;

    public KontaktSelektor(Shell parentShell, Class which, String title, String message, String[] orderFields) {
        super(parentShell);
        this.targetClass = which;
        this.cv = new CommonViewer();
        this.fba = new FilterButtonAdapter();
        this.title = title;
        this.message = message;
        this.kl = new FlatDataLoader(this.cv, (Query<? extends PersistentObject>)new Query(which));
        this.kl.setOrderFields(orderFields);
        this.fp = new KontaktFilter(0);
    }

    public KontaktSelektor(Shell parentShell, Class<? extends PersistentObject> which, String t, String m, boolean showBezugsKontakt, String ... orderFields) {
        this(parentShell, which, t, m, orderFields);
        this.showBezugsKontakt = showBezugsKontakt;
    }

    public KontaktSelektor(Shell parentShell, Class<? extends PersistentObject> which, String t, String m, String extra, String ... orderFields) {
        this(parentShell, which, t, m, orderFields);
        this.extraText = extra;
    }

    public KontaktSelektor(Shell parentShell, Class<? extends PersistentObject> which, String t, String m, boolean showBezugsKontakt, boolean showMandatKontakt, String ... orderFields) {
        this(parentShell, which, t, m, showBezugsKontakt, orderFields);
        this.showMandatKontakt = showMandatKontakt;
    }

    public boolean close() {
        this.cv.removeDoubleClickListener(this);
        this.cv.dispose();
        return super.close();
    }

    public void setHints(String[] h) {
        this.hints = h;
        int i = 0;
        while (i < this.hints.length) {
            if (this.hints[i] == null) {
                this.hints[i] = "";
            }
            ++i;
        }
        if (!StringTool.isNothing((Object)this.hints[2])) {
            TimeTool tt = new TimeTool();
            this.hints[2] = tt.set(this.hints[2]) ? tt.toString(4) : "";
        }
        if (!StringTool.isNothing((Object)this.hints[10])) {
            this.hints[10] = this.hints[10].toLowerCase().startsWith("m") ? "m" : "w";
        }
    }

    protected Control createDialogArea(Composite parent) {
        GridData gd;
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        if (this.showMandatKontakt) {
            new Label(ret, 0).setText("Mandanten");
            Composite mandantenComposite = new Composite(ret, 0);
            mandantenComposite.setLayout((Layout)new GridLayout(1, false));
            gd = new GridData(4, 4, true, true);
            gd.heightHint = 130;
            mandantenComposite.setLayoutData((Object)gd);
            this.mandantenViewer = new ListViewer(mandantenComposite, 516);
            this.mandantenViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            this.mandantenViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.mandantenViewer.setLabelProvider((IBaseLabelProvider)new IdentifiableLabelProvider());
            IQuery query = CoreModelServiceHolder.get().getQuery(IMandator.class);
            List list = query.execute();
            this.mandantenViewer.setInput((Object)list);
            ScrollBar scrollBar = this.mandantenViewer.getList().getVerticalBar();
            scrollBar.setVisible(true);
            scrollBar.setEnabled(true);
            mandantenComposite.layout();
            this.mandantenViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (KontaktSelektor.this.isSelecting) {
                        return;
                    }
                    IStructuredSelection sel = (IStructuredSelection)KontaktSelektor.this.cv.getViewerWidget().getSelection();
                    if (sel.size() > 0) {
                        KontaktSelektor.this.isSelecting = true;
                        KontaktSelektor.this.cv.getViewerWidget().setSelection((ISelection)new StructuredSelection());
                        KontaktSelektor.this.isSelecting = false;
                    }
                }
            });
            this.mandantenViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    KontaktSelektor.this.okPressed();
                }
            });
        } else {
            this.mandantenViewer = null;
        }
        if (this.showBezugsKontakt) {
            new Label(ret, 0).setText("Bezugskontakte");
            this.bezugsKontaktViewer = new ListViewer(ret, 4);
            this.bezugsKontaktViewer.getControl().setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            this.bezugsKontaktViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    Patient patient = ElexisEventDispatcher.getSelectedPatient();
                    if (patient != null) {
                        Fall[] faelle;
                        ArrayList<Object> elements = new ArrayList<Object>();
                        ArrayList<String> addedKontakte = new ArrayList<String>();
                        elements.add(patient);
                        addedKontakte.add(patient.getId());
                        List bezugsKontakte = patient.getBezugsKontakte();
                        if (bezugsKontakte != null) {
                            for (BezugsKontakt bezugsKontakt : bezugsKontakte) {
                                elements.add(bezugsKontakt);
                                addedKontakte.add(bezugsKontakt.get("otherID"));
                            }
                        }
                        Fall[] fallArray = faelle = patient.getFaelle();
                        int n = faelle.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Fall fall = fallArray[n2];
                            String reqs = fall.getRequirements();
                            if (reqs != null) {
                                String[] stringArray = reqs.split(";");
                                int n3 = stringArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    Kontakt kontakt;
                                    String kontaktID;
                                    String req = stringArray[n4];
                                    String[] r = req.split(":");
                                    if (r.length >= 2 && r[1].equals("K") && !(kontaktID = fall.getInfoString(r[0])).startsWith("**ERROR") && (kontakt = Kontakt.load((String)kontaktID)).isValid()) {
                                        elements.add(kontakt);
                                        addedKontakte.add(kontakt.getId());
                                    }
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                        return elements.toArray();
                    }
                    return new Object[0];
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.bezugsKontaktViewer.setLabelProvider((IBaseLabelProvider)new KontaktSelektorLabelProvider());
            this.bezugsKontaktViewer.setInput((Object)this);
            this.bezugsKontaktViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (KontaktSelektor.this.isSelecting) {
                        return;
                    }
                    IStructuredSelection sel = (IStructuredSelection)KontaktSelektor.this.cv.getViewerWidget().getSelection();
                    if (sel.size() > 0) {
                        KontaktSelektor.this.isSelecting = true;
                        KontaktSelektor.this.cv.getViewerWidget().setSelection((ISelection)new StructuredSelection(), false);
                        KontaktSelektor.this.isSelecting = false;
                    }
                }
            });
        } else {
            this.bezugsKontaktViewer = null;
        }
        if (this.showBezugsKontakt) {
            new Label(ret, 0).setText("Andere Kontakte");
        }
        if (this.extraText != null) {
            new Label(ret, 64).setText(this.extraText);
        }
        this.vc = new ViewerConfigurer(this.kl, new KontaktSelektorLabelProvider(), new DefaultControlFieldProvider(this.cv, new String[]{"Kuerzel=" + Messages.Core_Kuerzel, "Bezeichnung1=" + Messages.Core_Description, "Bezeichnung2=" + Messages.Core_Firstname, "Geburtsdatum=" + Messages.Core_Enter_Birthdate}), new ViewerConfigurer.ButtonProvider(){

            @Override
            public Button createButton(final Composite parent) {
                Button ret = new Button(parent, 8);
                ret.setText("Neu erstellen...");
                ret.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if ((this).KontaktSelektor.this.hints == null) {
                            (this).KontaktSelektor.this.hints = new String[3];
                            (this).KontaktSelektor.this.hints[0] = (this).KontaktSelektor.this.vc.getControlFieldProvider().getValues()[1];
                        }
                        KontaktErfassenDialog ked = new KontaktErfassenDialog(parent.getShell(), (this).KontaktSelektor.this.hints);
                        ked.open();
                        (this).KontaktSelektor.this.selection = ked.getResult();
                        KontaktSelektor.this.okPressed();
                    }
                });
                return ret;
            }

            @Override
            public boolean isAlwaysEnabled() {
                return false;
            }
        }, new SimpleWidgetProvider(3, 0, this.cv));
        Composite types = new Composite(ret, 2048);
        types.setLayout((Layout)new FillLayout());
        types.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.bAll = new Button(types, 16);
        this.bPersons = new Button(types, 16);
        this.bOrgs = new Button(types, 16);
        this.bAll.setText("Alle");
        this.bPersons.setText("Personen");
        this.bOrgs.setText("Organisationen");
        this.bAll.addSelectionListener((SelectionListener)this.fba);
        this.bPersons.addSelectionListener((SelectionListener)this.fba);
        this.bOrgs.addSelectionListener((SelectionListener)this.fba);
        this.initContactTypeSelection();
        this.cv.create(this.vc, ret, 0, "1");
        ((DefaultControlFieldProvider)this.vc.getControlFieldProvider()).setFocusField(1);
        this.vc.getControlFieldProvider().setFocus();
        gd = SWTHelper.getFillGridData(1, true, 1, true);
        gd.heightHint = 100;
        this.cv.getViewerWidget().getControl().setLayoutData((Object)gd);
        this.setTitle(this.title);
        this.setMessage(this.message);
        this.vc.getContentProvider().startListening();
        this.cv.addDoubleClickListener(this);
        this.kl.addQueryFilter(this.fp);
        this.addSelectionChangedListener(this.bezugsKontaktViewer);
        this.addSelectionChangedListener(this.mandantenViewer);
        return ret;
    }

    private void initContactTypeSelection() {
        if (Person.class.isAssignableFrom(this.targetClass)) {
            this.bPersons.setSelection(true);
        } else if (Organisation.class.isAssignableFrom(this.targetClass)) {
            this.bOrgs.setSelection(true);
        } else {
            this.bAll.setSelection(true);
        }
    }

    private void addSelectionChangedListener(final ListViewer viewer) {
        if (viewer != null) {
            this.cv.getViewerWidget().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection sel;
                    if (KontaktSelektor.this.isSelecting) {
                        return;
                    }
                    if (viewer != null && (sel = (IStructuredSelection)viewer.getSelection()).size() > 0) {
                        KontaktSelektor.this.isSelecting = true;
                        viewer.setSelection((ISelection)new StructuredSelection(), false);
                        KontaktSelektor.this.isSelecting = false;
                    }
                }
            });
        }
    }

    public Object getSelection() {
        return this.selection;
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.Core_Select_Contact);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.enableEmptyField) {
            parent.setLayout((Layout)new GridLayout(3, false));
            Button btnClear = this.createButton(parent, 3, this.emptyFieldLabel != null ? this.emptyFieldLabel : Messages.KontaktSelector_clearField, false);
            btnClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    KontaktSelektor.this.selection = null;
                    KontaktSelektor.this.vc.getContentProvider().stopListening();
                    KontaktSelektor.this.close();
                }
            });
        } else {
            parent.setLayout((Layout)new GridLayout(2, false));
        }
        this.createButton(parent, 0, "OK", false);
        this.createButton(parent, 1, "Cancel", false);
    }

    protected void cancelPressed() {
        this.selection = null;
        this.vc.getContentProvider().stopListening();
        super.cancelPressed();
    }

    private Object getBezugsKontaktSelection() {
        IStructuredSelection sel;
        Object bezugsKontakt = null;
        if (this.bezugsKontaktViewer != null && (sel = (IStructuredSelection)this.bezugsKontaktViewer.getSelection()).size() > 0) {
            bezugsKontakt = sel.getFirstElement();
        }
        return bezugsKontakt;
    }

    private Object getMandatKontaktSelection() {
        IStructuredSelection sel;
        Object mandatKontakt = null;
        if (this.mandantenViewer != null && (sel = (IStructuredSelection)this.mandantenViewer.getSelection()).size() > 0) {
            mandatKontakt = sel.getFirstElement();
        }
        return mandatKontakt;
    }

    protected void okPressed() {
        Object bKSel = this.getBezugsKontaktSelection();
        Object mKSel = this.getMandatKontaktSelection();
        if (bKSel instanceof Kontakt) {
            this.selection = bKSel;
        } else if (bKSel instanceof BezugsKontakt) {
            BezugsKontakt bezugsKontakt = (BezugsKontakt)bKSel;
            Kontakt kontakt = Kontakt.load((String)bezugsKontakt.get("otherID"));
            if (kontakt.exists()) {
                this.selection = kontakt;
            }
        } else if (mKSel instanceof IContact) {
            IContact mandant = (IContact)mKSel;
            Kontakt kontakt = Kontakt.load((String)mandant.getId());
            this.selection = kontakt;
        } else if (this.selection == null) {
            Object[] sel = this.cv.getSelection();
            if (sel != null && sel.length > 0) {
                this.selection = sel[0];
            } else {
                Table tbl = (Table)this.cv.getViewerWidget().getControl();
                tbl.setSelection(0);
                if (this.cv.getSelection().length > 0) {
                    this.selection = this.cv.getSelection()[0];
                }
            }
        }
        this.vc.getContentProvider().stopListening();
        this.cv.removeDoubleClickListener(this);
        super.okPressed();
    }

    @Override
    public void doubleClicked(PersistentObject obj, CommonViewer cv) {
        this.okPressed();
    }

    public static Kontakt showInSync(Class<? extends Kontakt> clazz, String title, String message, String extra) {
        InSync rn = new InSync(clazz, title, message, extra, null, new String[0]);
        UiDesk.getDisplay().syncExec((Runnable)rn);
        return rn.ret;
    }

    public static Kontakt showInSync(Class<? extends Kontakt> clazz, String title, String message) {
        InSync rn = new InSync(clazz, title, message, null, null, new String[0]);
        UiDesk.getDisplay().syncExec((Runnable)rn);
        return rn.ret;
    }

    public static Kontakt showInSync(Class<? extends Kontakt> clazz, String title, String message, String extra, String[] hints) {
        InSync rn = new InSync(clazz, title, message, extra, hints, new String[0]);
        UiDesk.getDisplay().syncExec((Runnable)rn);
        return rn.ret;
    }

    public static Kontakt showInSync(Class<? extends Kontakt> clazz, String title, String message, String[] hints) {
        InSync rn = new InSync(clazz, title, message, null, hints, new String[0]);
        UiDesk.getDisplay().syncExec((Runnable)rn);
        return rn.ret;
    }

    public void enableEmptyFieldButton(String emptyFieldLabel) {
        this.enableEmptyFieldButton();
        this.emptyFieldLabel = emptyFieldLabel;
    }

    public void enableEmptyFieldButton() {
        this.enableEmptyField = true;
    }

    protected boolean isResizable() {
        return true;
    }

    class FilterButtonAdapter
    extends SelectionAdapter {
        FilterButtonAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (((Button)e.getSource()).getSelection()) {
                if (KontaktSelektor.this.bPersons.getSelection()) {
                    KontaktSelektor.this.fp.setType(1);
                } else if (KontaktSelektor.this.bOrgs.getSelection()) {
                    KontaktSelektor.this.fp.setType(2);
                } else {
                    KontaktSelektor.this.fp.setType(0);
                }
                KontaktSelektor.this.cv.notify(CommonViewer.Message.update);
            }
        }
    }

    private static class InSync
    implements Runnable {
        Kontakt ret;
        String title;
        String message;
        Class<? extends Kontakt> clazz;
        String extra;
        String[] hints;
        private String[] orderFields;

        InSync(Class<? extends Kontakt> clazz, String title, String message, String extra, String[] hints, String ... orderFields) {
            this.title = title;
            this.message = message;
            this.clazz = clazz;
            this.extra = extra;
            this.hints = hints;
            this.orderFields = orderFields;
            if (orderFields == null) {
                this.orderFields = new String[]{"Bezeichnung1", "Bezeichnung2", "Strasse", "Ort"};
            }
        }

        @Override
        public void run() {
            Shell shell = UiDesk.getDisplay().getActiveShell();
            KontaktSelektor ksl = new KontaktSelektor(shell, this.clazz, this.title, this.message, this.extra, this.orderFields);
            if (this.hints != null) {
                ksl.setHints(this.hints);
            }
            this.ret = ksl.open() == 0 ? (Kontakt)ksl.getSelection() : null;
        }
    }

    static class KontaktFilter
    implements PersistentObjectLoader.QueryFilter {
        int type;

        KontaktFilter(int t) {
            this.type = t;
        }

        void setType(int t) {
            this.type = t;
        }

        @Override
        public void apply(Query<? extends PersistentObject> qbe) {
            if (this.type == 1) {
                qbe.add("istPerson", "=", "1");
            } else if (this.type == 2) {
                qbe.add("istPerson", "=", "0");
            }
            qbe.orderBy(false, new String[]{"Bezeichnung1", "Bezeichnung2"});
        }
    }
}

