/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.mapper;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.util.fhir.transformer.helper.IPersonHelper;
import ch.elexis.core.findings.util.fhir.transformer.mapper.IdentifiableDomainResourceAttributeMapper;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IXidService;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Person;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Reference;

public class IPersonPersonAttributeMapper
implements IdentifiableDomainResourceAttributeMapper<IPerson, Person> {
    private IModelService modelService;
    private IXidService xidService;
    private IPersonHelper personHelper;

    public IPersonPersonAttributeMapper(IModelService modelService, IXidService xidService) {
        this.modelService = modelService;
        this.xidService = xidService;
        this.personHelper = new IPersonHelper();
    }

    @Override
    public void elexisToFhir(IPerson source, Person target, SummaryEnum summaryEnum, Set<Include> includes) {
        target.setId((IIdType)new IdDt(Person.class.getSimpleName(), source.getId()));
        this.mapMetaData((Identifiable)source, (DomainResource)target);
        if (SummaryEnum.DATA != summaryEnum) {
            this.mapNarrative((Identifiable)source, (DomainResource)target);
        }
        if (SummaryEnum.TEXT == summaryEnum || SummaryEnum.COUNT == summaryEnum) {
            return;
        }
        List<Identifier> identifiers = this.personHelper.getIdentifiers((IContact)source, this.xidService);
        identifiers.add(this.getElexisObjectIdentifier((Identifiable)source));
        target.setIdentifier(identifiers);
        target.setName(this.personHelper.getHumanNames(source));
        target.setGender(this.personHelper.getGender(source.getGender()));
        target.setBirthDate(this.personHelper.getBirthDate(source));
        target.setAddress(this.personHelper.getAddresses((IContact)source));
        target.setTelecom(this.personHelper.getContactPoints((IContact)source));
        target.setPhoto(this.personHelper.mapContactImage((IContact)source));
        if (source.isPatient()) {
            target.addLink().setTarget(new Reference((IIdType)new IdDt(Patient.class.getSimpleName(), source.getId())));
        }
        if (source.isMandator()) {
            target.addLink().setTarget(new Reference((IIdType)new IdDt(Practitioner.class.getSimpleName(), source.getId())));
        }
    }

    @Override
    public void fhirToElexis(Person source, IPerson target) {
        this.checkPromoteToPatient(source, target);
        this.personHelper.mapIdentifiers(source.getIdentifier(), (IContact)target);
        this.personHelper.mapHumanName(source.getName(), target);
        this.personHelper.mapAddress(source.getAddress(), (IContact)target);
        this.personHelper.mapGender(source.getGender(), target);
        this.personHelper.mapBirthDate(source.getBirthDate(), target);
        this.personHelper.mapTelecom(source.getTelecom(), (IContact)target);
        this.personHelper.mapContactImage(this.modelService, source.getPhoto(), target);
    }

    private void checkPromoteToPatient(Person source, IPerson target) {
        String value;
        Optional<Reference> patientReference;
        if (!target.isPatient() && !source.getLink().isEmpty() && (patientReference = source.getLink().stream().filter(e -> Objects.nonNull(e.getTarget())).map(e -> e.getTarget()).filter(e -> StringUtils.startsWith((CharSequence)e.getReference(), (CharSequence)Patient.class.getSimpleName())).findFirst()).isPresent() && StringUtils.equals((CharSequence)(value = patientReference.get().getReference()), (CharSequence)(String.valueOf(Patient.class.getSimpleName()) + "/" + target.getId()))) {
            target.setCode(null);
            target.setPatient(true);
        }
    }
}

