/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer.helper;

import ch.elexis.core.findings.IEncounter;
import ch.elexis.core.findings.util.fhir.transformer.helper.AbstractHelper;
import ch.elexis.core.findings.util.fhir.transformer.helper.FhirUtil;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.FallConstants;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.ICoverageBuilder;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.services.IModelService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Reference;

public class IEncounterHelper
extends AbstractHelper {
    private IModelService coreModelService;
    private IModelService findingsModelService;

    public IEncounterHelper(IModelService coreModelService, IModelService findingsModelService) {
        this.coreModelService = coreModelService;
        this.findingsModelService = findingsModelService;
    }

    public Optional<ch.elexis.core.model.IEncounter> createIEncounter(IEncounter iEncounter) {
        Optional<ch.elexis.core.model.IEncounter> ret = this.getIEncounter(iEncounter);
        if (!ret.isPresent()) {
            Optional<IPatient> patient = this.getPatient(iEncounter);
            Optional<IMandator> serviceProvider = this.getPerformer(iEncounter);
            if (patient.isPresent() && serviceProvider.isPresent()) {
                ICoverage fall = this.getOrCreateDefaultFall(patient.get());
                ch.elexis.core.model.IEncounter encounter = (ch.elexis.core.model.IEncounter)new IEncounterBuilder(this.coreModelService, fall, serviceProvider.get()).buildAndSave();
                Optional startTime = iEncounter.getStartTime();
                if (startTime.isPresent()) {
                    encounter.setDate(((LocalDateTime)startTime.get()).toLocalDate());
                } else {
                    encounter.setDate(LocalDate.now());
                }
                this.findingsModelService.save((Identifiable)encounter);
                ret = Optional.of(encounter);
            }
        }
        return ret;
    }

    private ICoverage getOrCreateDefaultFall(IPatient patient) {
        List coverages = patient.getCoverages();
        ICoverage defaultCoverage = this.lookUpDefaultFall(coverages);
        if (defaultCoverage == null) {
            defaultCoverage = this.createDefaultFall(patient);
            IEncounterHelper.acquireAndReleaseLock((Identifiable)defaultCoverage);
        }
        return defaultCoverage;
    }

    private ICoverage createDefaultFall(IPatient patient) {
        ICoverage ret = new ICoverageBuilder(this.coreModelService, patient, "online", FallConstants.TYPE_DISEASE, "KVG").buildAndSave();
        this.closeFall(ret);
        return ret;
    }

    private void closeFall(ICoverage fall) {
        LockResponse lockResponse = AbstractHelper.acquireLock((Identifiable)fall);
        if (lockResponse.isOk()) {
            fall.setDateTo(fall.getDateFrom());
            this.coreModelService.save((Identifiable)fall);
            AbstractHelper.releaseLock(lockResponse.getLockInfo());
        }
    }

    private ICoverage lookUpDefaultFall(List<ICoverage> faelle) {
        ICoverage ret = null;
        if (faelle != null) {
            for (ICoverage fall : faelle) {
                if (!"online".equals(fall.getDescription())) continue;
                if (ret == null) {
                    ret = fall;
                    continue;
                }
                if (ret == null || fall.getLastupdate().compareTo(ret.getLastupdate()) != 1) continue;
                ret = fall;
            }
        }
        if (ret != null && ret.getDateTo() == null) {
            this.closeFall(ret);
        }
        return ret;
    }

    private Optional<ch.elexis.core.model.IEncounter> getIEncounter(IEncounter iEncounter) {
        String IEncountersId = iEncounter.getConsultationId();
        if (IEncountersId != null && !IEncountersId.isEmpty()) {
            return this.coreModelService.load(IEncountersId, ch.elexis.core.model.IEncounter.class);
        }
        return Optional.empty();
    }

    public Optional<IMandator> getPerformer(IEncounter iEncounter) {
        return this.coreModelService.load(iEncounter.getMandatorId(), IMandator.class);
    }

    public Optional<IPatient> getPatient(IEncounter iEncounter) {
        return this.coreModelService.load(iEncounter.getPatientId(), IPatient.class);
    }

    public Optional<String> getMandatorId(Encounter fhirObject) {
        List participants = fhirObject.getParticipant();
        for (Encounter.EncounterParticipantComponent encounterParticipantComponent : participants) {
            Reference reference;
            if (!encounterParticipantComponent.hasIndividual() || !FhirUtil.isReferenceType(reference = encounterParticipantComponent.getIndividual(), Practitioner.class.getSimpleName())) continue;
            return FhirUtil.getId(reference);
        }
        return Optional.empty();
    }

    public Optional<String> getPatientId(Encounter fhirObject) {
        return FhirUtil.getId(fhirObject.getSubject());
    }
}

