/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.e4.dialog;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.types.Gender;
import ch.elexis.core.ui.icons.Images;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class IContactSelectorDialog
extends TitleAreaDialog {
    private final IModelService coreModelService;
    private final Class<? extends IContact> queryClass;
    private IContact selectedContact;
    private Text text;
    private TableViewer tableViewerContacts;
    private String initialSearchText;
    private List<? extends IContact> initialInput;
    private String _message;
    private String _title;

    public IContactSelectorDialog(Shell parentShell, IModelService coreModelService) {
        this(parentShell, coreModelService, IContact.class);
    }

    public IContactSelectorDialog(Shell parentShell, IModelService coreModelService, Class<? extends IContact> queryClass) {
        super(parentShell);
        this.coreModelService = coreModelService;
        this.queryClass = queryClass;
    }

    public void create() {
        super.create();
        if (this._title != null) {
            super.setTitle(this._title);
        } else {
            this.setTitle(Messages.Core_Please_Select_Contact);
        }
        super.setMessage(this._message);
        super.setTitle(this._title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.text = new Text(container, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.text.addListener(2, e -> this.refresh());
        this.text.setMessage("Suche ... mindestens 3 Zeichen");
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tcl_composite = new TableColumnLayout();
        composite.setLayout((Layout)tcl_composite);
        this.tableViewerContacts = new TableViewer(composite, 67584);
        this.tableViewerContacts.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewerContacts.addSelectionChangedListener(e -> {
            this.selectedContact = (IContact)this.tableViewerContacts.getStructuredSelection().getFirstElement();
        });
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewerContacts, 0);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IContact)element).getLabel();
            }

            public Image getImage(Object element) {
                IContact contact = (IContact)element;
                if (contact.isOrganization() || contact.isLaboratory()) {
                    return Images.IMG_ORGANISATION.getImage();
                }
                if (contact.isPatient()) {
                    return Gender.MALE == contact.asIPatient().getGender() ? Images.IMG_MANN.getImage() : Images.IMG_FRAU.getImage();
                }
                return Images.IMG_PERSON.getImage();
            }
        });
        TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnNewColumn, (ColumnLayoutData)new ColumnWeightData(100));
        tblclmnNewColumn.setText("New Column");
        if (this.initialSearchText != null) {
            this.text.setText(this.initialSearchText);
            this.refresh();
        }
        if (this.initialInput != null) {
            this.tableViewerContacts.setInput(this.initialInput);
        }
        return area;
    }

    private void refresh() {
        String _text = this.text.getText();
        if (StringUtils.isNotBlank((CharSequence)_text) && _text.length() > 2) {
            String value = "%" + _text + "%";
            IQuery query = this.coreModelService.getQuery(this.queryClass);
            query.startGroup();
            query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION1, IQuery.COMPARATOR.LIKE, (Object)value, true);
            query.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION2, IQuery.COMPARATOR.LIKE, (Object)value, true);
            query.or((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION3, IQuery.COMPARATOR.LIKE, (Object)value, true);
            query.andJoinGroups();
            query.limit(50);
            this.tableViewerContacts.setInput((Object)query.execute());
        } else {
            this.tableViewerContacts.setInput(Collections.emptyList());
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public IContact getSelectedContact() {
        return this.selectedContact;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    public void setSearchText(String searchText) {
        if (searchText != null) {
            if (this.text != null) {
                this.text.setText(searchText);
            } else {
                this.initialSearchText = searchText;
            }
        }
    }

    public void setInput(List<? extends IContact> initialInput) {
        this.initialInput = initialInput;
    }
}

