/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.data.interfaces.ILabResult;
import ch.elexis.core.model.ac.EvACEs;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.laboratory.views.Messages;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.Log;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;

public class LabNotSeenView
extends ViewPart
implements Heartbeat.HeartListener {
    public static final String ID = "ch.elexis.LabNotSeenView";
    CheckboxTableViewer tv;
    LabResult[] unseen = null;
    private long lastUpdate = 0L;
    private Log log = Log.get((String)((Object)((Object)this)).getClass().getName());
    private boolean inUpdate = false;
    private Table table;
    public static LabNotSeenComparator comparator;
    private static final String[] columnHeaders;
    private static final int[] colWidths;
    private IAction markAllAction;
    private IAction markPersonAction;

    static {
        columnHeaders = new String[]{Messages.Core_Patient, Messages.Core_Parameter, Messages.LabNotSeenView_normRange, Messages.Core_Date, Messages.Core_Value};
        colWidths = new int[]{250, 100, 60, 70, 50};
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.table = new Table(parent, 544);
        comparator = new LabNotSeenComparator();
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn tc = new TableColumn(this.table, 0);
            tc.setText(columnHeaders[i]);
            tc.setWidth(colWidths[i]);
            tc.addSelectionListener((SelectionListener)this.getSelectionAdapter(tc, i));
            ++i;
        }
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tv = new CheckboxTableViewer(this.table);
        this.tv.setComparator((ViewerComparator)comparator);
        this.tv.setContentProvider((IContentProvider)new LabNotSeenContentProvider());
        this.tv.setLabelProvider((IBaseLabelProvider)new LabNotSeenLabelProvider());
        this.tv.setUseHashlookup(true);
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (!sel.isEmpty() && sel.getFirstElement() instanceof LabResult) {
                    LabResult lr = (LabResult)sel.getFirstElement();
                    ElexisEventDispatcher.fireSelectionEvent((PersistentObject)lr.getPatient());
                }
            }
        });
        this.tv.addCheckStateListener(new ICheckStateListener(){
            boolean bDaempfung;

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!this.bDaempfung) {
                    this.bDaempfung = true;
                    LabResult lr = (LabResult)event.getElement();
                    boolean state = event.getChecked();
                    if (state) {
                        if (AccessControlServiceHolder.get().evaluate(EvACEs.LAB_SEEN)) {
                            lr.removeFromUnseen();
                        } else {
                            LabNotSeenView.this.tv.setChecked((Object)lr, false);
                        }
                    } else {
                        lr.addToUnseen();
                    }
                    this.bDaempfung = false;
                }
            }
        });
        this.makeActions();
        ViewMenus menu = new ViewMenus(this.getViewSite());
        menu.createToolbar(new IAction[]{this.markPersonAction, this.markAllAction});
        this.heartbeat();
        CoreHub.heart.addListener((Heartbeat.HeartListener)this, ConfigServiceHolder.getUser((String)"lab/heartrate_unseen", (int)1).intValue());
        this.tv.setInput((Object)this);
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                comparator.setColumn(index);
                LabNotSeenView.this.tv.getTable().setSortDirection(comparator.getDirection());
                LabNotSeenView.this.tv.getTable().setSortColumn(column);
                LabNotSeenView.this.tv.refresh();
            }
        };
        return selectionAdapter;
    }

    public void dispose() {
        CoreHub.heart.removeListener((Heartbeat.HeartListener)this);
        super.dispose();
    }

    public void setFocus() {
    }

    public void heartbeat() {
        long last = LabResult.getLastUpdateUnseen();
        if (this.lastUpdate != 0L && this.lastUpdate >= last) {
            this.log.log(Level.FINE, "Heartbeat unused");
            return;
        }
        this.lastUpdate = last;
        this.log.log(Level.FINE, "Heartbeat used");
        this.unseen = LabResult.getUnseen().toArray(new LabResult[0]);
        UiDesk.getDisplay().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!LabNotSeenView.this.inUpdate) {
                    LabNotSeenView.this.inUpdate = true;
                    if (LabNotSeenView.this.tv != null) {
                        Control control = LabNotSeenView.this.tv.getControl();
                        synchronized (control) {
                            if (LabNotSeenView.this.tv.getControl() != null && !LabNotSeenView.this.tv.getControl().isDisposed()) {
                                LabNotSeenView.this.tv.refresh();
                            }
                        }
                    }
                    LabNotSeenView.this.inUpdate = false;
                }
            }
        });
    }

    private void makeActions() {
        this.markAllAction = new RestrictedAction(EvACEs.LAB_SEEN, Messages.LabNotSeenView_markAll){
            {
                this.setToolTipText(Messages.LabNotSeenView_markAllToolTip);
                this.setImageDescriptor(Images.IMG_TICK.getImageDescriptor());
            }

            public void doRun() {
                boolean openConfirm = MessageDialog.openConfirm((Shell)LabNotSeenView.this.getViewSite().getShell(), (String)Messages.LabNotSeenView_reallyMarkCaption, (String)Messages.LabNotSeenView_markAllToolTip);
                if (openConfirm) {
                    LabNotSeenView.this.tv.setAllChecked(true);
                    for (LabResult lr : LabResult.getUnseen()) {
                        lr.removeFromUnseen();
                    }
                }
            }
        };
        this.markPersonAction = new RestrictedAction(EvACEs.LAB_SEEN, Messages.LabNotSeenView_markAllofPatient){
            {
                this.setToolTipText(Messages.LabNotSeenView_markAllOfPatientToolTip);
                this.setImageDescriptor(Images.IMG_PERSON_OK.getImageDescriptor());
            }

            public void doRun() {
                Patient act = ElexisEventDispatcher.getSelectedPatient();
                LabResult[] labResultArray = LabNotSeenView.this.unseen;
                int n = LabNotSeenView.this.unseen.length;
                int n2 = 0;
                while (n2 < n) {
                    LabResult lr = labResultArray[n2];
                    if (lr.getPatient().equals((Object)act)) {
                        lr.removeFromUnseen();
                        LabNotSeenView.this.tv.setChecked((Object)lr, true);
                    }
                    ++n2;
                }
            }
        };
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    public class LabNotSeenComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private boolean direction = true;

        public int getDirection() {
            return this.direction ? 1024 : 128;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = !this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = true;
            }
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            if (o1 instanceof ILabResult && o2 instanceof ILabResult) {
                ILabResult l1 = (ILabResult)o1;
                ILabResult l2 = (ILabResult)o2;
                int rc = 0;
                switch (this.propertyIndex) {
                    case 0: {
                        rc = l1.getLabOrder().getPatient().getLabel().compareTo(l2.getLabOrder().getPatient().getLabel());
                        break;
                    }
                    case 1: {
                        rc = l1.getLabOrder().getLabItem().getLabel().compareToIgnoreCase(l2.getLabOrder().getLabItem().getLabel());
                        break;
                    }
                    case 3: {
                        rc = l1.getDate().compareTo(l2.getDate());
                        break;
                    }
                    case 4: {
                        rc = l1.getItem().getKuerzel().compareToIgnoreCase(l2.getItem().getKuerzel());
                    }
                }
                if (this.direction) {
                    rc = -rc;
                }
                return rc;
            }
            return 0;
        }
    }

    class LabNotSeenContentProvider
    implements IStructuredContentProvider {
        LabNotSeenContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (LabNotSeenView.this.unseen == null) {
                return new Object[]{Messages.LabNotSeenView_loading};
            }
            return LabNotSeenView.this.unseen;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    static class LabNotSeenLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        LabNotSeenLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String) {
                return columnIndex == 0 ? (String)element : "";
            }
            LabResult lr = (LabResult)element;
            switch (columnIndex) {
                case 0: {
                    return lr.getPatient().getLabel();
                }
                case 1: {
                    return lr.getItem().getName();
                }
                case 2: {
                    Patient pat = lr.getPatient();
                    if (pat.getGeschlecht().equalsIgnoreCase("m")) {
                        return lr.getItem().getReferenceMale();
                    }
                    return lr.getItem().getReferenceFemale();
                }
                case 3: {
                    return lr.getDate();
                }
                case 4: {
                    return lr.getResult();
                }
            }
            return "?";
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof String) {
                return UiDesk.getColor((String)"grau");
            }
            LabResult lr = (LabResult)element;
            if (lr.isFlag(1)) {
                return UiDesk.getColor((String)"rot");
            }
            return UiDesk.getColor((String)"schwarz");
        }
    }
}

