/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IOrder;
import ch.elexis.core.data.interfaces.IOrderEntry;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.data.Artikel;
import ch.elexis.data.Bestellung;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Stock;
import org.apache.commons.lang3.StringUtils;

public class BestellungEntry
extends PersistentObject
implements IOrderEntry {
    public static final String TABLENAME = "BESTELLUNG_ENTRY";
    public static final String FLD_BESTELLUNG = "BESTELLUNG";
    public static final String FLD_ARTICLE_TYPE = "ARTICLE_TYPE";
    public static final String FLD_ARTICLE_ID = "ARTICLE_ID";
    public static final String FLD_STOCK = "STOCK";
    public static final String FLD_STATE = "STATE";
    public static final String FLD_COUNT = "COUNT";
    public static final String FLD_PROVIDER = "PROVIDER";
    public static final int STATE_OPEN = 0;
    public static final int STATE_ORDERED = 1;
    public static final int STATE_PARTIAL_DELIVER = 2;
    public static final int STATE_DONE = 3;

    static {
        BestellungEntry.addMapping(TABLENAME, FLD_BESTELLUNG, FLD_ARTICLE_TYPE, FLD_ARTICLE_ID, FLD_STOCK, "STATE=S:N:STATE", "COUNT=S:N:COUNT", FLD_PROVIDER);
    }

    protected BestellungEntry() {
    }

    protected BestellungEntry(String id) {
        super(id);
    }

    public static BestellungEntry load(String id) {
        return new BestellungEntry(id);
    }

    public BestellungEntry(Bestellung order, Artikel article, @Nullable Stock stock, @Nullable Kontakt provider, int count) {
        String[] fields = new String[]{FLD_BESTELLUNG, FLD_ARTICLE_TYPE, FLD_ARTICLE_ID, FLD_PROVIDER, FLD_STOCK};
        String[] values = new String[]{order.getId(), article.getClass().getName(), article.getId(), provider != null ? provider.getId() : null, stock != null ? stock.getId() : null};
        this.create(null, fields, values);
        this.set(FLD_COUNT, Integer.toString(count));
    }

    @Override
    public String getLabel() {
        return this.toString();
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    public int getCount() {
        return this.getInt(FLD_COUNT);
    }

    public void setCount(int count) {
        this.setInt(FLD_COUNT, count);
    }

    public void setState(int state) {
        this.setInt(FLD_STATE, state);
    }

    public int getState() {
        return this.getInt(FLD_STATE);
    }

    public Artikel getArticle() {
        String[] vals = this.get(false, FLD_ARTICLE_TYPE, FLD_ARTICLE_ID);
        if (StringUtils.isNotBlank((CharSequence)vals[1])) {
            return (Artikel)CoreHub.poFactory.createFromString(String.valueOf(vals[0]) + "::" + vals[1]);
        }
        return null;
    }

    public Kontakt getProvider() {
        String providerId = this.get(FLD_PROVIDER);
        if (StringUtils.isNotBlank((CharSequence)providerId)) {
            return Kontakt.load(providerId);
        }
        return null;
    }

    @Override
    public Stock getStock() {
        String stockId = this.get(FLD_STOCK);
        if (StringUtils.isNotBlank((CharSequence)stockId)) {
            return Stock.load(stockId);
        }
        return null;
    }

    public void setProvider(Kontakt provider) {
        if (provider == null) {
            this.set(FLD_PROVIDER, null);
        } else {
            this.set(FLD_PROVIDER, provider.getId());
        }
    }

    @Override
    public IOrder getOrder() {
        String orderId = this.get(FLD_BESTELLUNG);
        if (StringUtils.isNotBlank((CharSequence)orderId)) {
            return Bestellung.load(orderId);
        }
        return null;
    }
}

