/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.tasks.parts;

import ch.elexis.core.model.IUser;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.tasks.model.ITask;
import ch.elexis.core.tasks.model.ModelPackage;
import ch.elexis.core.time.TimeUtil;
import ch.elexis.core.ui.e4.parts.IRefreshablePart;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.tasks.internal.TaskModelServiceHolder;
import ch.elexis.core.ui.tasks.parts.ITaskComparators;
import ch.elexis.core.ui.tasks.parts.TaskResultLabelProvider;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.deferred.DeferredContentProvider;
import org.eclipse.jface.viewers.deferred.SetModel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class TaskLogPart
implements IDoubleClickListener,
IRefreshablePart {
    @Inject
    private ESelectionService selectionService;
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;
    @Inject
    private EPartService partService;
    private Composite tableViewerComposite;
    private Table tableResults;
    private TableViewer tableViewerResults;
    private SetModel inputModel;
    private DeferredContentProvider contentProvider;

    @PostConstruct
    public void createControls(Composite parent, EMenuService menuService) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        this.tableViewerComposite = new Composite(parent, 0);
        this.tableViewerComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tcLayout = new TableColumnLayout();
        this.tableViewerComposite.setLayout((Layout)tcLayout);
        this.tableViewerResults = new TableViewer(this.tableViewerComposite, 268503042);
        this.tableResults = this.tableViewerResults.getTable();
        this.tableResults.setHeaderVisible(true);
        this.tableResults.setLinesVisible(true);
        this.contentProvider = new DeferredContentProvider(ITaskComparators.ofRunAt());
        this.tableViewerResults.setContentProvider((IContentProvider)this.contentProvider);
        this.tableViewerResults.setUseHashlookup(true);
        this.tableViewerResults.addDoubleClickListener((IDoubleClickListener)this);
        TableViewerColumn tvcTaskDescriptor = new TableViewerColumn(this.tableViewerResults, 0);
        tvcTaskDescriptor.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ITask task = (ITask)element;
                String referenceId = task.getTaskDescriptor().getReferenceId();
                if (referenceId != null) {
                    return referenceId;
                }
                return task.getTaskDescriptor().getId();
            }
        });
        final TableColumn tblclmnTaskDescriptor = tvcTaskDescriptor.getColumn();
        tcLayout.setColumnData((Widget)tblclmnTaskDescriptor, (ColumnLayoutData)new ColumnPixelData(110, true, true));
        tblclmnTaskDescriptor.setText("Task");
        tblclmnTaskDescriptor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskLogPart.this.tableResults.setSortColumn(tblclmnTaskDescriptor);
                if (TaskLogPart.this.tableResults.getSortDirection() == 1024) {
                    TaskLogPart.this.contentProvider.setSortOrder(ITaskComparators.ofTaskDescriptorId());
                    TaskLogPart.this.tableResults.setSortDirection(128);
                } else {
                    TaskLogPart.this.contentProvider.setSortOrder(ITaskComparators.ofTaskDescriptorId().reversed());
                    TaskLogPart.this.tableResults.setSortDirection(1024);
                }
            }
        });
        TableViewerColumn tvcTrigger = new TableViewerColumn(this.tableViewerResults, 0);
        tvcTrigger.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                ITask task = (ITask)element;
                switch (task.getTriggerEvent()) {
                    case MANUAL: {
                        return Images.IMG_HAND.getImage();
                    }
                    case CRON: {
                        return Images.IMG_CLOCK.getImage();
                    }
                    case SYSTEM_EVENT: {
                        return Images.IMG_SYSTEM_MONITOR.getImage();
                    }
                    case OTHER_TASK: {
                        return Images.IMG_TASK.getImage();
                    }
                    case FILESYSTEM_CHANGE: {
                        return Images.IMG_SERVER_PENCIL.getImage();
                    }
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                return null;
            }
        });
        TableColumn tblclmnTrigger = tvcTrigger.getColumn();
        tblclmnTrigger.setAlignment(0x1000000);
        tcLayout.setColumnData((Widget)tblclmnTrigger, (ColumnLayoutData)new ColumnPixelData(22, true, false));
        TableViewerColumn tvcStartTime = new TableViewerColumn(this.tableViewerResults, 0);
        tvcStartTime.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ITask task = (ITask)element;
                return TimeUtil.formatSafe((LocalDateTime)task.getRunAt());
            }
        });
        final TableColumn tblclmnStartTime = tvcStartTime.getColumn();
        tcLayout.setColumnData((Widget)tblclmnStartTime, (ColumnLayoutData)new ColumnPixelData(110, true, true));
        tblclmnStartTime.setText("Startzeit");
        tblclmnStartTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskLogPart.this.tableResults.setSortColumn(tblclmnStartTime);
                if (TaskLogPart.this.tableResults.getSortDirection() == 1024) {
                    TaskLogPart.this.contentProvider.setSortOrder(ITaskComparators.ofRunAt());
                    TaskLogPart.this.tableResults.setSortDirection(128);
                } else {
                    TaskLogPart.this.contentProvider.setSortOrder(ITaskComparators.ofRunAt().reversed());
                    TaskLogPart.this.tableResults.setSortDirection(1024);
                }
            }
        });
        this.tableResults.setSortColumn(tblclmnStartTime);
        this.tableResults.setSortDirection(1024);
        TableViewerColumn tvcFinishTime = new TableViewerColumn(this.tableViewerResults, 0);
        tvcFinishTime.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ITask task = (ITask)element;
                return TimeUtil.formatSafe((LocalDateTime)task.getFinishedAt());
            }
        });
        final TableColumn tblclmnFinishTime = tvcFinishTime.getColumn();
        tcLayout.setColumnData((Widget)tblclmnFinishTime, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnFinishTime.setText("Endzeit");
        tblclmnFinishTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskLogPart.this.tableResults.setSortColumn(tblclmnFinishTime);
                if (TaskLogPart.this.tableResults.getSortDirection() == 1024) {
                    TaskLogPart.this.contentProvider.setSortOrder(ITaskComparators.ofFinishedAt());
                    TaskLogPart.this.tableResults.setSortDirection(128);
                } else {
                    TaskLogPart.this.contentProvider.setSortOrder(ITaskComparators.ofFinishedAt().reversed());
                    TaskLogPart.this.tableResults.setSortDirection(1024);
                }
            }
        });
        TableViewerColumn tvcState = new TableViewerColumn(this.tableViewerResults, 0);
        tvcState.setLabelProvider((CellLabelProvider)TaskResultLabelProvider.getInstance());
        final TableColumn tblclmnState = tvcState.getColumn();
        tcLayout.setColumnData((Widget)tblclmnState, (ColumnLayoutData)new ColumnPixelData(22, true, false));
        tblclmnState.setText("");
        tblclmnState.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskLogPart.this.tableResults.setSortColumn(tblclmnState);
                if (TaskLogPart.this.tableResults.getSortDirection() == 1024) {
                    TaskLogPart.this.contentProvider.setSortOrder(ITaskComparators.ofState());
                    TaskLogPart.this.tableResults.setSortDirection(128);
                } else {
                    TaskLogPart.this.contentProvider.setSortOrder(ITaskComparators.ofState().reversed());
                    TaskLogPart.this.tableResults.setSortDirection(1024);
                }
            }
        });
        TableViewerColumn tvcOwner = new TableViewerColumn(this.tableViewerResults, 0);
        tvcOwner.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ITask task = (ITask)element;
                IUser owner = task.getTaskDescriptor().getOwner();
                return owner != null ? owner.getId() : "NO-OWNER";
            }
        });
        final TableColumn tblclmnOwner = tvcOwner.getColumn();
        tcLayout.setColumnData((Widget)tblclmnOwner, (ColumnLayoutData)new ColumnPixelData(70, true, true));
        tblclmnOwner.setText("User");
        tblclmnOwner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskLogPart.this.tableResults.setSortColumn(tblclmnOwner);
                if (TaskLogPart.this.tableResults.getSortDirection() == 1024) {
                    TaskLogPart.this.contentProvider.setSortOrder(ITaskComparators.ofOwner());
                    TaskLogPart.this.tableResults.setSortDirection(128);
                } else {
                    TaskLogPart.this.contentProvider.setSortOrder(ITaskComparators.ofOwner().reversed());
                    TaskLogPart.this.tableResults.setSortDirection(1024);
                }
            }
        });
        TableViewerColumn tvcRunner = new TableViewerColumn(this.tableViewerResults, 0);
        tvcRunner.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ITask task = (ITask)element;
                return task.getRunner();
            }
        });
        final TableColumn tblclmnRunner = tvcRunner.getColumn();
        tcLayout.setColumnData((Widget)tblclmnRunner, (ColumnLayoutData)new ColumnPixelData(80, true, true));
        tblclmnRunner.setText("Runner");
        tblclmnRunner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskLogPart.this.tableResults.setSortColumn(tblclmnRunner);
                if (TaskLogPart.this.tableResults.getSortDirection() == 1024) {
                    TaskLogPart.this.contentProvider.setSortOrder(ITaskComparators.ofRunner());
                    TaskLogPart.this.tableResults.setSortDirection(128);
                } else {
                    TaskLogPart.this.contentProvider.setSortOrder(ITaskComparators.ofRunner().reversed());
                    TaskLogPart.this.tableResults.setSortDirection(1024);
                }
            }
        });
        this.tableViewerResults.addSelectionChangedListener(event -> {
            IStructuredSelection selection = this.tableViewerResults.getStructuredSelection();
            this.selectionService.setSelection((Object)selection.toList());
        });
        menuService.registerContextMenu((Object)this.tableResults, "ch.elexis.core.ui.tasks.popupmenu.tableresults");
        this.inputModel = new SetModel();
        this.tableViewerResults.setInput((Object)this.inputModel);
        this.refresh();
    }

    public DeferredContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void refresh(Map<Object, Object> filterParameters) {
        Job job = Job.create((String)"Update table", monitor -> {
            boolean showSystemTasks;
            IQuery taskQuery = TaskModelServiceHolder.get().getQuery(ITask.class);
            taskQuery.orderBy((EStructuralFeature)ModelPackage.Literals.IDENTIFIABLE__LASTUPDATE, IQuery.ORDER.DESC);
            boolean bl = showSystemTasks = filterParameters.get("sst") != null ? (Boolean)filterParameters.get("sst") : false;
            if (!showSystemTasks) {
                taskQuery.and((EStructuralFeature)ModelPackage.Literals.ITASK__SYSTEM, IQuery.COMPARATOR.EQUALS, (Object)false);
            }
            List results = taskQuery.execute();
            this.inputModel.set(results.toArray());
        });
        job.schedule();
    }

    @Focus
    public void setFocus() {
        this.tableResults.setFocus();
    }

    @Optional
    @Inject
    void deleteTask(@UIEventTopic(value="info/elexis/model/delete") ITask iTask) {
        this.inputModel.removeAll((Object[])new ITask[]{iTask});
        this.tableResults.deselectAll();
    }

    public void doubleClick(DoubleClickEvent event) {
        ITask selectedTask = (ITask)((StructuredSelection)event.getSelection()).getFirstElement();
        MPart taskDetailPart = this.partService.createPart("ch.elexis.core.ui.tasks.partdescriptor.taskdetail");
        taskDetailPart.getTransientData().put("task", selectedTask);
        MPartStack detailPartStack = (MPartStack)this.modelService.find("ch.elexis.core.ui.tasks.partstack.details", (MUIElement)this.application);
        if (detailPartStack != null && detailPartStack.isVisible()) {
            detailPartStack.getChildren().add(taskDetailPart);
            this.partService.activate(taskDetailPart);
        } else {
            this.partService.showPart(taskDetailPart, EPartService.PartState.VISIBLE);
        }
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }
}

