/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.views.provider;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.Gender;
import ch.elexis.core.ui.icons.Images;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ContactSelectorObservableMapLabelProvider
extends ObservableMapLabelProvider
implements ITableLabelProvider {
    SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
    private StringBuilder sb;

    public ContactSelectorObservableMapLabelProvider(IObservableMap[] observeMaps) {
        super(observeMaps);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        IContact k = (IContact)element;
        if (k.isOrganization()) {
            return Images.IMG_ORGANISATION.getImage();
        }
        if (k.isPerson()) {
            if (!k.isPatient()) {
                return Images.IMG_PERSON_GREY.getImage();
            }
            IPerson p = (IPerson)CoreModelServiceHolder.get().load(k.getId(), IPerson.class).get();
            if (p.getGender() == null) {
                Images.IMG_EMPTY_TRANSPARENT.getImage();
            }
            switch (p.getGender()) {
                case MALE: {
                    return Images.IMG_MANN.getImage();
                }
                case FEMALE: {
                    return Images.IMG_FRAU.getImage();
                }
            }
            return Images.IMG_QUESTION_MARK.getImage();
        }
        return Images.IMG_EMPTY_TRANSPARENT.getImage();
    }

    public String getColumnText(Object element, int columnIndex) {
        IContact contact = (IContact)element;
        if (contact.isOrganization()) {
            this.sb = new StringBuilder();
            if (contact.getDescription1() != null) {
                this.sb.append(String.valueOf(contact.getDescription1()) + " ");
            }
            if (contact.getDescription2() != null) {
                this.sb.append(contact.getDescription2());
            }
            return this.sb.toString();
        }
        if (contact.isPerson()) {
            IPerson person = (IPerson)CoreModelServiceHolder.get().load(contact.getId(), IPerson.class).get();
            this.sb = new StringBuilder();
            if (person.getTitel() != null) {
                this.sb.append(String.valueOf(person.getTitel()) + " ");
            }
            this.sb.append(String.valueOf(contact.getDescription1()) + ", ");
            this.sb.append(contact.getDescription2());
            if (person.getTitelSuffix() != null) {
                this.sb.append(", " + person.getTitelSuffix());
            }
            this.sb.append(" (" + this.geschlechtToLabel(person.getGender()) + ")");
            if (person.getDateOfBirth() != null) {
                this.sb.append(", " + person.getDateOfBirth().format(DateTimeFormatter.BASIC_ISO_DATE));
            }
            return this.sb.toString();
        }
        return contact.getDescription1();
    }

    private String geschlechtToLabel(Gender geschlecht) {
        if (geschlecht == null) {
            return "?";
        }
        switch (geschlecht) {
            case MALE: {
                return "m";
            }
            case FEMALE: {
                return "w";
            }
            case UNKNOWN: {
                return "?";
            }
        }
        return "";
    }
}

