/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.views.filter;

import ch.elexis.core.model.IContact;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class KontaktAnzeigeTextFieldViewerFilter
extends ViewerFilter {
    private String searchString;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.searchString == null) {
            return true;
        }
        IContact k = (IContact)element;
        if (this.searchString.startsWith("$")) {
            return true;
        }
        if (this.searchString.startsWith("#")) {
            String patNr;
            if (k.isPatient() && (patNr = k.getCode()).toLowerCase().equalsIgnoreCase(this.searchString.substring(1).trim())) {
                return true;
            }
        } else {
            String[] searchListComma;
            String desc1 = k.getDescription1() != null ? k.getDescription1().toLowerCase() : "";
            String desc2 = k.getDescription2() != null ? k.getDescription2().toLowerCase() : "";
            String[] stringArray = searchListComma = this.searchString.split(",");
            int n = searchListComma.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.contains(" ")) {
                    String searchA = String.valueOf(desc1) + " " + desc2;
                    String searchB = String.valueOf(desc2) + " " + desc1;
                    if (searchA.matches(".*" + string + ".*") || searchB.matches(".*" + string + ".*")) {
                        return true;
                    }
                } else if (desc1.matches(".*" + string + ".*") || desc2.matches(".*" + string + ".*")) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void setSearchText(String s) {
        this.searchString = s == null || s.length() == 0 || s.startsWith("#") ? s : s.toLowerCase();
        if (this.searchString != null) {
            this.searchString = this.searchString.replaceAll("[^#$, a-zA-Z0-9]", "");
        }
    }
}

